/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.ui.messages.objects.eventtrigger;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.qubership.automation.itf.core.model.condition.parameter.ConditionParameter;

public class UICondition {
    private String name;
    private String condition;
    private String value;
    private String etc;
    private int orderId;

    public UICondition() {
    }

    public UICondition(ConditionParameter conditionParameter) {
        this.setName(conditionParameter.getName());
        this.setCondition(conditionParameter.getCondition() == null ? "" : conditionParameter.getCondition().toString());
        this.setValue(conditionParameter.getValue());
        this.setOrderId(conditionParameter.getOrderId());
        if (conditionParameter.getEtc() != null) {
            this.setEtc(conditionParameter.getEtc().toString());
        }
    }

    public static List<UICondition> buildUiConditions(@Nonnull List<ConditionParameter> conditionParameters) {
        return conditionParameters.stream().map(UICondition::new).collect(Collectors.toList());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UICondition that = (UICondition)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.condition, that.condition) && Objects.equals(this.value, that.value) && Objects.equals(this.etc, that.etc);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.condition, this.value, this.etc);
    }

    public String toString() {
        return "Condition{name='" + this.name + '\'' + ", condition='" + this.condition + '\'' + ", value='" + this.value + '\'' + ", etc='" + this.etc + '\'' + '}';
    }

    public String getName() {
        return this.name;
    }

    public String getCondition() {
        return this.condition;
    }

    public String getValue() {
        return this.value;
    }

    public String getEtc() {
        return this.etc;
    }

    public int getOrderId() {
        return this.orderId;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setCondition(String condition) {
        this.condition = condition;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public void setEtc(String etc) {
        this.etc = etc;
    }

    public void setOrderId(int orderId) {
        this.orderId = orderId;
    }
}

