/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.ui.messages.objects.eventtrigger;

import java.util.ArrayList;
import java.util.List;
import org.qubership.automation.itf.core.model.common.Storable;
import org.qubership.automation.itf.core.model.condition.ConditionsHelper;
import org.qubership.automation.itf.core.model.jpa.system.stub.EventTrigger;
import org.qubership.automation.itf.core.model.jpa.system.stub.Situation;
import org.qubership.automation.itf.core.model.jpa.system.stub.SituationEventTrigger;
import org.qubership.automation.itf.core.util.manager.CoreObjectManager;
import org.qubership.automation.itf.ui.controls.util.ControllerConstants;
import org.qubership.automation.itf.ui.controls.util.ControllerHelper;
import org.qubership.automation.itf.ui.messages.objects.UIObject;
import org.qubership.automation.itf.ui.messages.objects.eventtrigger.UICondition;
import org.qubership.automation.itf.ui.messages.objects.eventtrigger.UIListen;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UIEventTrigger
extends UIObject {
    private static final Logger LOGGER = LoggerFactory.getLogger(UIEventTrigger.class);
    private UIListen listen;
    private String type;
    private String event;
    private String state;
    private String on;
    private List<UICondition> condition;

    public UIEventTrigger() {
    }

    public UIEventTrigger(Storable eventTrigger) {
        this((EventTrigger)eventTrigger);
    }

    public UIEventTrigger(EventTrigger eventTrigger) {
        this(eventTrigger, true);
    }

    public UIEventTrigger(EventTrigger eventTrigger, boolean isFullWithParent) {
        super((Storable)eventTrigger, isFullWithParent);
        this.event = eventTrigger.getState().toString();
        this.state = eventTrigger.getState().toString();
        if (eventTrigger instanceof SituationEventTrigger) {
            if (((SituationEventTrigger)eventTrigger).getOn() == null) {
                ((SituationEventTrigger)eventTrigger).setOn("Finish");
            }
            this.on = ((SituationEventTrigger)eventTrigger).getOn().toString();
            if (((SituationEventTrigger)eventTrigger).getSituation() != null) {
                try {
                    this.listen = new UIListen(((SituationEventTrigger)eventTrigger).getSituation());
                }
                catch (Exception e) {
                    this.listen = new UIListen();
                }
            }
            this.type = ControllerConstants.SITUATION_EVENT_TRIGGER_TYPE.getStringValue();
        } else {
            this.type = ControllerConstants.OPERATION_EVENT_TRIGGER_TYPE.getStringValue();
        }
        if (eventTrigger.getConditionParameters() != null) {
            this.setCondition(UICondition.buildUiConditions(eventTrigger.getConditionParameters()));
        }
    }

    public void fillTrigger(EventTrigger trigger) {
        trigger.setName(this.getName());
        if (trigger instanceof SituationEventTrigger) {
            UIListen uiListen = this.getListen();
            if (this.getOn() != null) {
                ((SituationEventTrigger)trigger).setOn(this.getOn());
            }
            if (uiListen != null) {
                ((SituationEventTrigger)trigger).setSituation((Situation)CoreObjectManager.getInstance().getManager(Situation.class).getById((Object)uiListen.getId()));
            } else {
                ((SituationEventTrigger)trigger).setSituation(null);
            }
        }
        if (this.getCondition() != null) {
            List conditionParameters = trigger.getConditionParameters() == null ? new ArrayList() : trigger.getConditionParameters();
            ConditionsHelper.fillConditionParameters(conditionParameters, ControllerHelper.toConditionParameters(this.getCondition()));
            trigger.setConditionParameters(conditionParameters);
        }
    }

    public UIListen getListen() {
        return this.listen;
    }

    public String getType() {
        return this.type;
    }

    public String getEvent() {
        return this.event;
    }

    public String getState() {
        return this.state;
    }

    public String getOn() {
        return this.on;
    }

    public List<UICondition> getCondition() {
        return this.condition;
    }

    public void setListen(UIListen listen) {
        this.listen = listen;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setEvent(String event) {
        this.event = event;
    }

    public void setState(String state) {
        this.state = state;
    }

    public void setOn(String on) {
        this.on = on;
    }

    public void setCondition(List<UICondition> condition) {
        this.condition = condition;
    }
}

