/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.ui.messages.objects.template;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.lang.reflect.InvocationTargetException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.qubership.automation.itf.core.model.common.Storable;
import org.qubership.automation.itf.core.model.interceptor.Interceptor;
import org.qubership.automation.itf.core.model.jpa.message.template.Template;
import org.qubership.automation.itf.core.util.descriptor.PropertyDescriptor;
import org.qubership.automation.itf.core.util.exception.TransportException;
import org.qubership.automation.itf.core.util.helper.Comparators;
import org.qubership.automation.itf.core.util.provider.TemplateProvider;
import org.qubership.automation.itf.core.util.transport.access.AccessTransport;
import org.qubership.automation.itf.core.util.transport.manager.TransportRegistryManager;
import org.qubership.automation.itf.ui.messages.objects.UIObject;
import org.qubership.automation.itf.ui.messages.objects.template.UITransportPropsForTemplate;
import org.qubership.automation.itf.ui.messages.objects.transport.UIProperty;
import org.qubership.automation.itf.ui.messages.objects.transport.interceptor.UIInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UITemplate
extends UIObject {
    private static final Logger LOGGER = LoggerFactory.getLogger(UITemplate.class);
    private String content;
    private ImmutableList<UITransportPropsForTemplate> transportProperties;
    private ImmutableList<UIProperty> headers;
    private Collection<UIInterceptor> transportInterceptors;

    public UITemplate(Storable template) {
        this((Template)template);
    }

    public UITemplate(Template template) {
        try {
            this.prepareUiTemplate((Template<? extends TemplateProvider>)template);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException | RemoteException | TransportException e) {
            LOGGER.error("UI Templete dosn't create:", e);
            throw new IllegalArgumentException(e);
        }
    }

    public UITemplate() {
    }

    public ImmutableList<UIProperty> getHeaders() {
        return this.headers;
    }

    public void setHeaders(List<UIProperty> headers) {
        this.headers = ImmutableList.copyOf(headers);
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public ImmutableList<UITransportPropsForTemplate> getTransportProperties() {
        return this.transportProperties;
    }

    public void setTransportProperties(List<UITransportPropsForTemplate> transportProperties) {
        this.transportProperties = ImmutableList.copyOf(transportProperties);
    }

    public Collection<UIInterceptor> getTransportInterceptors() {
        return this.transportInterceptors;
    }

    public void setTransportInterceptors(Collection<UIInterceptor> transportInterceptors) {
        this.transportInterceptors = transportInterceptors;
    }

    private void prepareUiTemplate(Template<? extends TemplateProvider> template) throws TransportException, RemoteException, ClassNotFoundException, IllegalAccessException, InstantiationException, NoSuchMethodException, InvocationTargetException {
        if (template != null) {
            this.defineObjectParam((Storable)template);
            this.setContent(template.getText());
            if (template.getHeaders() != null) {
                ArrayList headers = Lists.newArrayList();
                for (Map.Entry entry : template.getHeaders().entrySet()) {
                    UIProperty header = new UIProperty();
                    header.setName((String)entry.getKey());
                    Object value = entry.getValue();
                    if (value != null) {
                        header.setValue(value.toString());
                    }
                    headers.add(header);
                }
                this.setHeaders(headers);
            }
            this.setTransportProperties(this.buildUITransportProperties(template));
            this.setTransportInterceptors(this.getUIInterceptors(template));
        }
    }

    private List<UITransportPropsForTemplate> buildUITransportProperties(Template<? extends TemplateProvider> template) throws RemoteException, TransportException {
        ArrayList transportProperties = Lists.newArrayListWithCapacity((int)10);
        for (Map.Entry<String, AccessTransport> entry : TransportRegistryManager.getInstance().getTransports().entrySet()) {
            LinkedList uiProperties = Lists.newLinkedList();
            this.getPropertiesFromDescriptor(entry, uiProperties);
            if (uiProperties.isEmpty()) continue;
            transportProperties.add(new UITransportPropsForTemplate(entry.getKey(), entry.getValue().getUserName(), this.mergeWithExisting(uiProperties, (Map<String, String>)template.getTransportProperties(entry.getKey()))));
        }
        return transportProperties;
    }

    private Collection<UIInterceptor> getUIInterceptors(Template template) {
        ArrayList<UIInterceptor> result = new ArrayList<UIInterceptor>();
        List interceptors = template.getInterceptors();
        interceptors.sort(Comparators.INTERCEPTOR_COMPARATOR);
        for (Interceptor interceptor : interceptors) {
            try {
                result.add(new UIInterceptor(interceptor));
            }
            catch (Exception e) {
                LOGGER.error("Cannot instantiate the \"{}\" interceptor. Check that the appropriate interceptor's implementation wad added and interceptor successfully registered.", (Object)interceptor.getName());
                LOGGER.error("Stacktrace: ", (Throwable)e);
            }
        }
        return result;
    }

    @Nonnull
    private LinkedList<UIProperty> mergeWithExisting(@Nonnull LinkedList<UIProperty> uiProperties, @Nullable Map<String, String> propertiesFromTemplate) {
        if (propertiesFromTemplate == null) {
            return uiProperties;
        }
        for (UIProperty uiProperty : uiProperties) {
            uiProperty.setValue(propertiesFromTemplate.get(uiProperty.getName()));
        }
        return uiProperties;
    }

    private void getPropertiesFromDescriptor(Map.Entry<String, AccessTransport> transportEntry, LinkedList<UIProperty> uiProperties) throws TransportException {
        try {
            for (PropertyDescriptor propertyDescriptor : transportEntry.getValue().getProperties()) {
                if (!propertyDescriptor.isForTemplate()) continue;
                uiProperties.add(new UIProperty(propertyDescriptor));
            }
        }
        catch (RemoteException e) {
            throw new TransportException((Throwable)e);
        }
    }
}

