/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.ui.messages.objects.transport;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.qubership.automation.itf.core.model.common.Storable;
import org.qubership.automation.itf.core.model.jpa.environment.Environment;
import org.qubership.automation.itf.core.model.jpa.project.IntegrationConfig;
import org.qubership.automation.itf.core.model.jpa.transport.Configuration;
import org.qubership.automation.itf.core.util.descriptor.Extractor;
import org.qubership.automation.itf.core.util.descriptor.PropertyDescriptor;
import org.qubership.automation.itf.core.util.exception.NoDeployedTransportException;
import org.qubership.automation.itf.core.util.provider.PropertyProvider;
import org.qubership.automation.itf.core.util.registry.EngineIntegrationRegistry;
import org.qubership.automation.itf.core.util.transport.access.AccessTransport;
import org.qubership.automation.itf.core.util.transport.manager.TransportRegistryManager;
import org.qubership.automation.itf.ui.messages.objects.UIObject;
import org.qubership.automation.itf.ui.messages.objects.UITypedObject;
import org.qubership.automation.itf.ui.messages.objects.environment.UIEnvironment;
import org.qubership.automation.itf.ui.messages.objects.transport.UIProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UIConfiguration
extends UITypedObject {
    private static final Logger LOGGER = LoggerFactory.getLogger(UIConfiguration.class);
    private String userTypeName;
    private List<UIProperty> properties = Lists.newArrayList();

    public UIConfiguration() {
    }

    public UIConfiguration(Storable storable) {
        super(storable);
    }

    public UIConfiguration(UIObject object) {
        super(object);
    }

    public UIConfiguration(Configuration configuration) {
        super((Storable)configuration);
        this.userTypeName = configuration.getTypeName();
        this.setType(configuration.getTypeName());
    }

    public UIConfiguration(IntegrationConfig integrationConfig) {
        super((Storable)integrationConfig);
        this.setType(integrationConfig.getTypeName());
        this.userTypeName = integrationConfig.getTypeName();
        this.defineProperties(integrationConfig);
    }

    @Nonnull
    public static List<UIProperty> defineNonDeployed(@Nonnull Configuration transport) {
        ArrayList uiProperties = Lists.newArrayListWithExpectedSize((int)transport.size());
        for (Map.Entry entry : transport.entrySet()) {
            UIProperty uiProperty = new UIProperty();
            uiProperty.setName((String)entry.getKey());
            uiProperty.setUserName((String)entry.getKey() + "[Not deployed]");
            uiProperty.setDescription("Transport implementation for type " + transport.getTypeName() + " was not deployed correctly");
            uiProperty.setValue((String)entry.getValue());
            uiProperty.setOptional(Boolean.FALSE.toString());
            uiProperties.add(uiProperty);
        }
        return uiProperties;
    }

    public void defineProperties(Configuration configuration) {
        try {
            Class<?> aClass = Class.forName(configuration.getTypeName());
            if (PropertyProvider.class.isAssignableFrom(aClass)) {
                this.defineProperties(configuration, Extractor.extractProperties((PropertyProvider)((PropertyProvider)aClass.newInstance())));
            }
        }
        catch (Exception e) {
            LOGGER.error(String.format("Can't extract properties from %s for configuration %s", configuration.getTypeName(), configuration.getID()), (Throwable)e);
        }
    }

    public void fillUserTypeNameFromConfiguration(Configuration configuration) {
        try {
            AccessTransport remoteTransport;
            try {
                remoteTransport = TransportRegistryManager.getInstance().find(configuration.getTypeName());
            }
            catch (NoDeployedTransportException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
            if (remoteTransport == null) {
                this.setUserTypeName(configuration.getTypeName());
            } else {
                this.setUserTypeName(remoteTransport.getUserName());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setType(configuration.getTypeName());
        if (configuration.getParent() instanceof Environment) {
            this.setParent(new UIEnvironment((Environment)configuration.getParent()));
        }
    }

    public void defineProperties(Configuration configuration, List<PropertyDescriptor> properties) {
        this.properties = Lists.newArrayListWithExpectedSize((int)configuration.size());
        if (properties != null) {
            for (PropertyDescriptor descriptor : properties) {
                UIProperty uiProperty = new UIProperty(descriptor, configuration.get((Object)descriptor.getShortName()));
                this.properties.add(uiProperty);
            }
        } else {
            for (Map.Entry entry : configuration.entrySet()) {
                UIProperty uiProperty = new UIProperty();
                uiProperty.setName((String)entry.getKey());
                uiProperty.setUserName((String)entry.getKey() + " [unavailable]");
                uiProperty.setValue((String)entry.getValue());
                this.properties.add(uiProperty);
            }
        }
        Collections.sort(this.properties);
    }

    public void defineProperties(IntegrationConfig integrationConfig) {
        List properties = EngineIntegrationRegistry.getInstance().getProperties(integrationConfig.getTypeName());
        ArrayList uiProperties = Lists.newArrayListWithExpectedSize((int)integrationConfig.size());
        if (properties != null) {
            for (PropertyDescriptor descriptor : properties) {
                UIProperty uiProperty = new UIProperty(descriptor, integrationConfig.get((Object)descriptor.getShortName()));
                uiProperties.add(uiProperty);
            }
        } else {
            for (Map.Entry entry : integrationConfig.entrySet()) {
                UIProperty uiProperty = new UIProperty();
                uiProperty.setName((String)entry.getKey());
                uiProperty.setUserName((String)entry.getKey() + " [Integration not initialized]");
                uiProperty.setValue((String)entry.getValue());
                uiProperties.add(uiProperty);
            }
        }
        this.properties = uiProperties;
    }

    public String getUserTypeName() {
        return this.userTypeName;
    }

    public void setUserTypeName(String userTypeName) {
        this.userTypeName = userTypeName;
    }

    public List<UIProperty> getProperties() {
        return this.properties;
    }

    public void setProperties(List<UIProperty> properties) {
        this.properties = properties;
    }

    public Optional<UIProperty> getProperty(String name) {
        return this.properties.stream().filter(uiProperty -> name.equals(uiProperty.getName())).findFirst();
    }
}

