/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.ui.messages.objects.transport;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.jetbrains.annotations.NotNull;
import org.qubership.automation.itf.core.model.common.Storable;
import org.qubership.automation.itf.core.model.jpa.message.template.Template;
import org.qubership.automation.itf.core.model.jpa.transport.Configuration;
import org.qubership.automation.itf.core.model.jpa.transport.TransportConfiguration;
import org.qubership.automation.itf.core.util.TemplateHelper;
import org.qubership.automation.itf.core.util.descriptor.PropertyDescriptor;
import org.qubership.automation.itf.core.util.exception.TransportException;
import org.qubership.automation.itf.core.util.manager.CoreObjectManager;
import org.qubership.automation.itf.core.util.transport.manager.TransportRegistryManager;
import org.qubership.automation.itf.ui.messages.objects.UIObject;
import org.qubership.automation.itf.ui.messages.objects.integration.ec.UIECIConfiguration;
import org.qubership.automation.itf.ui.messages.objects.transport.UIProperty;
import org.qubership.automation.itf.ui.messages.objects.transport.interceptor.UIInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UITransport
extends UIECIConfiguration<TransportConfiguration> {
    private static final String INPUT_TYPE_REFERENCE = "reference";
    private static final Logger LOGGER = LoggerFactory.getLogger(UITransport.class);
    private String endpoint;
    private String status;
    private String mep;
    private String endpointPrefix;
    private Collection<UIInterceptor> transportInterceptors;

    public UITransport() {
    }

    public UITransport(Storable storable) {
        this((TransportConfiguration)storable);
    }

    public UITransport(TransportConfiguration transport) {
        super(transport);
        this.fillUserTypeNameFromConfiguration((Configuration)transport);
        this.endpoint = (String)StringUtils.defaultIfEmpty((CharSequence)transport.get((Object)"endpoint"), (CharSequence)"");
        if (transport.getMep() != null) {
            this.mep = transport.getMep().toString();
        }
        this.endpointPrefix = transport.getEndpointPrefix();
        try {
            this.defineProperties(transport);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void fillForQuickDisplay(@NotNull TransportConfiguration transport) {
        this.fillForQuickDisplay(transport, false);
    }

    public void fillForQuickDisplay(@NotNull TransportConfiguration transport, boolean toTableDisplay) {
        this.setId(transport.getID().toString());
        this.setClassName(transport.getClass().getName());
        this.setName(transport.getName());
        this.setType(transport.getTypeName());
        this.setMep(transport.getMep().toString());
        this.setVersion(NumberUtils.toInt((String)String.valueOf(transport.getVersion()), (int)-1));
        if (toTableDisplay) {
            this.setEndpoint((String)StringUtils.defaultIfEmpty((CharSequence)transport.get((Object)"endpoint"), (CharSequence)""));
            this.setEndpointPrefix(transport.getEndpointPrefix());
            this.setDescription(transport.getDescription());
            this.fillUserTypeNameFromConfiguration((Configuration)transport);
        }
    }

    public boolean defineProperties(TransportConfiguration transport) throws TransportException {
        ArrayList uiProperties;
        boolean transportDeployed;
        Map transportParameters = TransportRegistryManager.getInstance().getProperties(transport.getTypeName());
        boolean bl = transportDeployed = transportParameters != null;
        if (transportDeployed) {
            uiProperties = Lists.newArrayListWithExpectedSize((int)transportParameters.size());
            for (PropertyDescriptor descriptor : transportParameters.values()) {
                if (descriptor.isFromServer()) continue;
                UIProperty uiProperty = new UIProperty(descriptor, transport.get((Object)descriptor.getShortName()));
                if (INPUT_TYPE_REFERENCE.equals(uiProperty.getInputType()) && !"".equals(uiProperty.getValue())) {
                    String id = uiProperty.getValue();
                    if (StringUtils.isBlank((CharSequence)id)) {
                        uiProperty.setReferenceValue(null);
                        LOGGER.debug("Empty id of reference value for '{}' transport property", (Object)uiProperty.getUserName());
                    } else {
                        try {
                            Template storable;
                            if (Template.class.getName().equals(uiProperty.getReferenceClass())) {
                                storable = TemplateHelper.getById((Object)id);
                            } else {
                                Class<?> propertyType = Class.forName(uiProperty.getReferenceClass());
                                storable = CoreObjectManager.getInstance().getManager(propertyType.asSubclass(Storable.class)).getById((Object)id);
                            }
                            uiProperty.setReferenceValue(new UIObject((Storable)storable));
                        }
                        catch (Exception e) {
                            uiProperty.setReferenceValue(null);
                            LOGGER.debug("Error while getting the reference value for transport property '{}' by id {}", new Object[]{uiProperty.getUserName(), id, e});
                        }
                    }
                }
                uiProperties.add(uiProperty);
            }
        } else {
            uiProperties = UITransport.defineNonDeployed((Configuration)transport);
        }
        this.setProperties(uiProperties);
        return transportDeployed;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getMep() {
        return this.mep;
    }

    public void setMep(String mep) {
        this.mep = mep;
    }

    public String getEndpointPrefix() {
        return this.endpointPrefix;
    }

    public void setEndpointPrefix(String endpointPrefix) {
        this.endpointPrefix = endpointPrefix;
    }

    public Collection<UIInterceptor> getTransportInterceptors() {
        return this.transportInterceptors;
    }

    public void setTransportInterceptors(Collection<UIInterceptor> transportInterceptors) {
        this.transportInterceptors = transportInterceptors;
    }
}

