/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.ui.services.faststubs;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import org.bson.types.ObjectId;
import org.qubership.automation.itf.core.hibernate.spring.managers.executor.SituationObjectManager;
import org.qubership.automation.itf.core.model.FastStubsCandidate;
import org.qubership.automation.itf.core.model.jpa.system.stub.Situation;
import org.qubership.automation.itf.core.stub.fast.FastConfigurationRequest;
import org.qubership.automation.itf.core.stub.fast.FastConfigurationResponse;
import org.qubership.automation.itf.core.stub.fast.FastResponseConfig;
import org.qubership.automation.itf.core.stub.fast.FastStubConfigurationAction;
import org.qubership.automation.itf.core.stub.fast.ResponseDescription;
import org.qubership.automation.itf.core.stub.fast.StubEndpointConfig;
import org.qubership.automation.itf.core.stub.fast.TransportConfig;
import org.qubership.automation.itf.core.util.eds.ExternalDataManagementService;
import org.qubership.automation.itf.core.util.eds.model.FileEventType;
import org.qubership.automation.itf.core.util.eds.service.EdsContentType;
import org.qubership.automation.itf.core.util.manager.CoreObjectManager;
import org.qubership.automation.itf.executor.service.ExecutorToMessageBrokerSender;
import org.qubership.automation.itf.integration.users.UserService;
import org.qubership.automation.itf.ui.controls.FastStubsProcessingException;
import org.qubership.automation.itf.ui.model.User;
import org.qubership.automation.itf.ui.util.FileUploadHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class FastStubsService {
    private static final Logger log = LoggerFactory.getLogger(FastStubsService.class);
    private ObjectMapper objectMapper;
    private UserService userService;
    private ExternalDataManagementService externalDataManagementService;
    private ExecutorToMessageBrokerSender executorToMessageBrokerSender;

    @Autowired
    public FastStubsService(ExternalDataManagementService externalDataManagementService, ExecutorToMessageBrokerSender executorToMessageBrokerSender, @Qualifier(value="executorIntegrationObjectMapper") ObjectMapper objectMapper, UserService userService) {
        this.externalDataManagementService = externalDataManagementService;
        this.executorToMessageBrokerSender = executorToMessageBrokerSender;
        this.objectMapper = objectMapper;
        this.userService = userService;
    }

    public List<FastStubsCandidate> getFastStubsCandidates(List<BigInteger> operationIds, UUID projectUuid) {
        try {
            Optional fastStubsCandidates = ((SituationObjectManager)CoreObjectManager.getInstance().getSpecialManager(Situation.class, SituationObjectManager.class)).getFastStubsCandidates(projectUuid, operationIds);
            return fastStubsCandidates.orElse(new ArrayList());
        }
        catch (Exception e) {
            String error = String.format("An error occurred while retrieving the list of candidates. %s", Objects.nonNull(e.getCause()) ? e.getCause().getMessage() : e.getMessage());
            log.error(error, (Throwable)e);
            throw new FastStubsProcessingException(error);
        }
    }

    public FastConfigurationResponse generateFastStubsConfigs(FastConfigurationRequest fastConfigurationRequest, FastStubConfigurationAction action, UUID projectUuid) {
        FastConfigurationResponse fastConfigurationResponse = new FastConfigurationResponse();
        ArrayList<FastConfigurationResponse.FastInfoConfig> fastInfoConfigs = new ArrayList<FastConfigurationResponse.FastInfoConfig>();
        try {
            this.collectRequestFastConfigs(fastConfigurationRequest, fastInfoConfigs);
            FastResponseConfig fastResponseConfig = new FastResponseConfig(fastConfigurationRequest);
            for (TransportConfig transportConfig : fastResponseConfig.getTransportConfigs()) {
                for (final StubEndpointConfig stubEndpointConfig : transportConfig.getEndpoints()) {
                    FastResponseConfig fastConfig = new FastResponseConfig();
                    fastConfig.setProjectUuid(projectUuid.toString());
                    final TransportConfig trConfig = new TransportConfig();
                    trConfig.setTransportType(transportConfig.getTransportType());
                    trConfig.setEndpoints((List)new ArrayList<StubEndpointConfig>(){
                        {
                            this.add(stubEndpointConfig);
                        }
                    });
                    fastConfig.setTransportConfigs((List)new ArrayList<TransportConfig>(){
                        {
                            this.add(trConfig);
                        }
                    });
                    String configAsString = this.objectMapper.writeValueAsString((Object)fastConfig);
                    String fileName = String.format("%s__%s__%s.json", projectUuid, transportConfig.getTransportType().name(), URLEncoder.encode(stubEndpointConfig.getConfiguredEndpoint(), "UTF-8"));
                    this.storeFileAndNotifyInstances(fileName, configAsString, this.userService.getCurrentUserInfo(), projectUuid);
                    this.collectAppliedFastConfigs(stubEndpointConfig, fastInfoConfigs);
                }
            }
            fastConfigurationResponse.setFastInfoConfigs(fastInfoConfigs);
        }
        catch (Exception e) {
            String error = String.format("Error while generate fast stubs configuration. %s", Objects.nonNull(e.getCause()) ? e.getCause().getMessage() : e.getMessage());
            log.error(error, (Throwable)e);
            throw new FastStubsProcessingException(error);
        }
        return fastConfigurationResponse;
    }

    private void collectRequestFastConfigs(FastConfigurationRequest fastConfigurationRequest, List<FastConfigurationResponse.FastInfoConfig> fastInfoConfigs) {
        fastConfigurationRequest.getTransportConfigs().forEach(fastTransportConfig -> {
            StubEndpointConfig.TransportTypes transportType = fastTransportConfig.getTransportType();
            fastTransportConfig.getSystems().forEach(fastSystem -> fastSystem.getOperations().forEach(fastOperation -> fastOperation.getSituations().forEach(fastSituation -> {
                FastConfigurationResponse.FastInfoConfig fastInfoConfig = new FastConfigurationResponse.FastInfoConfig();
                fastInfoConfig.setTransportType(transportType);
                fastInfoConfig.setSituationId(fastSituation.getId());
                fastInfoConfig.setIsApplied(Boolean.FALSE);
                fastInfoConfigs.add(fastInfoConfig);
            })));
        });
    }

    private void collectAppliedFastConfigs(StubEndpointConfig stubEndpointConfig, List<FastConfigurationResponse.FastInfoConfig> fastInfoConfigs) {
        Optional<FastConfigurationResponse.FastInfoConfig> optionalFastInfoConfig;
        stubEndpointConfig.getConditionalResponses().forEach(responseDescription -> {
            Optional<FastConfigurationResponse.FastInfoConfig> optionalFastInfoConfig = fastInfoConfigs.stream().filter(fastInfoConfig -> fastInfoConfig.getSituationId().equals(responseDescription.getId())).findFirst();
            if (optionalFastInfoConfig.isPresent()) {
                FastConfigurationResponse.FastInfoConfig fastInfoConfig2 = optionalFastInfoConfig.get();
                fastInfoConfig2.setIsApplied(Boolean.TRUE);
            }
        });
        ResponseDescription defaultResponse = stubEndpointConfig.getDefaultResponse();
        if (Objects.nonNull(defaultResponse) && (optionalFastInfoConfig = fastInfoConfigs.stream().filter(fastInfoConfig -> fastInfoConfig.getSituationId().equals(defaultResponse.getId())).findFirst()).isPresent()) {
            FastConfigurationResponse.FastInfoConfig fastInfoConfig2 = optionalFastInfoConfig.get();
            fastInfoConfig2.setIsApplied(Boolean.TRUE);
        }
    }

    private void storeFileAndNotifyInstances(String fileName, String content, User user, UUID projectUuid) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(content.getBytes());
        ObjectId storedObjectId = this.externalDataManagementService.getExternalStorageService().store(EdsContentType.FAST_STUB.getStringValue(), projectUuid, user.getName(), Objects.isNull(user.getId()) ? null : UUID.fromString(user.getId()), "", fileName, (InputStream)byteArrayInputStream);
        FileUploadHelper.checkStoredObjectIdAndSendMessageToExternalDataStorageUpdateTopic(storedObjectId, fileName, "", EdsContentType.FAST_STUB.getStringValue(), projectUuid, byteArrayInputStream, FileEventType.UPLOAD, this.executorToMessageBrokerSender, projectUuid.toString());
        byteArrayInputStream.close();
    }
}

