/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.ui.tree;

import com.google.common.collect.Lists;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import org.qubership.automation.itf.core.report.ReportObject;
import org.qubership.automation.itf.ui.tree.TreeNode;
import org.qubership.automation.itf.ui.tree.TreeNodeBuilder;
import org.qubership.automation.itf.ui.tree.TreeNodeTypes;

public class TreeNodeUtils {
    public static List<ReportObject> getReportObjects(@Nonnull List<Object[]> objects) {
        ArrayList list = Lists.newArrayList();
        objects.forEach(object -> list.add(TreeNodeUtils.getReportObject(object)));
        return list;
    }

    public static List<TreeNode> createTreeNodesByReport(List<ReportObject> reportObjects, String ... neededTypes) {
        ArrayList nodes = Lists.newArrayList();
        reportObjects = TreeNodeUtils.cutExcess(reportObjects, neededTypes);
        TreeNodeUtils.fillingTree(reportObjects, nodes);
        return nodes;
    }

    static ReportObject getReportObject(@Nonnull Object[] object) {
        if (object.length != 10) {
            throw new IllegalArgumentException("Object isn't correct: it has " + object.length + " elements, but 10 are required!");
        }
        ReportObject reportObject = new ReportObject();
        reportObject.setId((BigInteger)object[0]);
        reportObject.setParent((BigInteger)object[1]);
        reportObject.setType((String)object[2]);
        reportObject.setDescription((String)object[3]);
        reportObject.setPath((String)object[4]);
        reportObject.setLevel((Integer)object[5]);
        reportObject.setStatus((String)object[6]);
        reportObject.setDuration((String)object[7]);
        reportObject.setStartTime((String)object[8]);
        reportObject.setEndTime((String)object[9]);
        return reportObject;
    }

    static TreeNode buildNodeByReportObject(List<ReportObject> children, ReportObject reportObject, Integer parentLevel) {
        return new TreeNodeBuilder(reportObject.getId()).addText(reportObject.getDescription()).addStatus(reportObject.getStatus()).findAndAddChildNode(children, parentLevel + 1).addTags(reportObject.getDuration()).addStartTime(reportObject.getStartTime()).addEndTime(reportObject.getEndTime()).build();
    }

    static void fillingTree(List<ReportObject> reportObjects, ArrayList<TreeNode> nodes) {
        Iterator<ReportObject> iterator = reportObjects.iterator();
        while (iterator.hasNext()) {
            ReportObject reportObject = iterator.next();
            iterator.remove();
            Integer parentLevel = reportObject.getLevel();
            if (parentLevel != 1) continue;
            nodes.add(TreeNodeUtils.buildNodeByReportObject(Lists.newArrayList(reportObjects), reportObject, parentLevel));
        }
    }

    static List<ReportObject> cutExcess(List<ReportObject> reportObjects, String ... correctTypes) {
        ArrayList savedReportObjects = Lists.newArrayList();
        TreeNodeUtils.moveToSavedCollectionIfHasType(reportObjects, savedReportObjects, Lists.newArrayList((Object[])correctTypes));
        return savedReportObjects;
    }

    static void setCorrectParent(List<ReportObject> reportObjects, ReportObject oldParent) {
        for (ReportObject object : reportObjects) {
            if (object.getParent().equals(oldParent.getId())) {
                object.setParent(oldParent.getParent());
            }
            TreeNodeUtils.setCorrectLevel(object);
        }
    }

    static void moveToSavedCollectionIfHasType(List<ReportObject> reportObjects, List<ReportObject> savedReportObjects, List<String> types) {
        for (ReportObject reportObject : reportObjects) {
            if (types.contains(reportObject.getType())) {
                savedReportObjects.add(reportObject);
                continue;
            }
            TreeNodeUtils.setCorrectParent(reportObjects, reportObject);
        }
    }

    private static void setCorrectLevel(ReportObject object) {
        if (object.getType().equals(TreeNodeTypes.SITUATION_INSTANCE.toString())) {
            object.setLevel(Integer.valueOf(1));
        } else if (object.getType().equals(TreeNodeTypes.STEP_INSTANCE.toString())) {
            object.setLevel(Integer.valueOf(2));
        } else if (object.getType().equals(TreeNodeTypes.INCOMING_MESSAGE.toString()) || object.getType().equals(TreeNodeTypes.OUTGOING_MESSAGE.toString())) {
            object.setLevel(Integer.valueOf(3));
        }
    }
}

