/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.ui.util;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.qubership.automation.itf.core.hibernate.spring.managers.base.ObjectManager;
import org.qubership.automation.itf.core.model.common.LabeledStorable;
import org.qubership.automation.itf.core.model.common.Storable;
import org.qubership.automation.itf.core.model.jpa.callchain.CallChain;
import org.qubership.automation.itf.core.model.jpa.context.JsonContext;
import org.qubership.automation.itf.core.model.jpa.folder.ChainFolder;
import org.qubership.automation.itf.core.model.jpa.folder.EnvFolder;
import org.qubership.automation.itf.core.model.jpa.folder.SystemFolder;
import org.qubership.automation.itf.core.model.jpa.message.parser.ParsingRule;
import org.qubership.automation.itf.core.model.jpa.message.template.Template;
import org.qubership.automation.itf.core.model.jpa.project.StubProject;
import org.qubership.automation.itf.core.model.jpa.step.EmbeddedStep;
import org.qubership.automation.itf.core.model.jpa.step.IntegrationStep;
import org.qubership.automation.itf.core.model.jpa.step.SituationStep;
import org.qubership.automation.itf.core.model.jpa.step.Step;
import org.qubership.automation.itf.core.model.jpa.system.System;
import org.qubership.automation.itf.core.model.jpa.system.operation.Operation;
import org.qubership.automation.itf.core.model.jpa.system.stub.Situation;
import org.qubership.automation.itf.core.model.jpa.transport.TransportConfiguration;
import org.qubership.automation.itf.core.util.TemplateHelper;
import org.qubership.automation.itf.core.util.manager.CoreObjectManager;
import org.qubership.automation.itf.ui.messages.UIList;
import org.qubership.automation.itf.ui.messages.UIListImpl;
import org.qubership.automation.itf.ui.messages.UIObjectList;
import org.qubership.automation.itf.ui.messages.UITreeElementList;
import org.qubership.automation.itf.ui.messages.UITypeList;
import org.qubership.automation.itf.ui.messages.exception.UIException;
import org.qubership.automation.itf.ui.messages.objects.UIDataSet;
import org.qubership.automation.itf.ui.messages.objects.UIDataSetParametersGroup;
import org.qubership.automation.itf.ui.messages.objects.UIKey;
import org.qubership.automation.itf.ui.messages.objects.UIObject;
import org.qubership.automation.itf.ui.messages.objects.UIOperation;
import org.qubership.automation.itf.ui.messages.objects.UIParsingRule;
import org.qubership.automation.itf.ui.messages.objects.UISituation;
import org.qubership.automation.itf.ui.messages.objects.UIStep;
import org.qubership.automation.itf.ui.messages.objects.UISystem;
import org.qubership.automation.itf.ui.messages.objects.UITreeElement;
import org.qubership.automation.itf.ui.messages.objects.UITypedObject;
import org.qubership.automation.itf.ui.messages.objects.callchain.UICallChain;
import org.qubership.automation.itf.ui.messages.objects.callchain.step.UIEmbeddedChainStep;
import org.qubership.automation.itf.ui.messages.objects.callchain.step.UISituationStep;
import org.qubership.automation.itf.ui.messages.objects.environment.UIEnvironmentFolder;
import org.qubership.automation.itf.ui.messages.objects.parents.UIIdentifiedObject;
import org.qubership.automation.itf.ui.messages.objects.transport.UITransport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UIHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(UIHelper.class);
    private static final Function<Storable, UIObject> STORABLE_TO_UIOBJ = new Function<Storable, UIObject>(){

        @Nullable
        public UIObject apply(@Nullable Storable input) {
            return input == null ? null : UIHelper.toUIObj(input);
        }
    };
    private static final Function<Storable, UITreeElement> STORABLE_TO_UITREE = new Function<Storable, UITreeElement>(){

        @Nullable
        public UITreeElement apply(@Nullable Storable input) {
            return input == null ? null : UIHelper.toUITree(input);
        }
    };
    private static final Map<Class<? extends Storable>, Class<? extends UIObject>> storableUIMapping = new HashMap<Class<? extends Storable>, Class<? extends UIObject>>();

    public static void conversionOfTree(Collection<UITreeElement> list, Class<? extends Storable> clazz) {
        UIObjectList deleteObjects = new UIObjectList();
        for (UITreeElement object : list) {
            object.setParent(null);
            if (!clazz.getName().equals(object.getClassName())) {
                object.setIsFolder(true);
            }
            object.addListChildrenIfExists(list, clazz);
            if (object.getFolder() == null || object.getFolder().getClassName().equals(StubProject.class.getCanonicalName())) continue;
            deleteObjects.addObject(object);
        }
        if (deleteObjects.getObjects() != null) {
            list.removeAll(deleteObjects.getObjects());
        }
    }

    @Nullable
    public static ImmutableList isNotNullCopyOfImmutableList(Collection collection) {
        return collection == null ? null : ImmutableList.copyOf((Collection)collection);
    }

    public static void saveSteps(List<UIStep> steps, String id) {
        if (steps == null) {
            return;
        }
        ObjectManager stepObjectManager = CoreObjectManager.getInstance().getManager(IntegrationStep.class);
        ObjectManager systemObjectManager = CoreObjectManager.getInstance().getManager(System.class);
        ObjectManager operationObjectManager = CoreObjectManager.getInstance().getManager(Operation.class);
        LinkedList<Step> situationSteps = new LinkedList<Step>();
        for (UIStep entry : steps) {
            Step step = (Step)stepObjectManager.create(null, "integrationStep");
            step.setName(entry.getName());
            step.setDelay(entry.getDelay());
            step.setUnit(entry.getUnit());
            step.setEnabled(!"No".equalsIgnoreCase(entry.getEnabled()));
            step.setManual(!"No".equalsIgnoreCase(entry.getManual()));
            String objectId = entry.getSender() == null ? null : entry.getSender().getId();
            ((IntegrationStep)step).setSender(objectId == null ? null : (System)systemObjectManager.getById((Object)objectId));
            objectId = entry.getReceiver() == null ? null : entry.getReceiver().getId();
            ((IntegrationStep)step).setReceiver(objectId == null ? null : (System)systemObjectManager.getById((Object)objectId));
            objectId = entry.getOperation() == null ? null : entry.getOperation().getId();
            ((IntegrationStep)step).setOperation(objectId == null ? null : (Operation)operationObjectManager.getById((Object)objectId));
            objectId = entry.getTemplate() == null ? null : entry.getTemplate().getId();
            ((IntegrationStep)step).setTemplate(objectId == null ? null : TemplateHelper.getById((Object)objectId));
            situationSteps.add(step);
        }
        Situation situation = (Situation)CoreObjectManager.getInstance().getManager(Situation.class).getById((Object)id);
        if (situation != null) {
            UIHelper.setParent((Storable)situation, situationSteps);
            situation.fillSteps(situationSteps);
            situation.store();
        }
    }

    private static void setParent(Storable parent, List<Step> steps) {
        for (Step step : steps) {
            step.setParent(parent);
        }
    }

    @Nullable
    protected static List<UIKey> getUIKeys(@Nullable Collection<String> keys) {
        if (keys == null) {
            return null;
        }
        ArrayList uiKeys = Lists.newArrayListWithExpectedSize((int)keys.size());
        for (String key : keys) {
            UIKey uiKey = new UIKey();
            uiKey.setKey(key);
            uiKeys.add(uiKey);
        }
        return uiKeys;
    }

    public static String getDefinitionValue(String keyDefinition) {
        return keyDefinition == null ? "" : keyDefinition;
    }

    @Nonnull
    public static UIObjectList getObjectList(@Nonnull Collection<? extends Storable> from) {
        return UIHelper.fillObjectList(from, new UIObjectList());
    }

    @Nonnull
    public static UIObjectList fillObjectList(@Nonnull Collection<? extends Storable> from, @Nonnull UIObjectList to) {
        UIHelper.fillUIList(from, to, UIHelper.toUIObj());
        return to;
    }

    @Nonnull
    public static UITreeElementList getTreeElementList(@Nonnull Collection<? extends Storable> from) {
        return UIHelper.fillTreeElementList(from, new UITreeElementList());
    }

    @Nonnull
    protected static UITreeElementList fillTreeElementList(@Nonnull Collection<? extends Storable> from, @Nonnull UITreeElementList to) {
        UIHelper.fillUIList(from, to, UIHelper.toUITree());
        return to;
    }

    @Nonnull
    protected static <I extends Storable, O extends UIObject> UIList<O> getUIList(@Nonnull Collection<I> from, @Nonnull Function<? super I, O> func) {
        return UIHelper.fillUIList(from, new UIListImpl(), func);
    }

    @Nonnull
    protected static <I extends Storable, O extends UIObject> UIList<O> fillUIList(@Nonnull Collection<I> from, @Nonnull UIList<O> to, @Nonnull Function<? super I, O> func) {
        to.defineObjects(Collections2.transform(from, func));
        return to;
    }

    private static Function<Storable, UIObject> toUIObj() {
        return STORABLE_TO_UIOBJ;
    }

    private static Function<Storable, UITreeElement> toUITree() {
        return STORABLE_TO_UITREE;
    }

    @Nonnull
    private static UIObject toUIObj(@Nonnull Storable input) {
        UIObject uiObject = new UIObject(input);
        uiObject.setClassName(null);
        if (input.getParent() == null) {
            uiObject.setParent(null);
        } else {
            UIObject uiParentObject = new UIObject();
            uiParentObject.setName(input.getParent().getName());
            uiParentObject.setClassName(input.getParent().getClass().getName());
            uiParentObject.setId(input.getParent().getID().toString());
            uiObject.setParent(uiParentObject);
        }
        return uiObject;
    }

    @Nonnull
    private static UITreeElement toUITree(@Nonnull Storable input) {
        return new UITreeElement(input);
    }

    public static UIObject getUIPresentationByStorable(Storable storable, Class childClass, List<Storable> children) {
        Class<? extends UIObject> uiClass = storableUIMapping.get(storable.getClass());
        if (uiClass != null) {
            ReflectiveOperationException exception;
            String error;
            try {
                Constructor<? extends UIObject> constructor;
                try {
                    constructor = uiClass.getConstructor(storable.getClass());
                }
                catch (NoSuchMethodException e) {
                    constructor = uiClass.getConstructor(Storable.class);
                }
                UIObject uiPresentation = constructor.newInstance(storable);
                if (childClass != null) {
                    uiPresentation.loadChildrenByClass(childClass, children);
                }
                return uiPresentation;
            }
            catch (NoSuchMethodException e) {
                error = String.format("Cannot find the constructor(Storable storable) for the %s", storable.getClass().getName());
                exception = e;
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                error = String.format("Cannot create the UI-presentation for the %s", storable.getName());
                exception = e;
            }
            LOGGER.error(error, (Throwable)exception);
            throw new UIException(error);
        }
        String error = String.format("UI Mapping for the %s is not set", storable.getName());
        LOGGER.error(error);
        throw new UIException(error);
    }

    public static void updateObject(UIObject object, Storable storable) {
        storable.setDescription(object.getDescription());
        storable.setName(object.getName());
        if (storable instanceof LabeledStorable) {
            LabeledStorable labeledStorable = (LabeledStorable)storable;
            labeledStorable.getLabels().clear();
            if (object.getLabels() != null) {
                labeledStorable.getLabels().addAll(object.getLabels());
            }
        }
    }

    public static UITypeList convertMapOfTypeToUITypeList(Map<String, String> map) {
        UITypeList uiTypeList = new UITypeList();
        uiTypeList.defineTypes(Collections2.transform(map.entrySet(), (Function)new Function<Map.Entry<String, String>, UITypedObject>(){

            @Nonnull
            public UITypedObject apply(Map.Entry<String, String> input) {
                UITypedObject uiTypedObject = new UITypedObject();
                uiTypedObject.setType(input.getKey());
                uiTypedObject.setName(input.getValue());
                return uiTypedObject;
            }
        }));
        return uiTypeList;
    }

    public static List<Storable> initializeObjects(Collection<UIObject> sources) throws Exception {
        ArrayList<Storable> result = new ArrayList<Storable>();
        for (UIIdentifiedObject uIIdentifiedObject : sources) {
            String sourceId = uIIdentifiedObject.getId();
            String sourceClassName = uIIdentifiedObject.getClassName();
            result.add(CoreObjectManager.getInstance().getManager(Class.forName(sourceClassName).asSubclass(Storable.class)).getById((Object)sourceId));
        }
        return result;
    }

    @Nullable
    protected JsonContext toJSONContext(UIDataSet dataSet) {
        JsonContext context = new JsonContext();
        ImmutableSet<UIDataSetParametersGroup> groups = dataSet.getDataSetParametersGroup();
        if (groups == null) {
            return null;
        }
        groups.forEach(group -> {
            if (!StringUtils.isBlank((CharSequence)group.getName())) {
                context.put((Object)group.getName().trim(), (Object)new JsonContext());
                group.getDataSetParameter().forEach(parameter -> {
                    if (!StringUtils.isBlank((CharSequence)parameter.getDisplayedName())) {
                        context.put((Object)(group.getName().trim() + '.' + parameter.getDisplayedName().trim()), (Object)parameter.getDisplayedValue());
                    }
                });
            }
        });
        return context;
    }

    static {
        storableUIMapping.put(Situation.class, UISituation.class);
        storableUIMapping.put(SituationStep.class, UISituationStep.class);
        storableUIMapping.put(EmbeddedStep.class, UIEmbeddedChainStep.class);
        storableUIMapping.put(TransportConfiguration.class, UITransport.class);
        storableUIMapping.put(System.class, UISystem.class);
        storableUIMapping.put(CallChain.class, UICallChain.class);
        storableUIMapping.put(Template.class, UITreeElement.class);
        storableUIMapping.put(ParsingRule.class, UIParsingRule.class);
        storableUIMapping.put(Operation.class, UIOperation.class);
        storableUIMapping.put(ChainFolder.class, UITreeElement.class);
        storableUIMapping.put(SystemFolder.class, UITreeElement.class);
        storableUIMapping.put(EnvFolder.class, UIEnvironmentFolder.class);
    }
}

