package org.qubership.atp.users.clients.dto;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.qubership.atp.users.clients.dto.PermissionsDto;
import org.qubership.atp.users.clients.dto.UserInfoDto;
import org.springframework.format.annotation.DateTimeFormat;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import javax.annotation.Generated;

/**
 * ProjectDto
 */

@JsonTypeName("Project")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2025-08-18T15:10:46.294Z[Etc/UTC]")
public class ProjectDto {

  @JsonProperty("atpRunners")
  @Valid
  private List<UUID> atpRunners = null;

  @JsonProperty("atpSupports")
  @Valid
  private List<UUID> atpSupports = null;

  @JsonProperty("createdBy")
  private UserInfoDto createdBy;

  @JsonProperty("createdWhen")
  @DateTimeFormat(iso = DateTimeFormat.ISO.DATE_TIME)
  private OffsetDateTime createdWhen;

  @JsonProperty("devOpsEngineers")
  @Valid
  private List<UUID> devOpsEngineers = null;

  @JsonProperty("leads")
  @Valid
  private List<UUID> leads = null;

  @JsonProperty("modifiedBy")
  private UserInfoDto modifiedBy;

  @JsonProperty("modifiedWhen")
  @DateTimeFormat(iso = DateTimeFormat.ISO.DATE_TIME)
  private OffsetDateTime modifiedWhen;

  @JsonProperty("permissions")
  private PermissionsDto permissions;

  @JsonProperty("qaTaEngineers")
  @Valid
  private List<UUID> qaTaEngineers = null;

  @JsonProperty("uuid")
  private UUID uuid;

  public ProjectDto atpRunners(List<UUID> atpRunners) {
    this.atpRunners = atpRunners;
    return this;
  }

  public ProjectDto addAtpRunnersItem(UUID atpRunnersItem) {
    if (this.atpRunners == null) {
      this.atpRunners = new ArrayList<>();
    }
    this.atpRunners.add(atpRunnersItem);
    return this;
  }

  /**
   * Get atpRunners
   * @return atpRunners
  */
  @Valid 
  @Schema(name = "atpRunners", required = false)
  public List<UUID> getAtpRunners() {
    return atpRunners;
  }

  public void setAtpRunners(List<UUID> atpRunners) {
    this.atpRunners = atpRunners;
  }

  public ProjectDto atpSupports(List<UUID> atpSupports) {
    this.atpSupports = atpSupports;
    return this;
  }

  public ProjectDto addAtpSupportsItem(UUID atpSupportsItem) {
    if (this.atpSupports == null) {
      this.atpSupports = new ArrayList<>();
    }
    this.atpSupports.add(atpSupportsItem);
    return this;
  }

  /**
   * Get atpSupports
   * @return atpSupports
  */
  @Valid 
  @Schema(name = "atpSupports", required = false)
  public List<UUID> getAtpSupports() {
    return atpSupports;
  }

  public void setAtpSupports(List<UUID> atpSupports) {
    this.atpSupports = atpSupports;
  }

  public ProjectDto createdBy(UserInfoDto createdBy) {
    this.createdBy = createdBy;
    return this;
  }

  /**
   * Get createdBy
   * @return createdBy
  */
  @Valid 
  @Schema(name = "createdBy", required = false)
  public UserInfoDto getCreatedBy() {
    return createdBy;
  }

  public void setCreatedBy(UserInfoDto createdBy) {
    this.createdBy = createdBy;
  }

  public ProjectDto createdWhen(OffsetDateTime createdWhen) {
    this.createdWhen = createdWhen;
    return this;
  }

  /**
   * Get createdWhen
   * @return createdWhen
  */
  @Valid 
  @Schema(name = "createdWhen", required = false)
  public OffsetDateTime getCreatedWhen() {
    return createdWhen;
  }

  public void setCreatedWhen(OffsetDateTime createdWhen) {
    this.createdWhen = createdWhen;
  }

  public ProjectDto devOpsEngineers(List<UUID> devOpsEngineers) {
    this.devOpsEngineers = devOpsEngineers;
    return this;
  }

  public ProjectDto addDevOpsEngineersItem(UUID devOpsEngineersItem) {
    if (this.devOpsEngineers == null) {
      this.devOpsEngineers = new ArrayList<>();
    }
    this.devOpsEngineers.add(devOpsEngineersItem);
    return this;
  }

  /**
   * Get devOpsEngineers
   * @return devOpsEngineers
  */
  @Valid 
  @Schema(name = "devOpsEngineers", required = false)
  public List<UUID> getDevOpsEngineers() {
    return devOpsEngineers;
  }

  public void setDevOpsEngineers(List<UUID> devOpsEngineers) {
    this.devOpsEngineers = devOpsEngineers;
  }

  public ProjectDto leads(List<UUID> leads) {
    this.leads = leads;
    return this;
  }

  public ProjectDto addLeadsItem(UUID leadsItem) {
    if (this.leads == null) {
      this.leads = new ArrayList<>();
    }
    this.leads.add(leadsItem);
    return this;
  }

  /**
   * Get leads
   * @return leads
  */
  @Valid 
  @Schema(name = "leads", required = false)
  public List<UUID> getLeads() {
    return leads;
  }

  public void setLeads(List<UUID> leads) {
    this.leads = leads;
  }

  public ProjectDto modifiedBy(UserInfoDto modifiedBy) {
    this.modifiedBy = modifiedBy;
    return this;
  }

  /**
   * Get modifiedBy
   * @return modifiedBy
  */
  @Valid 
  @Schema(name = "modifiedBy", required = false)
  public UserInfoDto getModifiedBy() {
    return modifiedBy;
  }

  public void setModifiedBy(UserInfoDto modifiedBy) {
    this.modifiedBy = modifiedBy;
  }

  public ProjectDto modifiedWhen(OffsetDateTime modifiedWhen) {
    this.modifiedWhen = modifiedWhen;
    return this;
  }

  /**
   * Get modifiedWhen
   * @return modifiedWhen
  */
  @Valid 
  @Schema(name = "modifiedWhen", required = false)
  public OffsetDateTime getModifiedWhen() {
    return modifiedWhen;
  }

  public void setModifiedWhen(OffsetDateTime modifiedWhen) {
    this.modifiedWhen = modifiedWhen;
  }

  public ProjectDto permissions(PermissionsDto permissions) {
    this.permissions = permissions;
    return this;
  }

  /**
   * Get permissions
   * @return permissions
  */
  @Valid 
  @Schema(name = "permissions", required = false)
  public PermissionsDto getPermissions() {
    return permissions;
  }

  public void setPermissions(PermissionsDto permissions) {
    this.permissions = permissions;
  }

  public ProjectDto qaTaEngineers(List<UUID> qaTaEngineers) {
    this.qaTaEngineers = qaTaEngineers;
    return this;
  }

  public ProjectDto addQaTaEngineersItem(UUID qaTaEngineersItem) {
    if (this.qaTaEngineers == null) {
      this.qaTaEngineers = new ArrayList<>();
    }
    this.qaTaEngineers.add(qaTaEngineersItem);
    return this;
  }

  /**
   * Get qaTaEngineers
   * @return qaTaEngineers
  */
  @Valid 
  @Schema(name = "qaTaEngineers", required = false)
  public List<UUID> getQaTaEngineers() {
    return qaTaEngineers;
  }

  public void setQaTaEngineers(List<UUID> qaTaEngineers) {
    this.qaTaEngineers = qaTaEngineers;
  }

  public ProjectDto uuid(UUID uuid) {
    this.uuid = uuid;
    return this;
  }

  /**
   * Get uuid
   * @return uuid
  */
  @Valid 
  @Schema(name = "uuid", required = false)
  public UUID getUuid() {
    return uuid;
  }

  public void setUuid(UUID uuid) {
    this.uuid = uuid;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ProjectDto project = (ProjectDto) o;
    return Objects.equals(this.atpRunners, project.atpRunners) &&
        Objects.equals(this.atpSupports, project.atpSupports) &&
        Objects.equals(this.createdBy, project.createdBy) &&
        Objects.equals(this.createdWhen, project.createdWhen) &&
        Objects.equals(this.devOpsEngineers, project.devOpsEngineers) &&
        Objects.equals(this.leads, project.leads) &&
        Objects.equals(this.modifiedBy, project.modifiedBy) &&
        Objects.equals(this.modifiedWhen, project.modifiedWhen) &&
        Objects.equals(this.permissions, project.permissions) &&
        Objects.equals(this.qaTaEngineers, project.qaTaEngineers) &&
        Objects.equals(this.uuid, project.uuid);
  }

  @Override
  public int hashCode() {
    return Objects.hash(atpRunners, atpSupports, createdBy, createdWhen, devOpsEngineers, leads, modifiedBy, modifiedWhen, permissions, qaTaEngineers, uuid);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ProjectDto {\n");
    sb.append("    atpRunners: ").append(toIndentedString(atpRunners)).append("\n");
    sb.append("    atpSupports: ").append(toIndentedString(atpSupports)).append("\n");
    sb.append("    createdBy: ").append(toIndentedString(createdBy)).append("\n");
    sb.append("    createdWhen: ").append(toIndentedString(createdWhen)).append("\n");
    sb.append("    devOpsEngineers: ").append(toIndentedString(devOpsEngineers)).append("\n");
    sb.append("    leads: ").append(toIndentedString(leads)).append("\n");
    sb.append("    modifiedBy: ").append(toIndentedString(modifiedBy)).append("\n");
    sb.append("    modifiedWhen: ").append(toIndentedString(modifiedWhen)).append("\n");
    sb.append("    permissions: ").append(toIndentedString(permissions)).append("\n");
    sb.append("    qaTaEngineers: ").append(toIndentedString(qaTaEngineers)).append("\n");
    sb.append("    uuid: ").append(toIndentedString(uuid)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

