/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.integration.converter;

import java.sql.Timestamp;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import org.modelmapper.spi.ConditionalConverter;
import org.modelmapper.spi.MappingContext;

public class Timestamp2OffsetDateTimeConverter
implements ConditionalConverter<Timestamp, OffsetDateTime> {
    public ConditionalConverter.MatchResult match(Class<?> sourceType, Class<?> destinationType) {
        if (Timestamp.class.isAssignableFrom(sourceType) && OffsetDateTime.class.isAssignableFrom(destinationType)) {
            return ConditionalConverter.MatchResult.FULL;
        }
        return ConditionalConverter.MatchResult.NONE;
    }

    public OffsetDateTime convert(MappingContext<Timestamp, OffsetDateTime> context) {
        if (context.getSource() == null) {
            return null;
        }
        return OffsetDateTime.ofInstant(((Timestamp)context.getSource()).toInstant(), ZoneOffset.UTC);
    }
}

