/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.ui.config;

import java.math.BigInteger;
import java.util.Objects;
import java.util.Optional;
import org.aspectj.lang.JoinPoint;
import org.javers.core.Javers;
import org.javers.core.commit.Commit;
import org.javers.repository.jql.GlobalIdDTO;
import org.javers.repository.jql.InstanceIdDTO;
import org.javers.repository.jql.QueryBuilder;
import org.javers.spring.annotation.JaversSpringDataAuditable;
import org.javers.spring.auditable.AspectUtil;
import org.javers.spring.auditable.AuthorProvider;
import org.javers.spring.auditable.CommitPropertiesProvider;
import org.javers.spring.auditable.aspect.JaversCommitAdvice;
import org.qubership.automation.itf.core.model.common.Storable;
import org.qubership.automation.itf.core.model.jpa.history.JvSnapshotEntity;
import org.qubership.automation.itf.core.util.services.CoreServices;
import org.qubership.automation.itf.ui.services.javers.history.HistoryEntityHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.repository.CrudRepository;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.core.support.DefaultRepositoryMetadata;

public class ItfAbstractSpringAuditableRepositoryAspect {
    private static final Logger log = LoggerFactory.getLogger(ItfAbstractSpringAuditableRepositoryAspect.class);
    private final AuthorProvider authorProvider;
    private final JaversCommitAdvice javersCommitAdvice;
    private final Javers javers;

    protected ItfAbstractSpringAuditableRepositoryAspect(Javers javers, AuthorProvider authorProvider, CommitPropertiesProvider commitPropertiesProvider) {
        this.javers = javers;
        this.authorProvider = authorProvider;
        this.javersCommitAdvice = new JaversCommitAdvice(javers, authorProvider, commitPropertiesProvider);
    }

    protected void onSave(JoinPoint pjp, Object returnedObject, boolean force) {
        block3: {
            block2: {
                if (this.getRepositoryInterface(pjp).isPresent()) break block2;
                if (!force) break block3;
            }
            AspectUtil.collectReturnedObjects((Object)returnedObject).forEach(arg_0 -> ((JaversCommitAdvice)this.javersCommitAdvice).commitObject(arg_0));
        }
    }

    protected void onDelete(JoinPoint pjp) {
        this.getRepositoryInterface(pjp).ifPresent(i -> {
            RepositoryMetadata metadata = DefaultRepositoryMetadata.getMetadata((Class)i);
            for (Object deletedObject : AspectUtil.collectArguments((JoinPoint)pjp)) {
                this.handleDelete(metadata, deletedObject);
            }
        });
    }

    private Optional<Class> getRepositoryInterface(JoinPoint pjp) {
        for (Class<?> i : pjp.getTarget().getClass().getInterfaces()) {
            if (!i.isAnnotationPresent(JaversSpringDataAuditable.class) || !CrudRepository.class.isAssignableFrom(i)) continue;
            return Optional.of(i);
        }
        return Optional.empty();
    }

    void handleDelete(RepositoryMetadata repositoryMetadata, Object domainObjectOrId) {
        if (this.isIdClass(repositoryMetadata, domainObjectOrId)) {
            Class domainType = repositoryMetadata.getDomainType();
            if (this.javers.findSnapshots(QueryBuilder.byInstanceId((Object)domainObjectOrId, (Class)domainType).limit(1).build()).isEmpty()) {
                return;
            }
            this.javersCommitAdvice.commitShallowDeleteById(domainObjectOrId, domainType);
        } else if (this.isDomainClass(repositoryMetadata, domainObjectOrId)) {
            if (this.javers.findSnapshots(QueryBuilder.byInstance((Object)domainObjectOrId).limit(1).build()).isEmpty()) {
                return;
            }
            this.javersCommitAdvice.commitShallowDelete(domainObjectOrId);
        } else {
            throw new IllegalArgumentException("Domain object or object id expected");
        }
    }

    private boolean isDomainClass(RepositoryMetadata metadata, Object o) {
        return metadata.getDomainType().isAssignableFrom(o.getClass());
    }

    private boolean isIdClass(RepositoryMetadata metadata, Object o) {
        return metadata.getIdType().isAssignableFrom(o.getClass());
    }

    public Commit commit(Object currentVersion) {
        return this.javers.commit(this.authorProvider.provide(), currentVersion);
    }

    public void deleteHistoryEntity(Object localId, Class entity) {
        this.javersCommitAdvice.commitShallowDeleteById(localId, HistoryEntityHelper.getHistoryEntityClass(entity));
    }

    private Commit commitShallowDeleteById(GlobalIdDTO globalId) {
        InstanceIdDTO instanceId = (InstanceIdDTO)globalId;
        Optional latestSnapshot = this.javers.getLatestSnapshot(instanceId.getCdoId(), instanceId.getEntity());
        return latestSnapshot.map(cdoSnapshot -> this.javers.commitShallowDeleteById(this.authorProvider.provide(), globalId)).orElse(null);
    }

    protected void processOnSave(JoinPoint pjp, Object responseEntity, boolean forceSaveHistory) {
        try {
            if (responseEntity instanceof JvSnapshotEntity) {
                return;
            }
            if (Objects.isNull(((Storable)responseEntity).getID())) {
                log.debug("Entity with type {} is skipped, because has null objectID.", (Object)responseEntity.getClass().getName());
                return;
            }
            if (HistoryEntityHelper.isNotSupportEntity(responseEntity.getClass())) {
                log.debug("Entity with type {} is skipped, because not supported in itf history.", (Object)responseEntity.getClass().getName());
                return;
            }
            if (!this.isHistoryEnabled(responseEntity)) {
                log.debug("Project setting 'enable.history.versioning' for project id {} is disabled, so history commit is skipped.", (Object)((Storable)responseEntity).getProjectId());
                return;
            }
            Optional<Object> historyEntity = HistoryEntityHelper.fromStorable((Storable)responseEntity);
            historyEntity.ifPresent(o -> this.onSave(pjp, o, forceSaveHistory));
        }
        catch (Exception e) {
            log.error("An error occurred while object history processing for type {}.", responseEntity.getClass(), (Object)e);
        }
    }

    protected boolean isHistoryEnabled(Object responseEntity) {
        BigInteger projectId = ((Storable)responseEntity).getProjectId();
        if (Objects.isNull(projectId)) {
            return false;
        }
        return Boolean.parseBoolean(CoreServices.getProjectSettingsService().get((Object)projectId, "enable.history.versioning", "false"));
    }
}

