/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.ui.config;

import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Aspect;
import org.javers.core.Javers;
import org.javers.spring.auditable.AuthorProvider;
import org.javers.spring.auditable.CommitPropertiesProvider;
import org.qubership.automation.itf.core.model.common.Storable;
import org.qubership.automation.itf.core.model.jpa.system.System;
import org.qubership.automation.itf.ui.config.ItfAbstractSpringAuditableRepositoryAspect;

@Aspect
public class ItfJaversAuditableAspect
extends ItfAbstractSpringAuditableRepositoryAspect {
    protected ItfJaversAuditableAspect(Javers javers, AuthorProvider authorProvider, CommitPropertiesProvider commitPropertiesProvider) {
        super(javers, authorProvider, commitPropertiesProvider);
    }

    @AfterReturning(value="execution(* replicateStorableWithHistory(..)) && args(storable)", argNames="pjp,storable")
    public void onReplicateExecuted(JoinPoint pjp, Storable storable) {
        if (storable instanceof System) {
            System system = (System)storable;
            system.getSystemParsingRules().forEach(parsingRule -> this.onReplicateExecuted(pjp, (Storable)parsingRule));
            system.getOperations().forEach(operation -> this.onReplicateExecuted(pjp, (Storable)operation));
            system.getSystemTemplates().forEach(template -> this.onReplicateExecuted(pjp, (Storable)template));
        } else {
            this.processOnSave(pjp, storable, true);
        }
    }
}

