/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.ui.controls;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.qubership.atp.integration.configuration.configuration.AuditAction;
import org.qubership.automation.itf.core.model.common.Storable;
import org.qubership.automation.itf.core.model.interceptor.Interceptor;
import org.qubership.automation.itf.core.model.jpa.interceptor.ApplicabilityParams;
import org.qubership.automation.itf.core.model.jpa.interceptor.TemplateInterceptor;
import org.qubership.automation.itf.core.model.jpa.interceptor.TransportConfigurationInterceptor;
import org.qubership.automation.itf.core.model.jpa.storage.AbstractStorable;
import org.qubership.automation.itf.core.util.holder.ActiveInterceptorHolder;
import org.qubership.automation.itf.core.util.manager.CoreObjectManager;
import org.qubership.automation.itf.ui.controls.common.AbstractController;
import org.qubership.automation.itf.ui.controls.util.ControllerHelper;
import org.qubership.automation.itf.ui.messages.objects.UIResult;
import org.qubership.automation.itf.ui.messages.objects.transport.interceptor.UIApplicabilityParams;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class ApplicabilityParamsController
extends AbstractController<UIApplicabilityParams, ApplicabilityParams> {
    @Transactional(readOnly=true)
    @PreAuthorize(value="@entityAccess.checkAccess(#projectUuid, \"READ\")")
    @RequestMapping(value={"/custom/applicability_params"}, method={RequestMethod.GET})
    @AuditAction(auditAction="Get all Applicability Params for Interceptor id {{#interceptorId}} in the project {{#projectUuid}}")
    public List<UIApplicabilityParams> getAll(@RequestParam(value="interceptorId") String interceptorId, @RequestParam(value="projectUuid") UUID projectUuid) {
        ArrayList result = Lists.newArrayList();
        Interceptor interceptor = this.getInterceptor(interceptorId);
        if (interceptor != null) {
            for (ApplicabilityParams applicabilityParams : interceptor.getApplicabilityParams()) {
                result.add(new UIApplicabilityParams(applicabilityParams));
            }
        }
        return result;
    }

    @Transactional
    @PreAuthorize(value="@entityAccess.checkAccess(#projectUuid, \"CREATE\")")
    @RequestMapping(value={"/custom/applicability_params"}, method={RequestMethod.POST})
    @AuditAction(auditAction="Create Applicability Params for Interceptor id {{#interceptorId}} in the project {{#projectUuid}}")
    public UIApplicabilityParams create(@RequestParam(value="interceptorId") String interceptorId, @RequestParam(value="projectUuid") UUID projectUuid, @RequestParam(value="className") Class<? extends Interceptor> type) {
        return (UIApplicabilityParams)super.create((Storable)this.getInterceptorWithType(interceptorId, type));
    }

    @Transactional
    @PreAuthorize(value="@entityAccess.checkAccess(#projectUuid, \"UPDATE\")")
    @RequestMapping(value={"/custom/applicability_params"}, method={RequestMethod.PUT})
    @AuditAction(auditAction="Update Applicability Params in the project {{#projectUuid}}")
    public UIResult update(@RequestBody List<UIApplicabilityParams> uiApplicabilityParamsList, @RequestParam(value="projectUuid") UUID projectUuid, @RequestParam(value="className") Class<? extends Interceptor> type) {
        UIResult result = this.validate(uiApplicabilityParamsList);
        if (!uiApplicabilityParamsList.isEmpty()) {
            Interceptor interceptor = this.getInterceptorWithType(uiApplicabilityParamsList.get(0).getParent().getId(), type);
            if (result.isSuccess() && interceptor != null) {
                for (UIApplicabilityParams uiApplicabilityParams : uiApplicabilityParamsList) {
                    for (ApplicabilityParams applicabilityParams : interceptor.getApplicabilityParams()) {
                        if (!applicabilityParams.getID().toString().equals(uiApplicabilityParams.getId())) continue;
                        String envId = uiApplicabilityParams.getEnvironment().getId();
                        String systemId = uiApplicabilityParams.getSystem() != null ? uiApplicabilityParams.getSystem().getId() : "";
                        applicabilityParams.put("Environment", envId);
                        applicabilityParams.put("System", systemId);
                        if (!interceptor.isActive()) continue;
                        ControllerHelper.reactivateInterceptor((Map)ActiveInterceptorHolder.getInstance().getActiveInterceptors().get(interceptor.getParent().getID().toString()), interceptor, interceptor.getParent().getID().toString());
                    }
                }
            }
        }
        return result;
    }

    @Transactional
    @PreAuthorize(value="@entityAccess.checkAccess(#projectUuid, \"DELETE\")")
    @RequestMapping(value={"/custom/applicability_params"}, method={RequestMethod.DELETE})
    @AuditAction(auditAction="Delete Applicability Params from project {{#projectUuid}}")
    public void delete(@RequestBody Collection<UIApplicabilityParams> uiApplicabilityParamsList, @RequestParam(value="projectUuid") UUID projectUuid, @RequestParam(value="className") Class<? extends Interceptor> type) {
        Interceptor interceptor;
        if (!uiApplicabilityParamsList.isEmpty() && (interceptor = this.getInterceptorWithType(uiApplicabilityParamsList.iterator().next().getParent().getId(), type)) != null) {
            ArrayList paramsForDelete = Lists.newArrayList();
            for (UIApplicabilityParams uiApplicabilityParams : uiApplicabilityParamsList) {
                for (ApplicabilityParams applicabilityParams : interceptor.getApplicabilityParams()) {
                    if (!applicabilityParams.getID().toString().equals(uiApplicabilityParams.getId())) continue;
                    paramsForDelete.add(applicabilityParams);
                }
            }
            if (!paramsForDelete.isEmpty()) {
                interceptor.getApplicabilityParams().removeAll(paramsForDelete);
            }
            paramsForDelete.forEach(AbstractStorable::remove);
            if (interceptor.isActive()) {
                ControllerHelper.reactivateInterceptor((Map)ActiveInterceptorHolder.getInstance().getActiveInterceptors().get(interceptor.getParent().getID().toString()), interceptor, interceptor.getParent().getID().toString());
            }
        }
    }

    @Override
    protected Class<ApplicabilityParams> _getGenericUClass() {
        return ApplicabilityParams.class;
    }

    @Override
    protected UIApplicabilityParams _newInstanceTClass(ApplicabilityParams object) {
        return new UIApplicabilityParams(object);
    }

    protected Interceptor _getParent(String parentId) {
        return this.getInterceptor(parentId);
    }

    private Interceptor getInterceptor(String interceptorId) {
        Interceptor interceptor = (Interceptor)CoreObjectManager.getInstance().getManager(TransportConfigurationInterceptor.class).getById((Object)interceptorId);
        if (interceptor == null) {
            interceptor = (Interceptor)CoreObjectManager.getInstance().getManager(TemplateInterceptor.class).getById((Object)interceptorId);
        }
        return interceptor;
    }

    private Interceptor getInterceptorWithType(String interceptorId, Class<? extends Interceptor> type) {
        return (Interceptor)CoreObjectManager.getInstance().getManager(type).getById((Object)interceptorId);
    }

    private UIResult validate(List<UIApplicabilityParams> uiApplicabilityParams) {
        UIResult result = this.fieldsAreNotEmpty(uiApplicabilityParams);
        if (result.isSuccess()) {
            result = this.applicableParametersAreNotDuplicated(uiApplicabilityParams);
        }
        return result;
    }

    private UIResult fieldsAreNotEmpty(List<UIApplicabilityParams> uiApplicabilityParams) {
        for (UIApplicabilityParams applicabilityParams : uiApplicabilityParams) {
            if (applicabilityParams.getEnvironment() != null) continue;
            return new UIResult(false, "Environment can't be empty. Please fill parameters.");
        }
        return new UIResult();
    }

    private UIResult applicableParametersAreNotDuplicated(List<UIApplicabilityParams> uiApplicabilityParams) {
        for (int i = 0; i < uiApplicabilityParams.size(); ++i) {
            for (int g = i + 1; g < uiApplicabilityParams.size(); ++g) {
                String comparingSystemId;
                String sourceEnvId = uiApplicabilityParams.get(i).getEnvironment().getId();
                String comparingEnvId = uiApplicabilityParams.get(g).getEnvironment().getId();
                String sourceSystemId = uiApplicabilityParams.get(i).getSystem() != null ? uiApplicabilityParams.get(i).getSystem().getId() : "";
                String string = comparingSystemId = uiApplicabilityParams.get(g).getSystem() != null ? uiApplicabilityParams.get(g).getSystem().getId() : "";
                if (!sourceEnvId.equals(comparingEnvId) || !sourceSystemId.equals(comparingSystemId)) continue;
                return new UIResult(false, String.format("Applicability Parameters (Environment = %s, System = %s) already exist in interceptor.", uiApplicabilityParams.get(i).getEnvironment().getName(), uiApplicabilityParams.get(i).getSystem() != null ? uiApplicabilityParams.get(i).getSystem().getName() : "empty"));
            }
        }
        return new UIResult();
    }
}

