/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.ui.controls;

import com.google.common.collect.Lists;
import java.beans.ConstructorProperties;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.qubership.atp.integration.configuration.configuration.AuditAction;
import org.qubership.automation.itf.core.hibernate.spring.managers.custom.SearchByProjectIdManager;
import org.qubership.automation.itf.core.hibernate.spring.managers.custom.SearchManager;
import org.qubership.automation.itf.core.hibernate.spring.managers.executor.SystemObjectManager;
import org.qubership.automation.itf.core.model.common.Storable;
import org.qubership.automation.itf.core.model.jpa.callchain.CallChain;
import org.qubership.automation.itf.core.model.jpa.environment.Environment;
import org.qubership.automation.itf.core.model.jpa.folder.Folder;
import org.qubership.automation.itf.core.model.jpa.project.IntegrationConfig;
import org.qubership.automation.itf.core.model.jpa.project.StubProject;
import org.qubership.automation.itf.core.model.jpa.system.System;
import org.qubership.automation.itf.core.util.manager.CoreObjectManager;
import org.qubership.automation.itf.executor.objects.ei.SimpleItfEntity;
import org.qubership.automation.itf.executor.service.ExportImportService;
import org.qubership.automation.itf.ui.util.AtpExportImportHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class AtpExportImportController {
    private static final Logger log = LoggerFactory.getLogger(AtpExportImportController.class);
    private final ExportImportService exportImportService;

    @Transactional(readOnly=true)
    @GetMapping(value={"/api/folders/root/callchain/project/{projectUuid}"}, produces={"application/json"})
    @AuditAction(auditAction="Get root CallChain Folder for Atp Export, project {{#projectUuid}}")
    public SimpleItfEntity getRootCallchainFolderByAtpExport(@PathVariable(value="projectUuid") UUID projectUuid) {
        StubProject project = (StubProject)((SearchManager)CoreObjectManager.getInstance().getSpecialManager(StubProject.class, SearchManager.class)).getByUuid(projectUuid);
        return AtpExportImportHelper.createSimpleItfEntity((Storable)project.getCallchains());
    }

    @Transactional(readOnly=true)
    @GetMapping(value={"/api/folders/sub/callchain/project/{projectUuid}"}, produces={"application/json"})
    @AuditAction(auditAction="Get all CallChain Folders for Atp Export, project {{#projectUuid}}")
    public List<SimpleItfEntity> getCallchainSubFoldersByAtpExport(@PathVariable(value="projectUuid") UUID projectUuid) {
        ArrayList result = Lists.newArrayList();
        StubProject project = (StubProject)((SearchManager)CoreObjectManager.getInstance().getSpecialManager(StubProject.class, SearchManager.class)).getByUuid(projectUuid);
        AtpExportImportHelper.fillSubFolders((Folder<? extends Storable>)project.getCallchains(), result);
        return result;
    }

    @Transactional(readOnly=true)
    @GetMapping(value={"/api/callchains/project/{projectUuid}"}, produces={"application/json"})
    @AuditAction(auditAction="Get all CallChains for Atp Export, project {{#projectUuid}}")
    public List<SimpleItfEntity> getCallchainsByAtpExport(@PathVariable(value="projectUuid") UUID projectUuid) {
        ArrayList result = Lists.newArrayList();
        BigInteger projectId = ((SearchManager)CoreObjectManager.getInstance().getSpecialManager(StubProject.class, SearchManager.class)).getEntityInternalIdByUuid(projectUuid);
        Collection callChains = ((SearchByProjectIdManager)CoreObjectManager.getInstance().getSpecialManager(CallChain.class, SearchByProjectIdManager.class)).getByProjectId(projectId);
        for (CallChain callChain : callChains) {
            result.add(AtpExportImportHelper.createSimpleItfEntity((Storable)callChain));
        }
        return result;
    }

    @Transactional(readOnly=true)
    @GetMapping(value={"/api/folders/root/system/project/{projectUuid}"}, produces={"application/json"})
    @AuditAction(auditAction="Get root System Folder for Atp Export, project {{#projectUuid}}")
    public SimpleItfEntity getRootSystemFolderByAtpExport(@PathVariable(value="projectUuid") UUID projectUuid) {
        StubProject project = (StubProject)((SearchManager)CoreObjectManager.getInstance().getSpecialManager(StubProject.class, SearchManager.class)).getByUuid(projectUuid);
        return AtpExportImportHelper.createSimpleItfEntity((Storable)project.getSystems());
    }

    @Transactional(readOnly=true)
    @GetMapping(value={"/api/folders/sub/system/project/{projectUuid}"}, produces={"application/json"})
    @AuditAction(auditAction="Get all System Folders for Atp Export, project {{#projectUuid}}")
    public List<SimpleItfEntity> getSystemSubFoldersByAtpExport(@PathVariable(value="projectUuid") UUID projectUuid) {
        ArrayList result = Lists.newArrayList();
        StubProject project = (StubProject)((SearchManager)CoreObjectManager.getInstance().getSpecialManager(StubProject.class, SearchManager.class)).getByUuid(projectUuid);
        AtpExportImportHelper.fillSubFolders((Folder<? extends Storable>)project.getSystems(), result);
        return result;
    }

    @Transactional(readOnly=true)
    @GetMapping(value={"/api/systems/project/{projectUuid}"}, produces={"application/json"})
    @AuditAction(auditAction="Get all Systems for Atp Export, project {{#projectUuid}}")
    public List<SimpleItfEntity> getSystemsByAtpExport(@PathVariable(value="projectUuid") UUID projectUuid) {
        ArrayList result = Lists.newArrayList();
        BigInteger projectId = ((SearchManager)CoreObjectManager.getInstance().getSpecialManager(StubProject.class, SearchManager.class)).getEntityInternalIdByUuid(projectUuid);
        Collection systems = ((SystemObjectManager)CoreObjectManager.getInstance().getSpecialManager(System.class, SystemObjectManager.class)).getByProjectId(projectId);
        for (System system : systems) {
            result.add(AtpExportImportHelper.createSimpleItfEntity((Storable)system));
        }
        return result;
    }

    @Transactional(readOnly=true)
    @GetMapping(value={"/api/folders/root/environment/project/{projectUuid}"}, produces={"application/json"})
    @AuditAction(auditAction="Get root Environment Folder for Atp Export, project {{#projectUuid}}")
    public SimpleItfEntity getRootEnvironmentFolderByAtpExport(@PathVariable(value="projectUuid") UUID projectUuid) {
        StubProject project = (StubProject)((SearchManager)CoreObjectManager.getInstance().getSpecialManager(StubProject.class, SearchManager.class)).getByUuid(projectUuid);
        return AtpExportImportHelper.createSimpleItfEntity((Storable)project.getEnvironments());
    }

    @Transactional(readOnly=true)
    @GetMapping(value={"/api/folders/sub/environment/project/{projectUuid}"}, produces={"application/json"})
    @AuditAction(auditAction="Get all Environment Folders for Atp Export, project {{#projectUuid}}")
    public List<SimpleItfEntity> getEnvironmentFoldersByAtpExport(@PathVariable(value="projectUuid") UUID projectUuid) {
        ArrayList result = Lists.newArrayList();
        StubProject project = (StubProject)((SearchManager)CoreObjectManager.getInstance().getSpecialManager(StubProject.class, SearchManager.class)).getByUuid(projectUuid);
        AtpExportImportHelper.fillSubFolders((Folder<? extends Storable>)project.getEnvironments(), result);
        return result;
    }

    @Transactional(readOnly=true)
    @GetMapping(value={"/api/environments/project/{projectUuid}"}, produces={"application/json"})
    @AuditAction(auditAction="Get all Environments for Atp Export, project {{#projectUuid}}")
    public List<SimpleItfEntity> getEnvironmentsByAtpExport(@PathVariable(value="projectUuid") UUID projectUuid) {
        ArrayList result = Lists.newArrayList();
        BigInteger projectId = ((SearchManager)CoreObjectManager.getInstance().getSpecialManager(StubProject.class, SearchManager.class)).getEntityInternalIdByUuid(projectUuid);
        Collection environments = ((SearchByProjectIdManager)CoreObjectManager.getInstance().getSpecialManager(Environment.class, SearchByProjectIdManager.class)).getByProjectId(projectId);
        for (Environment environment : environments) {
            result.add(AtpExportImportHelper.createSimpleItfEntity((Storable)environment));
        }
        return result;
    }

    @Transactional(readOnly=true)
    @GetMapping(value={"/api/integrationconfigs/project/{projectUuid}"}, produces={"application/json"})
    @AuditAction(auditAction="Get Integration Configs from project {{#projectUuid}}")
    public List<SimpleItfEntity> getIntegrationConfigsByProjectId(@PathVariable(value="projectUuid") UUID projectUuid) {
        List<Object> result = Lists.newArrayList();
        StubProject project = (StubProject)((SearchManager)CoreObjectManager.getInstance().getSpecialManager(StubProject.class, SearchManager.class)).getByUuid(projectUuid);
        if (!Objects.isNull(project)) {
            Collection integrationConfigs = CoreObjectManager.getInstance().getManager(IntegrationConfig.class).getAllByParentId(project.getID());
            result = integrationConfigs.stream().map(AtpExportImportHelper::createSimpleItfEntity).collect(Collectors.toList());
        } else {
            log.error("Can't find project by UUID {}, empty SimpleItfEntity list will be returned.", (Object)projectUuid);
        }
        return result;
    }

    @Transactional(readOnly=true)
    @GetMapping(value={"/api/settings/project/{projectUuid}"}, produces={"application/json"})
    @AuditAction(auditAction="Get Project Settings from project {{#projectUuid}}")
    public List<SimpleItfEntity> getProjectSettingsByProjectId(@PathVariable(value="projectUuid") UUID projectUuid) {
        ArrayList result = Lists.newArrayList();
        StubProject project = (StubProject)((SearchManager)CoreObjectManager.getInstance().getSpecialManager(StubProject.class, SearchManager.class)).getByUuid(projectUuid);
        if (!Objects.isNull(project)) {
            result.add(AtpExportImportHelper.createSimpleItfEntity((Storable)project));
        } else {
            log.error("Can't find project by UUID {}, empty SimpleItfEntity will be returned.", (Object)projectUuid);
            result.add(new SimpleItfEntity());
        }
        return result;
    }

    @Transactional(readOnly=true)
    @PostMapping(value={"/api/bvTcByChains"}, produces={"application/json"})
    @AuditAction(auditAction="Atp Export: Collecting BulkValidator TestCases by CallChains Ids")
    public List<UUID> getBvTcByItfChains(@RequestBody Set<String> itfCallChains) {
        log.info("Collecting BulkValidator TestCases by CallChainsIds...");
        return this.exportImportService.collectBvTcByChainsIds(itfCallChains);
    }

    @Transactional(readOnly=true)
    @PostMapping(value={"/api/bvTcBySystems"}, produces={"application/json"})
    @AuditAction(auditAction="Atp Export: Collecting BulkValidator TestCases by Systems Ids")
    public List<UUID> getBvTcByItfSystems(@RequestBody Set<String> itfSystems) {
        log.info("Collecting BulkValidator TestCases by SystemsIds...");
        return this.exportImportService.collectBvTcBySystemsIds(itfSystems);
    }

    @Transactional(readOnly=true)
    @PostMapping(value={"/api/bvTcByEnvs"}, produces={"application/json"})
    @AuditAction(auditAction="Atp Export: Collecting BulkValidator TestCases by Environments Ids")
    public List<UUID> getBvTcByItfEnvs(@RequestBody Set<String> itfEnvironments) {
        log.info("Collecting BulkValidator TestCases by EnvironmentsIds...");
        return this.exportImportService.collectBvTcByEnvironmentsIds(itfEnvironments);
    }

    @Transactional(readOnly=true)
    @PostMapping(value={"/api/dslByChains"}, produces={"application/json"})
    @AuditAction(auditAction="Atp Export: Collecting DSLs by CallChains Ids")
    public List<UUID> getDslByItfChains(@RequestBody Set<String> itfCallChains) {
        log.info("Collecting DSL by CallChainsIds...");
        return this.exportImportService.collectDslByChainsIds(itfCallChains);
    }

    @ConstructorProperties(value={"exportImportService"})
    public AtpExportImportController(ExportImportService exportImportService) {
        this.exportImportService = exportImportService;
    }
}

