/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.ui.controls;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.annotations.tags.Tags;
import java.beans.ConstructorProperties;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import org.qubership.atp.integration.configuration.configuration.AuditAction;
import org.qubership.automation.itf.core.execution.DebugExecutor;
import org.qubership.automation.itf.core.message.TcContextOperationMessage;
import org.qubership.automation.itf.core.model.jpa.callchain.CallChain;
import org.qubership.automation.itf.core.model.jpa.context.InstanceContext;
import org.qubership.automation.itf.core.model.jpa.context.TcContext;
import org.qubership.automation.itf.core.model.jpa.instance.AbstractContainerInstance;
import org.qubership.automation.itf.core.model.jpa.instance.AbstractInstance;
import org.qubership.automation.itf.core.model.jpa.instance.chain.CallChainInstance;
import org.qubership.automation.itf.core.model.jpa.step.EmbeddedStep;
import org.qubership.automation.itf.core.model.jpa.step.SituationStep;
import org.qubership.automation.itf.core.model.jpa.step.Step;
import org.qubership.automation.itf.core.util.constants.StartedFrom;
import org.qubership.automation.itf.core.util.constants.Status;
import org.qubership.automation.itf.core.util.manager.CoreObjectManager;
import org.qubership.automation.itf.core.util.transport.service.report.Report;
import org.qubership.automation.itf.executor.cache.service.CacheServices;
import org.qubership.automation.itf.executor.service.ExecutionServices;
import org.qubership.automation.itf.executor.service.ExecutorToMessageBrokerSender;
import org.qubership.automation.itf.executor.service.ProjectSettingsService;
import org.qubership.automation.itf.integration.reports.ReportsService;
import org.qubership.automation.itf.ui.controls.MonitoringController;
import org.qubership.automation.itf.ui.messages.objects.UIReportItem;
import org.qubership.automation.itf.ui.messages.objects.callchain.step.UIAbstractCallChainStep;
import org.qubership.automation.itf.ui.messages.objects.callchain.step.UISituationStep;
import org.qubership.automation.itf.ui.messages.objects.wrap.UIWrapper;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Transactional
@RestController
@Tags(value={@Tag(name="Context queries API.", description="Context API to query context. Called through REST."), @Tag(name="Context commands API.", description="Context API to control context. Called through REST.")})
public class ContextController {
    private static final String TITLE = "title";
    private static final String MESSAGE = "message";
    private static final List<String> FINISHED_STATUS = new ArrayList<String>(Arrays.asList("PASSED", "FAILED", "STOPPED", "Passed", "Failed", "Stopped", "FAILED_BY_TIMEOUT", "Failed by timeout"));
    private final DebugExecutor debugExecutor;
    private final ReportsService reportsService;
    private final ExecutorToMessageBrokerSender executorToMessageBrokerSender;
    private final ProjectSettingsService projectSettingsService;

    @Transactional(readOnly=true)
    @PreAuthorize(value="@entityAccess.checkAccess(#projectUuid, \"READ\")")
    @RequestMapping(value={"/context/state"}, method={RequestMethod.GET})
    @Operation(summary="GetContextStatusById", description="Retrieve status of context", tags={"Context queries API."})
    @AuditAction(auditAction="Get status of tc-context id {{#contextId}} in the project {{#projectId}}/{{#projectUuid}}")
    public Properties status(@RequestParam(value="id") String contextId, @RequestParam(value="projectId", required=false) BigInteger projectId, @RequestParam(value="projectUuid") UUID projectUuid) {
        String status;
        TcContext tc = CacheServices.getTcContextCacheService().getById((Object)new BigInteger(contextId));
        if (tc == null) {
            Object[] props = this.getContextProperties(contextId, projectUuid, false);
            status = props[4].toString();
        } else {
            status = tc.getStatus().toString().toUpperCase();
        }
        Properties properties = new Properties();
        properties.put("status", status);
        if (this.isContextFinished(status)) {
            properties.put("isFinished", "true");
        } else {
            properties.put("isFinished", "false");
        }
        return properties;
    }

    @Transactional(readOnly=true)
    @PreAuthorize(value="@entityAccess.checkAccess(#projectUuid, \"READ\")")
    @RequestMapping(value={"/context/get"}, method={RequestMethod.GET}, produces={"application/json; charset=UTF-8"})
    @Operation(summary="GetContextById", description="Retrieve context by id", tags={"Context queries API."})
    @AuditAction(auditAction="Get tc-context by id {{#contextId}} in the project {{#projectUuid}}")
    public String get(@RequestParam(value="id") String contextId, @RequestParam(value="projectUuid") UUID projectUuid) {
        TcContext tc = CacheServices.getTcContextCacheService().getById((Object)new BigInteger(contextId));
        if (tc == null) {
            Object[] props = this.getContextProperties(contextId, projectUuid, true);
            return props[7].toString();
        }
        return tc.toJSONString();
    }

    @Transactional(readOnly=true)
    @PreAuthorize(value="@entityAccess.checkAccess(#projectUuid, \"READ\")")
    @RequestMapping(value={"/context/keys"}, method={RequestMethod.GET})
    @Operation(summary="GetKeysById", description="Retrieve context keys by id", tags={"Context queries API."})
    @AuditAction(auditAction="Get Context Keys of tc-context id {{#contextId}} in the project {{#projectUuid}}")
    public Set<String> getKeys(@RequestParam(value="id") String contextId, @RequestParam(value="projectUuid") UUID projectUuid) {
        TcContext tc = CacheServices.getTcContextCacheService().getById((Object)new BigInteger(contextId));
        if (tc == null) {
            return this.reportsService.getKeys(contextId, projectUuid);
        }
        return tc.getBindingKeys();
    }

    @Transactional(readOnly=true)
    @RequestMapping(value={"/context/info"}, method={RequestMethod.GET}, produces={"application/json; charset=UTF-8"})
    @Operation(summary="GetInfoById", description="Retrieve context info by id", tags={"Context queries API."})
    @AuditAction(auditAction="Get Context Info of tc-context id {{#contextId}} in the project {{#projectUuid}}")
    public Properties getInfo(@RequestParam(value="id") String contextId, @RequestParam(value="projectUuid") UUID projectUuid) {
        String status;
        Properties properties = new Properties();
        TcContext tc = CacheServices.getTcContextCacheService().getById((Object)new BigInteger(contextId));
        if (tc == null) {
            Object[] props = this.getContextProperties(contextId, projectUuid, true);
            properties.put("id", props[0].toString());
            properties.put("name", props[1]);
            properties.put("start_time", props[5].toString());
            properties.put("end_time", props[6].toString());
            status = props[4].toString();
        } else {
            properties.put("id", tc.getID().toString());
            properties.put("name", tc.getName());
            properties.put("start_time", tc.getStartTime() == null ? "" : tc.getStartTime().toString());
            properties.put("end_time", tc.getEndTime() == null ? "" : tc.getEndTime().toString());
            status = tc.getStatus().toString().toUpperCase();
        }
        properties.put("status", status);
        properties.put("isFinished", String.valueOf(this.isContextFinished(status)));
        return properties;
    }

    @Transactional
    @PreAuthorize(value="@entityAccess.checkAccess(#projectUuid, \"EXECUTE\")")
    @RequestMapping(value={"/context/fail"}, method={RequestMethod.POST})
    @Operation(summary="FailTC", description="Force context to be failed.", tags={"Context commands API."})
    @AuditAction(auditAction="Fail tc-context id {{#contextId}} in the project {{#projectUuid}}")
    public void fail(@RequestBody Properties request, @RequestParam(value="projectUuid") UUID projectUuid) {
        String contextId = request.getProperty("id");
        if (contextId == null) {
            throw new IllegalArgumentException("Parameter 'id' (Context id) is null or missed");
        }
        TcContext tcContext = CacheServices.getTcContextCacheService().getById((Object)contextId);
        if (tcContext == null) {
            throw new IllegalArgumentException(String.format("Context isn't found by id '%s'", contextId));
        }
        this.failTc(request, tcContext);
    }

    @Transactional(readOnly=true)
    @PreAuthorize(value="@entityAccess.checkAccess(#projectUuid, \"EXECUTE\")")
    @RequestMapping(value={"/context/setstate"}, method={RequestMethod.POST})
    @Operation(summary="SetState", description="Set state of context", tags={"Context commands API."})
    @AuditAction(auditAction="Set state of tc-contexts selected in the project {{#projectUuid}}")
    public void setState(@RequestBody Properties request, @RequestParam(value="projectUuid") UUID projectUuid, @RequestHeader(value="X-Project-Id") String tenantId) {
        this.executorToMessageBrokerSender.sendMessageToTcContextOperationsTopic((Object)new TcContextOperationMessage(request.getProperty("state"), new BigInteger(request.getProperty("contextId"))), tenantId);
    }

    @Transactional
    @PreAuthorize(value="@entityAccess.checkAccess(#projectUuid, \"EXECUTE\")")
    @RequestMapping(value={"/context/continue"}, method={RequestMethod.GET})
    @Operation(summary="PushCallAndContinueTC", description="Continue paused context", tags={"Context commands API."})
    @AuditAction(auditAction="Push call and continue tc-context id {{#contextId}} in the project {{#projectUuid}}")
    public UIReportItem pushCallAndContinueTC(@RequestParam(value="contextId") String contextId, @RequestParam(value="stepId") String stepId, @RequestParam(value="projectUuid") UUID projectUuid) {
        TcContext tcContext = this.searchAndGetValidTcContext(contextId);
        Step step = this.searchAndGetValidStep(stepId);
        this.prepareTcContextForContinue(tcContext);
        this.debugExecutor.executeCallChainBeginStep(tcContext, step);
        return MonitoringController.buildUIReportItem(tcContext);
    }

    @Transactional(readOnly=true)
    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.automation.itf.ui.util.UserManagementEntities).CALLCHAIN.getName(),#projectUuid, 'EXECUTE')")
    @RequestMapping(value={"/callchain/run/disablestepbystep"}, method={RequestMethod.GET})
    @AuditAction(auditAction="Disable StepByStep mode during execution of TC context {{#contextId}}")
    public void disableStepByStep(@RequestParam(value="contextId") BigInteger contextId, @RequestParam(value="projectUuid") UUID projectUuid, @RequestHeader(value="X-Project-Id") String tenantId) {
        this.executorToMessageBrokerSender.sendMessageToDisableStepByStepTopic((Object)contextId, tenantId);
    }

    @Deprecated
    @Transactional
    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.automation.itf.ui.util.UserManagementEntities).CALLCHAIN.getName(),#projectUuid, 'READ')")
    @RequestMapping(value={"/callchain/getallstepsituation"}, method={RequestMethod.GET})
    @Operation(summary="GetAllSituationStep", description="Retrieve all situation steps of context", tags={"Context queries API."})
    @AuditAction(auditAction="Get all situation steps of CallChain id {{#id}} in the project {{#projectUuid}}")
    public UIWrapper<List<UIAbstractCallChainStep>> getAllSituationStep(@RequestParam(value="id", defaultValue="0") String id, @RequestParam(value="projectUuid") UUID projectUuid) {
        UIWrapper<List<UIAbstractCallChainStep>> wrapper = new UIWrapper<List<UIAbstractCallChainStep>>();
        return wrapper;
    }

    private void failTc(@RequestBody Properties request, TcContext tcContext) {
        String title = request.getProperty(TITLE, "");
        String message = request.getProperty(MESSAGE, "");
        List instances = tcContext.getInstances();
        AbstractContainerInstance lastInstance = (AbstractContainerInstance)instances.get(instances.size() - 1);
        Report.terminated((AbstractInstance)lastInstance, (String)title, (String)message, null);
        ExecutionServices.getExecutionProcessManagerService().fail(tcContext);
    }

    private List<UIAbstractCallChainStep> getAllSituationStepForCallChain(CallChain chain, List<UIAbstractCallChainStep> steps, String counterToString, Set<Object> chainIds) {
        String beginString = counterToString;
        chainIds.add(chain.getID());
        List chainSteps = chain.getSteps();
        for (int i = 0; i < chainSteps.size(); ++i) {
            Step step = (Step)chainSteps.get(i);
            if (step == null || !step.isEnabled()) continue;
            counterToString = counterToString + String.valueOf(i + 1);
            if (step instanceof SituationStep) {
                steps.add(new UISituationStep((SituationStep)step, counterToString, false));
            } else if (step instanceof EmbeddedStep && ((EmbeddedStep)step).getChain() != null && !chainIds.contains(((EmbeddedStep)step).getChain().getID())) {
                steps = this.getAllSituationStepForCallChain(((EmbeddedStep)step).getChain(), steps, counterToString + ".", chainIds);
            }
            counterToString = beginString;
        }
        return steps;
    }

    private TcContext searchAndGetValidTcContext(String contextId) {
        TcContext tcContext = CacheServices.getTcContextCacheService().getById((Object)new BigInteger(contextId));
        if (tcContext == null) {
            throw new IllegalArgumentException(String.format("Context isn't found by id '%s'", contextId));
        }
        if (Objects.isNull(tcContext.getInitiator()) || !(tcContext.getInitiator() instanceof CallChainInstance)) {
            throw new IllegalArgumentException(String.format("Initiator isn't found by context id '%s'", contextId));
        }
        tcContext.setStartedFrom(StartedFrom.ITF_UI);
        return tcContext;
    }

    private Step searchAndGetValidStep(String stepId) {
        Step step = (Step)CoreObjectManager.getInstance().getManager(Step.class).getById((Object)stepId);
        if (!(step instanceof SituationStep)) {
            throw new IllegalArgumentException(String.format("Step isn't found by id '%s'", stepId));
        }
        return step;
    }

    private void prepareTcContextForContinue(TcContext tcContext) {
        InstanceContext instanceContext = tcContext.getInitiator().getContext();
        if (instanceContext == null) {
            instanceContext = new InstanceContext();
            tcContext.getInitiator().setContext(instanceContext);
        }
        instanceContext.setTC(tcContext);
        tcContext.setStatus(Status.IN_PROGRESS);
        tcContext.setEndTime(null);
    }

    private Object[] getContextProperties(String contextId, UUID projectUuid, boolean failIfNotFound) {
        List<Object[]> contextProperties = this.reportsService.getContextProperties(contextId, projectUuid);
        if (contextProperties == null || contextProperties.isEmpty()) {
            if (failIfNotFound) {
                throw new IllegalArgumentException(String.format("Context isn't found by id '%s'", contextId));
            }
            return new String[]{contextId, "", "", "", "Unknown"};
        }
        return contextProperties.get(0);
    }

    private boolean isContextFinished(String status) {
        return FINISHED_STATUS.contains(status);
    }

    @ConstructorProperties(value={"debugExecutor", "reportsService", "executorToMessageBrokerSender", "projectSettingsService"})
    public ContextController(DebugExecutor debugExecutor, ReportsService reportsService, ExecutorToMessageBrokerSender executorToMessageBrokerSender, ProjectSettingsService projectSettingsService) {
        this.debugExecutor = debugExecutor;
        this.reportsService = reportsService;
        this.executorToMessageBrokerSender = executorToMessageBrokerSender;
        this.projectSettingsService = projectSettingsService;
    }
}

