/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.ui.controls;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.qubership.atp.integration.configuration.configuration.AuditAction;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.env.OriginTrackedMapPropertySource;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.support.StandardServletEnvironment;

@RestController
public class EnvPropertiesController {
    private Environment environment;

    @Autowired
    public EnvPropertiesController(Environment environment) {
        this.environment = environment;
    }

    @PreAuthorize(value="@entityAccess.checkAccess(#projectUuid, \"READ\")")
    @RequestMapping(value={"/getEnvironmentProperties"}, method={RequestMethod.GET})
    @AuditAction(auditAction="Get Environment properties, project {{#projectUuid}}")
    public Map<String, String> getEnvironmentProperties(@RequestParam(value="projectUuid") UUID projectUuid) {
        HashMap<String, String> environmentProperties = new HashMap<String, String>();
        MutablePropertySources propertySources = ((StandardServletEnvironment)this.environment).getPropertySources();
        this.fillMap(environmentProperties, propertySources.get("applicationConfig: [file:application.properties]"));
        this.fillMap(environmentProperties, propertySources.get("applicationConfig: [file:bootstrap.properties]"));
        return environmentProperties;
    }

    private void fillMap(Map<String, String> environmentProperties, PropertySource propertySource) {
        String[] properties;
        for (String property : properties = ((OriginTrackedMapPropertySource)propertySource).getPropertyNames()) {
            environmentProperties.put(property, this.environment.getProperty(property));
        }
    }
}

