/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.ui.controls;

import com.google.common.eventbus.EventBus;
import java.lang.reflect.Field;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.qubership.atp.integration.configuration.configuration.AuditAction;
import org.qubership.automation.itf.executor.provider.EventBusProvider;
import org.qubership.automation.itf.ui.messages.objects.UIEventbusSubscribers;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class EventbusSubscribersController {
    private EventBusProvider eventBusProvider;

    @Autowired
    public EventbusSubscribersController(EventBusProvider eventBusProvider) {
        this.eventBusProvider = eventBusProvider;
    }

    @PreAuthorize(value="@entityAccess.isSupport()")
    @GetMapping(value={"/tools/eventbusSubscribers"})
    @AuditAction(auditAction="Get Eventbus Subscribers, project {{#projectId}}")
    public UIEventbusSubscribers getEventbusSubscribers(@RequestParam BigInteger projectId) throws NoSuchFieldException, IllegalAccessException {
        UIEventbusSubscribers uiEventbusSubscribers = new UIEventbusSubscribers();
        uiEventbusSubscribers.setNormalPrioritySubscribers(this.modifyMap(this.getNormalPrioritySubscribers()));
        uiEventbusSubscribers.setHighPrioritySubscribers(this.modifyMap(this.getHighPrioritySubscribers()));
        return uiEventbusSubscribers;
    }

    private Map getNormalPrioritySubscribers() throws NoSuchFieldException, IllegalAccessException {
        return this.getSubscribers(this.eventBusProvider.getBus(EventBusProvider.Priority.NORMAL));
    }

    private Map getHighPrioritySubscribers() throws NoSuchFieldException, IllegalAccessException {
        return this.getSubscribers(this.eventBusProvider.getBus(EventBusProvider.Priority.HIGH));
    }

    private Map getSubscribers(EventBus eventBus) throws IllegalAccessException, NoSuchFieldException {
        Field subscribersField = eventBus.getClass().getDeclaredField("subscribers");
        subscribersField.setAccessible(true);
        Object subscribers = subscribersField.get(eventBus);
        Field subscriberListField = subscribers.getClass().getDeclaredField("subscribers");
        subscriberListField.setAccessible(true);
        return (Map)subscriberListField.get(subscribers);
    }

    private Map modifyMap(Map map) {
        ConcurrentHashMap<String, String> concurrentHashMap = new ConcurrentHashMap<String, String>();
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry object;
            Map.Entry entry = object = iterator.next();
            concurrentHashMap.put(((Class)entry.getKey()).getName(), String.valueOf(((Collection)entry.getValue()).size()));
        }
        return concurrentHashMap;
    }
}

