/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.ui.controls;

import org.qubership.automation.itf.integration.users.UserService;
import org.qubership.automation.itf.ui.model.LoginInfo;
import org.qubership.automation.itf.ui.model.User;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class UserController {
    private final UserService userService;

    @Autowired
    public UserController(UserService userService) {
        this.userService = userService;
    }

    @PreAuthorize(value="isAuthenticated()")
    @RequestMapping(value={"/user/current"}, method={RequestMethod.GET})
    public User getLoggedUser() {
        return this.userService.getLoggedUser();
    }

    @PreAuthorize(value="isAuthenticated()")
    @RequestMapping(value={"/user/token"}, method={RequestMethod.GET})
    public String getCurrentUserToken() {
        String loggedUserToken = this.userService.getLoggedUserToken();
        return "Bearer ".concat(loggedUserToken);
    }

    @PreAuthorize(value="isAuthenticated()")
    @RequestMapping(value={"/user/isSupport"}, method={RequestMethod.GET})
    public boolean checkUserRole() {
        return this.userService.checkUserRole();
    }

    @PreAuthorize(value="isAuthenticated()")
    @RequestMapping(value={"/user/info"}, method={RequestMethod.GET})
    public User getCurrentUserInfo() {
        return this.userService.getCurrentUserInfo();
    }

    @PreAuthorize(value="isAuthenticated()")
    @RequestMapping(value={"/user/login_info"}, method={RequestMethod.GET})
    public LoginInfo getLoginInfo() {
        LoginInfo loginInfo = this.userService.getLoginInfo();
        loginInfo.setToken("Bearer ".concat(loginInfo.getToken()));
        return loginInfo;
    }
}

