/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.ui.controls.entities;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.qubership.atp.integration.configuration.configuration.AuditAction;
import org.qubership.automation.itf.core.model.common.Storable;
import org.qubership.automation.itf.core.model.interceptor.Interceptor;
import org.qubership.automation.itf.core.model.jpa.interceptor.InterceptorParams;
import org.qubership.automation.itf.core.model.jpa.message.template.Template;
import org.qubership.automation.itf.core.model.jpa.transport.TransportConfiguration;
import org.qubership.automation.itf.core.util.exception.TransportException;
import org.qubership.automation.itf.core.util.holder.ActiveInterceptorHolder;
import org.qubership.automation.itf.core.util.holder.InterceptorHolder;
import org.qubership.automation.itf.core.util.provider.InterceptorProvider;
import org.qubership.automation.itf.ui.controls.ApplicabilityParamsController;
import org.qubership.automation.itf.ui.controls.util.ControllerHelper;
import org.qubership.automation.itf.ui.messages.UIListImpl;
import org.qubership.automation.itf.ui.messages.exception.UIException;
import org.qubership.automation.itf.ui.messages.objects.UIObject;
import org.qubership.automation.itf.ui.messages.objects.UIResult;
import org.qubership.automation.itf.ui.messages.objects.template.UITemplate;
import org.qubership.automation.itf.ui.messages.objects.transport.UITransport;
import org.qubership.automation.itf.ui.messages.objects.transport.interceptor.UIInterceptor;
import org.qubership.automation.itf.ui.messages.objects.transport.interceptor.UIInterceptorChain;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class InterceptorController
extends ControllerHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(InterceptorController.class);
    private final ApplicabilityParamsController applicabilityParamsController;

    @Autowired
    public InterceptorController(ApplicabilityParamsController applicabilityParamsController) {
        this.applicabilityParamsController = applicabilityParamsController;
    }

    @Transactional(readOnly=true)
    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.automation.itf.ui.util.UserManagementEntities).INTERCEPTOR.getName(),#projectUuid, 'READ')")
    @RequestMapping(value={"/interceptors/bytransport"}, method={RequestMethod.GET})
    @AuditAction(auditAction="Get Interceptors by transport name {{#transportName}} and interceptor group {{#interceptorGroup}} in the project {{#projectUuid}}")
    public UIInterceptorChain getInterceptorsByTransportName(@RequestParam(value="transportName") String transportName, @RequestParam(value="interceptorGroup") String interceptorGroup, @RequestParam(value="projectUuid") UUID projectUuid) {
        UIInterceptorChain result = new UIInterceptorChain();
        Map interceptors = (Map)InterceptorHolder.getInstance().getInterceptors().get(transportName);
        if (interceptors != null) {
            for (Map.Entry interceptor : interceptors.entrySet()) {
                if (!InterceptorController.IsInGroup((Class)interceptor.getValue(), interceptorGroup)) continue;
                UIInterceptor uiInterceptor = new UIInterceptor();
                uiInterceptor.setName((String)interceptor.getKey());
                uiInterceptor.setClassName(((Class)interceptor.getValue()).getName());
                uiInterceptor.setTransportName(transportName);
                uiInterceptor.setInterceptorGroup(interceptorGroup);
                result.getInterceptorChain().add(uiInterceptor);
            }
        }
        return result;
    }

    @Transactional(readOnly=true)
    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.automation.itf.ui.util.UserManagementEntities).INTERCEPTOR.getName(),#projectUuid, 'READ')")
    @RequestMapping(value={"/interceptors/transport_by_provider"}, method={RequestMethod.GET})
    @AuditAction(auditAction="Get Transport types with Interceptors by interceptor provider id {{#interceptorProviderId}} in the project {{#projectUuid}}")
    public UIListImpl getTransportTypesWithInterceptors(@RequestParam(value="interceptorProviderId", defaultValue="0") String interceptorProviderId, @RequestParam(value="projectUuid") UUID projectUuid) {
        UIListImpl<UIObject> result = new UIListImpl<UIObject>();
        List interceptors = InterceptorController.getInterceptorProvider(interceptorProviderId).getInterceptors();
        if (interceptors != null) {
            HashSet<String> transportTypesSet = new HashSet<String>();
            for (Interceptor interceptor : interceptors) {
                transportTypesSet.add(interceptor.getTransportName());
            }
            for (String transportType : transportTypesSet) {
                UIObject obj = new UIObject();
                obj.setClassName(transportType);
                result.addObject(obj);
            }
        }
        return result;
    }

    @Transactional(readOnly=true)
    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.automation.itf.ui.util.UserManagementEntities).INTERCEPTOR.getName(),#projectUuid, 'READ')")
    @RequestMapping(value={"/interceptors/by_provider_transport"}, method={RequestMethod.GET})
    @AuditAction(auditAction="Get Interceptors by interceptor provider id {{#interceptorProviderId}} and Transport {{#transportName}} name in the project {{#projectUuid}}")
    public UIInterceptorChain getInterceptorsByProviderAndTransport(@RequestParam(value="interceptorProviderId", defaultValue="0") String interceptorProviderId, @RequestParam(value="transportName", defaultValue="0") String transportName, @RequestParam(value="projectUuid") UUID projectUuid) {
        UIInterceptorChain uiInterceptorChain = new UIInterceptorChain();
        InterceptorProvider interceptorProvider = InterceptorController.getInterceptorProvider(interceptorProviderId);
        List interceptors = interceptorProvider.getInterceptors();
        if (interceptors != null) {
            for (Interceptor interceptor : interceptors) {
                if (!transportName.equals(interceptor.getTransportName())) continue;
                try {
                    uiInterceptorChain.getInterceptorChain().add(new UIInterceptor(interceptor));
                    uiInterceptorChain.setParentVersion(interceptorProvider.getVersion().toString());
                }
                catch (Exception e) {
                    LOGGER.error("Cannot instantiate the \"{}\" interceptor. Check if the appropriate interceptor's implementation was added and interceptor was successfully registered.\nStacktrace: ", (Object)interceptor.getName(), (Object)e);
                }
            }
        }
        return uiInterceptorChain;
    }

    @Transactional
    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.automation.itf.ui.util.UserManagementEntities).INTERCEPTOR.getName(),#projectUuid, 'CREATE')")
    @RequestMapping(value={"/interceptors"}, method={RequestMethod.POST})
    @AuditAction(auditAction="Create Interceptors by interceptor provider id {{#interceptorProviderId}} in the project {{#projectUuid}}")
    public List<UIInterceptor> addInterceptors(@RequestParam(value="interceptorProviderId", defaultValue="0") String interceptorProviderId, @RequestBody UIInterceptorChain uiInterceptorChain, @RequestParam(value="projectUuid") UUID projectUuid) {
        InterceptorProvider interceptorProvider = InterceptorController.getInterceptorProvider(interceptorProviderId);
        int maxOrder = InterceptorController.getInterceptorsMaxOrder(interceptorProvider.getInterceptors());
        for (UIInterceptor uiInterceptor : uiInterceptorChain.getInterceptorChain()) {
            Interceptor interceptor = InterceptorController.createInterceptorByProvider(interceptorProvider);
            if (interceptorProvider instanceof Template) {
                uiInterceptor.setParent(new UITemplate((Template)interceptorProvider));
            }
            if (interceptorProvider instanceof TransportConfiguration) {
                uiInterceptor.setParent(new UITransport((TransportConfiguration)interceptorProvider));
            }
            InterceptorController.fillInterceptorParams(interceptor, interceptorProvider, uiInterceptor);
            InterceptorController.addInterceptorConfiguration(interceptor, uiInterceptor.getTransportName(), InterceptorController.interceptorParamsToMap(uiInterceptor));
            interceptor.setOrder(++maxOrder);
            interceptorProvider.getInterceptors().add(interceptor);
            interceptor.store();
            uiInterceptor.setId(interceptor.getID().toString());
        }
        return uiInterceptorChain.getInterceptorChain();
    }

    @Transactional
    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.automation.itf.ui.util.UserManagementEntities).INTERCEPTOR.getName(),#projectUuid, 'UPDATE')")
    @RequestMapping(value={"/interceptor"}, method={RequestMethod.PUT})
    @AuditAction(auditAction="Save Interceptor with id {{#uiInterceptor.id}} and Interceptor provider id {{#interceptorProviderId}} in the project {{#projectUuid}}")
    public UIResult saveInterceptor(@RequestParam(value="interceptorProviderId", defaultValue="0") String interceptorProviderId, @RequestBody UIInterceptor uiInterceptor, @RequestParam(value="projectUuid") UUID projectUuid) {
        Interceptor interceptor = InterceptorController.findInterceptorByIdAndProvider(uiInterceptor.getId(), InterceptorController.getInterceptorProvider(interceptorProviderId));
        InterceptorController.throwExceptionIfNull((Storable)interceptor, uiInterceptor.getName(), uiInterceptor.getId(), Interceptor.class, "get Interceptor by id");
        UIResult result = uiInterceptor.validate();
        if (result.isSuccess() && (result = this.applicabilityParamsController.update(uiInterceptor.getApplicabilityParams(), projectUuid, interceptor.getClass())).isSuccess()) {
            interceptor.setName(uiInterceptor.getName());
            List paramsList = interceptor.getInterceptorParams();
            InterceptorParams params = paramsList.isEmpty() ? new InterceptorParams() : (InterceptorParams)paramsList.get(0);
            params.update(InterceptorController.interceptorParamsToMap(uiInterceptor));
            if (paramsList.isEmpty()) {
                paramsList.add(params);
            }
            if (interceptor.isActive()) {
                InterceptorController.reactivateInterceptor((Map)ActiveInterceptorHolder.getInstance().getActiveInterceptors().get(interceptorProviderId), interceptor, interceptorProviderId);
            }
        }
        interceptor.store();
        interceptor.flush();
        result.getData().put("parentVersion", interceptor.getParent().getVersion().toString());
        return result;
    }

    @Transactional
    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.automation.itf.ui.util.UserManagementEntities).INTERCEPTOR.getName(),#projectUuid, 'UPDATE')")
    @RequestMapping(value={"/interceptor/state"}, method={RequestMethod.PUT})
    @AuditAction(auditAction="Change state of the Interceptor with id {{#uiInterceptor.id}} and Interceptor provider id {{#interceptorProviderId}} in the project {{#projectUuid}}")
    public UIResult changeState(@RequestParam(value="interceptorProviderId", defaultValue="0") String interceptorProviderId, @RequestBody UIInterceptor uiInterceptor, @RequestParam(value="projectUuid") UUID projectUuid) {
        Interceptor interceptor = InterceptorController.findInterceptorByIdAndProvider(uiInterceptor.getId(), InterceptorController.getInterceptorProvider(interceptorProviderId));
        InterceptorController.throwExceptionIfNull((Storable)interceptor, uiInterceptor.getName(), uiInterceptor.getId(), Interceptor.class, "get Interceptor by id");
        if (uiInterceptor.isActive()) {
            try {
                String validationResult = interceptor.validate();
                if (StringUtils.isNotEmpty((CharSequence)validationResult)) {
                    return new UIResult(false, validationResult);
                }
            }
            catch (Exception e) {
                String error = "Error while validation of the interceptor's state changing.";
                LOGGER.error(error, (Throwable)e);
                throw new UIException(error);
            }
        }
        interceptor.setActive(uiInterceptor.isActive());
        Map objectInterceptorMap = (Map)ActiveInterceptorHolder.getInstance().getActiveInterceptors().get(interceptorProviderId);
        if (!uiInterceptor.isActive()) {
            objectInterceptorMap.remove(interceptor.getID().toString());
        } else {
            InterceptorController.reactivateInterceptor(objectInterceptorMap, interceptor, interceptorProviderId);
        }
        return new UIResult();
    }

    @Transactional
    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.automation.itf.ui.util.UserManagementEntities).INTERCEPTOR.getName(),#projectUuid, 'UPDATE')")
    @RequestMapping(value={"/interceptor/order"}, method={RequestMethod.PUT})
    @AuditAction(auditAction="Change order of Interceptors under Interceptor provider id {{#interceptorProviderId}} in the project {{#projectUuid}}")
    public void changeOrder(@RequestParam(value="interceptorProviderId", defaultValue="0") String interceptorProviderId, @RequestBody UIInterceptorChain uiInterceptors, @RequestParam(value="projectUuid") UUID projectUuid) {
        InterceptorProvider interceptorProvider = InterceptorController.getInterceptorProvider(interceptorProviderId);
        block0: for (Interceptor interceptor : interceptorProvider.getInterceptors()) {
            for (UIInterceptor uiInterceptor : uiInterceptors.getInterceptorChain()) {
                if (!Objects.equals(interceptor.getID().toString(), uiInterceptor.getId())) continue;
                interceptor.setOrder(uiInterceptor.getOrder());
                continue block0;
            }
        }
    }

    @Transactional
    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.automation.itf.ui.util.UserManagementEntities).INTERCEPTOR.getName(),#projectUuid, 'DELETE')")
    @RequestMapping(value={"/interceptors"}, method={RequestMethod.DELETE})
    @AuditAction(auditAction="Delete Interceptors under Interceptor provider id {{#interceptorProviderId}} in the project {{#projectUuid}}")
    public UIInterceptorChain deleteInterceptor(@RequestParam(value="interceptorProviderId", defaultValue="0") String interceptorProviderId, @RequestBody UIInterceptorChain uiInterceptors, @RequestParam(value="projectUuid") UUID projectUuid) throws TransportException {
        InterceptorProvider interceptorProvider = InterceptorController.getInterceptorProvider(interceptorProviderId);
        ArrayList<Object> listForDeletedInterceptors = new ArrayList<Object>();
        block0: for (Object interceptor : interceptorProvider.getInterceptors()) {
            for (UIInterceptor uiInterceptor : uiInterceptors.getInterceptorChain()) {
                if (!Objects.equals(interceptor.getID().toString(), uiInterceptor.getId())) continue;
                listForDeletedInterceptors.add(interceptor);
                continue block0;
            }
        }
        Map objectInterceptorMap = (Map)ActiveInterceptorHolder.getInstance().getActiveInterceptors().get(interceptorProviderId);
        if (objectInterceptorMap != null) {
            for (Interceptor interceptor : listForDeletedInterceptors) {
                objectInterceptorMap.remove(interceptor.getID().toString());
            }
        }
        interceptorProvider.getInterceptors().removeAll(listForDeletedInterceptors);
        listForDeletedInterceptors.forEach(Storable::remove);
        UIInterceptorChain result = new UIInterceptorChain();
        for (Interceptor interceptor : interceptorProvider.getInterceptors()) {
            UIInterceptor uiInterceptor = new UIInterceptor(interceptor);
            result.getInterceptorChain().add(uiInterceptor);
        }
        interceptorProvider.store();
        interceptorProvider.flush();
        result.setParentVersion(interceptorProvider.getVersion().toString());
        return result;
    }

    @Transactional(readOnly=true)
    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.automation.itf.ui.util.UserManagementEntities).INTERCEPTOR.getName(),#projectUuid, 'UPDATE')")
    @RequestMapping(value={"/interceptors/refresh_interceptor_holder"}, method={RequestMethod.GET})
    @AuditAction(auditAction="Refresh Interceptors Holder, project {{#projectUuid}}")
    public void refreshInterceptorHolder(@RequestParam(value="projectUuid") UUID projectUuid) {
        InterceptorHolder.getInstance().clearInterceptorHolder();
        InterceptorHolder.getInstance().fillInterceptorHolder();
    }

    @Transactional(readOnly=true)
    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.automation.itf.ui.util.UserManagementEntities).INTERCEPTOR.getName(),#projectUuid, 'UPDATE')")
    @RequestMapping(value={"/interceptors/refresh_active_interceptor_holder"}, method={RequestMethod.GET})
    @AuditAction(auditAction="Refresh active Interceptors Holder, project {{#projectUuid}}")
    public void refreshActiveInterceptorHolder(@RequestParam(value="projectUuid") UUID projectUuid) {
        ActiveInterceptorHolder.getInstance().clearActiveInterceptorHolder();
        ActiveInterceptorHolder.getInstance().fillActiveInterceptorHolder();
    }
}

