/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.ui.controls.entities.situation;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import org.qubership.automation.itf.core.hibernate.spring.managers.custom.ByProject;
import org.qubership.automation.itf.core.model.jpa.system.stub.Situation;
import org.qubership.automation.itf.core.model.jpa.system.stub.SituationEventTrigger;
import org.qubership.automation.itf.core.util.manager.CoreObjectManager;
import org.qubership.automation.itf.ui.controls.util.ControllerConstants;
import org.qubership.automation.itf.ui.messages.UIObjectList;
import org.qubership.automation.itf.ui.messages.objects.UISituation;
import org.qubership.automation.itf.ui.messages.objects.UITriggerRelation;
import org.qubership.automation.itf.ui.messages.objects.eventtrigger.UIEventTrigger;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class SituationTriggerController {
    @Transactional(readOnly=true)
    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.automation.itf.ui.util.UserManagementEntities).SITUATION.getName(),#projectUuid, 'READ')")
    @RequestMapping(value={"/situation/downstream/start"}, method={RequestMethod.GET})
    public UIObjectList getDownstreamSituationsOnStart(@RequestParam(value="id", defaultValue="0") String id, @RequestParam(value="projectId") BigInteger projectId, @RequestParam(value="projectUuid") UUID projectUuid) throws Exception {
        return this.getDownstreamSituations(id, SituationEventTrigger.On.START, projectId);
    }

    @Transactional(readOnly=true)
    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.automation.itf.ui.util.UserManagementEntities).SITUATION.getName(),#projectUuid, 'READ')")
    @RequestMapping(value={"/situation/downstream/finish"}, method={RequestMethod.GET})
    public UIObjectList getDownstreamSituationsOnFinish(@RequestParam(value="id", defaultValue="0") String id, @RequestParam(value="projectId") BigInteger projectId, @RequestParam(value="projectUuid") UUID projectUuid) throws Exception {
        return this.getDownstreamSituations(id, SituationEventTrigger.On.FINISH, projectId);
    }

    @Transactional(readOnly=true)
    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.automation.itf.ui.util.UserManagementEntities).SITUATION.getName(),#projectUuid, 'READ')")
    @RequestMapping(value={"/situation/triggers"}, method={RequestMethod.GET})
    public List<UITriggerRelation> getTriggers(@RequestParam(value="id", defaultValue="0") String id, @RequestParam(value="projectUuid") UUID projectUuid) throws Exception {
        return new ArrayList<UITriggerRelation>();
    }

    private UIObjectList getDownstreamSituations(String id, SituationEventTrigger.On on, BigInteger projectId) {
        HashSet downstreamSituations = Sets.newHashSetWithExpectedSize((int)20);
        Collection all = ((ByProject)CoreObjectManager.getInstance().getSpecialManager(Situation.class, ByProject.class)).getAllByProject((Object)projectId);
        for (Situation situation : all) {
            for (SituationEventTrigger trigger : situation.getSituationEventTriggers()) {
                Situation triggerSituation = trigger.getSituation();
                SituationEventTrigger.On triggerOn = trigger.getOn();
                if (triggerSituation == null || !triggerSituation.getID().toString().equals(id) || triggerOn == null || !triggerOn.equals((Object)on)) continue;
                downstreamSituations.add(situation);
            }
        }
        UIObjectList uiObjectList = new UIObjectList();
        for (Situation downstreamSituation : downstreamSituations) {
            UISituation uiSituation = new UISituation(downstreamSituation);
            ArrayList triggersToStay = Lists.newArrayListWithCapacity((int)uiSituation.getTriggers().size());
            for (UIEventTrigger trigger : uiSituation.getTriggers()) {
                if (!ControllerConstants.SITUATION_EVENT_TRIGGER_TYPE.getStringValue().equals(trigger.getType()) || trigger.getListen() == null || trigger.getListen().getId() == null || !trigger.getListen().getId().equals(id)) continue;
                triggersToStay.add(trigger);
            }
            uiSituation.setTriggers(triggersToStay);
            uiObjectList.addObject(uiSituation);
        }
        return uiObjectList;
    }
}

