/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.ui.controls.entities.situation;

import com.google.common.collect.Sets;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.qubership.atp.integration.configuration.configuration.AuditAction;
import org.qubership.automation.itf.core.exceptions.configuration.ConfigurationException;
import org.qubership.automation.itf.core.hibernate.spring.managers.base.ObjectManager;
import org.qubership.automation.itf.core.model.common.Storable;
import org.qubership.automation.itf.core.model.jpa.step.IntegrationStep;
import org.qubership.automation.itf.core.model.jpa.step.SituationStep;
import org.qubership.automation.itf.core.model.jpa.system.operation.Operation;
import org.qubership.automation.itf.core.model.jpa.system.stub.OperationEventTrigger;
import org.qubership.automation.itf.core.model.jpa.system.stub.Situation;
import org.qubership.automation.itf.core.model.jpa.system.stub.SituationEventTrigger;
import org.qubership.automation.itf.core.model.jpa.transport.TransportConfiguration;
import org.qubership.automation.itf.core.model.usage.UsageInfo;
import org.qubership.automation.itf.core.util.manager.CoreObjectManager;
import org.qubership.automation.itf.ui.controls.util.ControllerHelper;
import org.qubership.automation.itf.ui.messages.UIIds;
import org.qubership.automation.itf.ui.messages.UIObjectList;
import org.qubership.automation.itf.ui.messages.objects.UIOperation;
import org.qubership.automation.itf.ui.messages.objects.UISituation;
import org.qubership.automation.itf.ui.messages.objects.transport.UITransport;
import org.qubership.automation.itf.ui.messages.objects.wrap.UIWrapper;
import org.qubership.automation.itf.ui.util.UIHelper;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Deprecated
@RestController
public class SituationUtilController {
    @Transactional
    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.automation.itf.ui.util.UserManagementEntities).SITUATION.getName(),#projectUuid, 'READ')")
    @RequestMapping(value={"/situation/usages"}, method={RequestMethod.POST})
    @AuditAction(auditAction="Get all usages of selected Situations in the project {{#projectUuid}}")
    public Map<String, Object> getUsages(@RequestBody UIIds uiSituation, @RequestParam(value="projectUuid") UUID projectUuid) throws Exception {
        ObjectManager situationManager = CoreObjectManager.getInstance().getManager(Situation.class);
        HashMap<String, Object> usages = new HashMap<String, Object>();
        ArrayList usage = new ArrayList();
        for (String situationId : uiSituation.getIds()) {
            Situation situation = (Situation)situationManager.getById((Object)situationId);
            ControllerHelper.throwExceptionIfNull((Storable)situation, "", situationId, Situation.class, "get Situation by id");
            Collection usageInfo = situationManager.findUsages((Storable)situation);
            HashMap<String, String> situationProperties = new HashMap<String, String>();
            HashMap<String, Cloneable> usageProperties = new HashMap<String, Cloneable>();
            ArrayList<Map<String, Object>> usagesObjectsList = new ArrayList<Map<String, Object>>();
            if (usageInfo == null) {
                throw new Exception("Usage info for " + uiSituation + " not found");
            }
            situationProperties.put("situationId", situation.getID().toString());
            situationProperties.put("situationName", situation.getName());
            usageProperties.put("situation", situationProperties);
            for (UsageInfo item : usageInfo) {
                usagesObjectsList.add(this.getUsagesObjectProperties(item, situation));
            }
            usageProperties.put("usagesObjects", usagesObjectsList);
            usage.add(usageProperties);
        }
        usages.put("usages", usage);
        return usages;
    }

    @Transactional(readOnly=true)
    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.automation.itf.ui.util.UserManagementEntities).SITUATION.getName(),#projectUuid, 'READ')")
    @RequestMapping(value={"/situation/byparent"}, method={RequestMethod.GET})
    @AuditAction(auditAction="Get Situations under Operation id {{#id}} in the project {{#projectUuid}}")
    public UIObjectList getSituationsByParent(@RequestParam(value="id", defaultValue="0") String id, @RequestParam(value="projectUuid") UUID projectUuid) {
        Collection situations = CoreObjectManager.getInstance().getManager(Situation.class).getAllByParentId((Object)id);
        return UIHelper.getObjectList(situations);
    }

    @Transactional(readOnly=true)
    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.automation.itf.ui.util.UserManagementEntities).SITUATION.getName(),#projectUuid, 'READ')")
    @RequestMapping(value={"/situation/outbound"}, method={RequestMethod.GET})
    @AuditAction(auditAction="Get Outbound Situations in the project {{#projectId}}/{{#projectUuid}}")
    public UIObjectList getSituationsOutbound(@RequestParam(value="projectId") BigInteger projectId, @RequestParam(value="projectUuid") UUID projectUuid) {
        Collection situations = CoreObjectManager.getInstance().getManager(Situation.class).getAll();
        return UIHelper.getObjectList(situations);
    }

    @Deprecated
    @Transactional
    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.automation.itf.ui.util.UserManagementEntities).SITUATION.getName(),#projectUuid, 'CREATE')")
    @RequestMapping(value={"/situation/simple"}, method={RequestMethod.POST})
    @AuditAction(auditAction="Create Situation under Operation with id {{#uiOperation.id}} in the project {{#projectUuid}}")
    public UISituation add(@RequestBody UIOperation uiOperation, @RequestParam(value="projectUuid") UUID projectUuid) throws Exception {
        Operation operation = this.updateTransportOnOperation(uiOperation);
        Situation situation = (Situation)CoreObjectManager.getInstance().getManager(Situation.class).create((Storable)operation);
        situation.setName("New Situation");
        CoreObjectManager.getInstance().getManager(IntegrationStep.class).create((Storable)situation, "integrationStep");
        if (situation.getMep().isInboundRequest()) {
            OperationEventTrigger eventTrigger = (OperationEventTrigger)CoreObjectManager.getInstance().getManager(OperationEventTrigger.class).create((Storable)situation, "Operation Event Trigger");
            situation.fillOperationEventTriggers((Set)Sets.newHashSet((Object[])new OperationEventTrigger[]{eventTrigger}));
        }
        situation.store();
        situation.flush();
        return new UISituation(situation);
    }

    private Map<String, Object> getUsagesObjectProperties(UsageInfo item, Situation situation) {
        HashMap<String, Object> objectProperties = new HashMap<String, Object>();
        objectProperties.put("usagesId", item.getReferer().getParent().getID().toString());
        objectProperties.put("usagesName", item.getReferer().getParent().getName());
        if (item.getReferer() instanceof SituationStep) {
            SituationStep situationStep = (SituationStep)item.getReferer();
            objectProperties.put("stepPosition", situationStep.getOrder() + 1);
            objectProperties.put("objectType", "situationStep");
            objectProperties.put("stepId", situationStep.getID().toString());
            if (situationStep.getSituation() != null && situationStep.getSituation().getID() == situation.getID()) {
                objectProperties.put("isSituation", "true");
            }
            if (!situationStep.getEndSituations().isEmpty()) {
                for (Situation endSituation : situationStep.getEndSituations()) {
                    if (endSituation.getID() != situation.getID()) continue;
                    objectProperties.put("isEndSituation", "true");
                    break;
                }
            }
            if (!situationStep.getExceptionalSituations().isEmpty()) {
                for (Situation exSituation : situationStep.getExceptionalSituations()) {
                    if (exSituation.getID() != situation.getID()) continue;
                    objectProperties.put("isExceptionalSituation", "true");
                    break;
                }
            }
        } else if (item.getReferer() instanceof SituationEventTrigger) {
            SituationEventTrigger situationInCondition = (SituationEventTrigger)item.getReferer();
            objectProperties.put("situationPosition", situationInCondition.getOn());
            objectProperties.put("operationIdForLink", situationInCondition.getParent().getParent().getID().toString());
            objectProperties.put("objectType", "situation");
        }
        return objectProperties;
    }

    private Operation updateTransportOnOperation(UIOperation uiOperation) {
        Operation operation = (Operation)CoreObjectManager.getInstance().getManager(Operation.class).getById((Object)uiOperation.getId());
        ControllerHelper.throwExceptionIfNull((Storable)operation, uiOperation.getName(), uiOperation.getId(), Operation.class, "update Transport on Operation");
        UIWrapper<UITransport> transport = uiOperation.getTransport();
        if (transport == null) {
            throw new ConfigurationException("Transport isn't specified on operation. Please set transport first.");
        }
        TransportConfiguration transportConfiguration = (TransportConfiguration)CoreObjectManager.getInstance().getManager(TransportConfiguration.class).getById((Object)transport.getData().getId());
        ControllerHelper.throwExceptionIfNull((Storable)transportConfiguration, transport.getData().getName(), transport.getData().getId(), TransportConfiguration.class, "update Transport on Operation");
        if (!transportConfiguration.equals((Object)operation.getTransport())) {
            operation.setTransport(transportConfiguration);
            operation.store();
        }
        return operation;
    }
}

