/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.ui.controls.entities.transport;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import org.qubership.atp.integration.configuration.configuration.AuditAction;
import org.qubership.automation.itf.core.hibernate.spring.managers.custom.SearchByProjectIdManager;
import org.qubership.automation.itf.core.model.jpa.transport.TransportConfiguration;
import org.qubership.automation.itf.core.util.constants.TransportState;
import org.qubership.automation.itf.core.util.manager.CoreObjectManager;
import org.qubership.automation.itf.core.util.transport.manager.TransportRegistryManager;
import org.qubership.automation.itf.ui.messages.objects.transport.UITransportState;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class TransportStateController {
    @Transactional(readOnly=true)
    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.automation.itf.ui.util.UserManagementEntities).TRANSPORT.getName(),#projectUuid, 'READ')")
    @RequestMapping(value={"/transport/check"}, method={RequestMethod.GET})
    @AuditAction(auditAction="Check Transports Deploy summary state for project {{#projectId}}/{{#projectUuid}}")
    public String checkDeploy(@RequestParam(value="projectId") BigInteger projectId, @RequestParam(value="projectUuid") UUID projectUuid) {
        Set<String> types = this.getTypes(projectId).keySet();
        boolean ok = true;
        boolean inProgress = true;
        block4: for (String type : types) {
            TransportState state = TransportRegistryManager.getInstance().getState(type);
            switch (state) {
                case NOT_READY: 
                case UNDEPLOYED: {
                    ok = false;
                    inProgress = false;
                    continue block4;
                }
                case READY: {
                    inProgress = false;
                    continue block4;
                }
            }
            inProgress = true;
        }
        if (ok && !inProgress) {
            return "{\"state\" : \"ok\"}";
        }
        if (inProgress) {
            return "{\"state\" : \"deploying\"}";
        }
        return "{\"state\" : \"nok\"}";
    }

    @Transactional(readOnly=true)
    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.automation.itf.ui.util.UserManagementEntities).TRANSPORT.getName(),#projectUuid, 'READ')")
    @RequestMapping(value={"/transport/state"}, method={RequestMethod.GET})
    @AuditAction(auditAction="Get Transport states for project {{#projectId}}/{{#projectUuid}}")
    public List<UITransportState> getStates(@RequestParam(value="projectId") BigInteger projectId, @RequestParam(value="projectUuid") UUID projectUuid) {
        Map<String, AtomicInteger> types = this.getTypes(projectId);
        ArrayList states = Lists.newArrayListWithCapacity((int)types.size());
        for (Map.Entry<String, AtomicInteger> entry : types.entrySet()) {
            String type = entry.getKey();
            TransportState state = TransportRegistryManager.getInstance().getState(type);
            UITransportState uiTransportState = new UITransportState();
            uiTransportState.setTypeName(type);
            uiTransportState.setState(state.toString());
            uiTransportState.setUsageInfo(entry.getValue().get());
            if (TransportState.UNDEPLOYED.equals((Object)state) || TransportState.NOT_READY.equals((Object)state)) {
                uiTransportState.setUserName(type);
            } else {
                try {
                    uiTransportState.setUserName((String)TransportRegistryManager.getInstance().getTransportTypes().get(type));
                    uiTransportState.defineProperties(TransportRegistryManager.getInstance().getProperties(type));
                }
                catch (Exception e) {
                    uiTransportState.setUserName(type + " (There are exception(s); may be undeployed? " + e.getMessage() + ")");
                }
            }
            states.add(uiTransportState);
        }
        return states;
    }

    private Map<String, AtomicInteger> getTypes(BigInteger projectId) {
        Collection all = ((SearchByProjectIdManager)CoreObjectManager.getInstance().getSpecialManager(TransportConfiguration.class, SearchByProjectIdManager.class)).getByProjectId(projectId);
        HashMap types = Maps.newHashMapWithExpectedSize((int)10);
        for (TransportConfiguration configuration : all) {
            if (types.containsKey(configuration.getTypeName())) {
                ((AtomicInteger)types.get(configuration.getTypeName())).incrementAndGet();
                continue;
            }
            types.put(configuration.getTypeName(), new AtomicInteger(1));
        }
        return types;
    }
}

