/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.ui.controls.files;

import java.io.IOException;
import java.util.List;
import java.util.UUID;
import org.qubership.atp.integration.configuration.configuration.AuditAction;
import org.qubership.automation.itf.core.util.eds.service.EdsContentType;
import org.qubership.automation.itf.core.util.exception.ExportException;
import org.qubership.automation.itf.executor.service.FileDownloaderService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.InputStreamResource;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class FileDownloadController {
    private static final Logger log = LoggerFactory.getLogger(FileDownloadController.class);
    private final FileDownloaderService fileDownloaderService;

    public FileDownloadController(FileDownloaderService fileDownloaderService) {
        this.fileDownloaderService = fileDownloaderService;
    }

    @PreAuthorize(value="(@entityAccess.checkAccess(#projectUuid, \"READ\") and !#typesToDownload.contains(T(org.qubership.automation.itf.core.util.eds.service.EdsContentType).KEYSTORE)) or (@entityAccess.isSupport() or @entityAccess.isAdmin())")
    @GetMapping(value={"/project/files/download"}, produces={"application/zip"})
    @AuditAction(auditAction="Download files of {{#typesToDownload}} types from project {{#projectUuid}}")
    public ResponseEntity<InputStreamResource> downloadProjectFiles(@RequestParam List<EdsContentType> typesToDownload, @RequestParam UUID projectUuid) throws IOException, ExportException {
        if (typesToDownload.isEmpty()) {
            throw new IllegalArgumentException("Something went wrong: 'typesToDownload' parameter is empty...");
        }
        return this.fileDownloaderService.zipProjectFiles(typesToDownload, projectUuid);
    }

    @PreAuthorize(value="@entityAccess.checkAccess(#projectUuid, \"READ\")")
    @GetMapping(value={"/project/file/download"})
    public ResponseEntity<InputStreamResource> downloadProjectFile(@RequestParam String fileName, @RequestParam String filePath, @RequestParam EdsContentType contentType, @RequestParam UUID projectUuid) throws IOException, ExportException {
        return this.fileDownloaderService.projectFiles(fileName, filePath, contentType, projectUuid);
    }
}

