/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.ui.controls.files;

import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.text.SimpleDateFormat;
import java.util.Base64;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.bson.types.ObjectId;
import org.qubership.automation.itf.core.util.eds.ExternalDataManagementService;
import org.qubership.automation.itf.core.util.eds.model.FileEventType;
import org.qubership.automation.itf.core.util.eds.model.UIFileInfo;
import org.qubership.automation.itf.core.util.eds.service.EdsContentType;
import org.qubership.automation.itf.core.util.eds.service.EdsMetaInfo;
import org.qubership.automation.itf.core.util.eds.service.FileManagementService;
import org.qubership.automation.itf.executor.service.ExecutorToMessageBrokerSender;
import org.qubership.automation.itf.ui.messages.objects.UIResult;
import org.qubership.automation.itf.ui.messages.objects.file.TreeNode;
import org.qubership.automation.itf.ui.util.FileUploadHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class FileManagerService {
    private static final Logger log = LoggerFactory.getLogger(FileManagerService.class);
    private static final SimpleDateFormat dateFormat = new SimpleDateFormat("dd-MM-yyyy HH:mm:ss");
    private final ExternalDataManagementService externalDataManagementService;
    private final ExecutorToMessageBrokerSender executorToMessageBrokerSender;
    private final FileManagementService fileManagementService;
    @Value(value="${eds.gridfs.enabled}")
    private boolean edsGridfsEnabled;

    public FileManagerService(ExternalDataManagementService externalDataManagementService, ExecutorToMessageBrokerSender executorToMessageBrokerSender, FileManagementService fileManagementService) {
        this.externalDataManagementService = externalDataManagementService;
        this.executorToMessageBrokerSender = executorToMessageBrokerSender;
        this.fileManagementService = fileManagementService;
    }

    public TreeNode[] getPathTreeNode(UUID projectUuid) {
        TreeNode rootTreeNode = new TreeNode();
        rootTreeNode.setText("/");
        rootTreeNode.setContentType("ROOT");
        List<TreeNode> nodeList = rootTreeNode.getNodes();
        TreeNode datasetNode = new TreeNode(EdsContentType.DATASET.getStringValue(), EdsContentType.DATASET.getStringValue());
        this.buildTree(datasetNode, datasetNode.getFilePath(), datasetNode.getContentType(), projectUuid);
        nodeList.add(datasetNode);
        TreeNode diameterNode = new TreeNode(EdsContentType.DIAMETER_DICTIONARY.getStringValue(), EdsContentType.DIAMETER_DICTIONARY.getStringValue());
        this.buildTree(diameterNode, diameterNode.getFilePath(), diameterNode.getContentType(), projectUuid);
        nodeList.add(diameterNode);
        TreeNode fastStubNode = new TreeNode(EdsContentType.FAST_STUB.getStringValue(), EdsContentType.FAST_STUB.getStringValue());
        this.buildTree(fastStubNode, fastStubNode.getFilePath(), fastStubNode.getContentType(), projectUuid);
        nodeList.add(fastStubNode);
        TreeNode keystoreNode = new TreeNode(EdsContentType.KEYSTORE.getStringValue(), EdsContentType.KEYSTORE.getStringValue());
        nodeList.add(keystoreNode);
        TreeNode wsdlXsdNode = new TreeNode(EdsContentType.WSDL_XSD.getStringValue(), EdsContentType.WSDL_XSD.getStringValue());
        this.buildTree(wsdlXsdNode, wsdlXsdNode.getFilePath(), wsdlXsdNode.getContentType(), projectUuid);
        nodeList.add(wsdlXsdNode);
        return new TreeNode[]{rootTreeNode};
    }

    public Set<UIFileInfo> getFilesByPath(String filePath, EdsContentType contentType, UUID projectUuid) {
        String sanitizedFilePath = FilenameUtils.normalize((String)filePath);
        return this.edsGridfsEnabled ? this.getFilesInfoFromExternalStorage(sanitizedFilePath, contentType.getStringValue(), projectUuid) : this.getFilesInfoFromCurrentService(sanitizedFilePath, contentType.getStringValue(), projectUuid);
    }

    public UIResult remove(List<UIFileInfo> filesInfo, UUID projectUuid, String tenantId) throws IOException {
        try {
            for (UIFileInfo uiFileInfo : filesInfo) {
                this.externalDataManagementService.getExternalStorageService().delete(uiFileInfo.getContentType(), EdsContentType.KEYSTORE.getStringValue().equals(uiFileInfo.getContentType()) ? null : projectUuid, uiFileInfo.getFilePath(), uiFileInfo.getFileName());
                log.info("File by path '{}' was deleted from external storage successfully. Prepare to notify others via topic...", (Object)this.fileManagementService.getDirectoryPath(uiFileInfo.getContentType(), projectUuid, uiFileInfo.getFilePath()).resolve(uiFileInfo.getFileName()));
                FileUploadHelper.checkStoredObjectIdAndSendMessageToExternalDataStorageUpdateTopic(null, uiFileInfo.getFileName(), uiFileInfo.getFilePath(), uiFileInfo.getContentType(), projectUuid, null, FileEventType.DELETE, this.executorToMessageBrokerSender, tenantId);
            }
            return new UIResult(true, "");
        }
        catch (Exception e) {
            return new UIResult(false, "An error occurred while deleting of file(s).");
        }
    }

    public UIResult getContent(EdsContentType contentType, String filePath, String fileName, UUID projectUuid) {
        try {
            String content;
            boolean isImageFile;
            String sanitizedFileName = FilenameUtils.getName((String)fileName);
            String sanitizedFilePath = FilenameUtils.normalize((String)filePath);
            Path path = this.fileManagementService.getDirectoryPath(contentType.getStringValue(), projectUuid, sanitizedFilePath).resolve(sanitizedFileName);
            File srcFile = new File(path.toString());
            String fileContentType = Files.probeContentType(path);
            if (Objects.isNull(fileContentType)) {
                Pattern pattern = Pattern.compile("\\.(jpe?g|gif|bmp|png|svg|tiff?)$");
                Matcher matcher = pattern.matcher(sanitizedFileName);
                isImageFile = matcher.find();
            } else {
                isImageFile = fileContentType.contains("image/");
            }
            if (isImageFile) {
                byte[] bytes = FileUtils.readFileToByteArray((File)srcFile);
                content = Base64.getEncoder().encodeToString(bytes);
            } else {
                content = FileUtils.readFileToString((File)srcFile);
            }
            UIResult uiResult = new UIResult();
            uiResult.setMessage(content);
            return uiResult;
        }
        catch (Exception e) {
            String error = "An error occurred while getting file contents. ";
            log.error(error, (Throwable)e);
            return new UIResult(false, error + e.getMessage());
        }
    }

    private void buildTree(TreeNode rootTreeNode, String filePath, String contentType, UUID projectUuid) {
        Path path = this.fileManagementService.getDirectoryPath(contentType, projectUuid, filePath);
        if (!new File(path.toString()).exists()) {
            return;
        }
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(path);){
            for (Path pathObj : directoryStream) {
                BasicFileAttributes attributes = Files.readAttributes(pathObj, BasicFileAttributes.class, new LinkOption[0]);
                if (!attributes.isDirectory()) continue;
                TreeNode childTreeNode = new TreeNode();
                childTreeNode.setText(pathObj.getFileName().toString());
                childTreeNode.setFilePath(Paths.get(rootTreeNode.getFilePath(), pathObj.getFileName().toString()).toString());
                childTreeNode.setContentType(contentType);
                rootTreeNode.getNodes().add(childTreeNode);
                this.buildTree(childTreeNode, childTreeNode.getFilePath(), contentType, projectUuid);
            }
        }
        catch (Exception e) {
            log.error("An error occurred while getting path for files from storage.", (Throwable)e);
        }
    }

    private Set<UIFileInfo> getFilesInfoFromExternalStorage(String filePath, String contentType, UUID projectUuid) {
        try {
            Set filesInfo;
            if (EdsContentType.KEYSTORE.getStringValue().equals(contentType)) {
                filesInfo = this.externalDataManagementService.getExternalStorageService().getKeyStoreFileInfo();
            } else {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put(EdsMetaInfo.FILE_PATH.getStringValue(), StringUtils.isBlank((CharSequence)filePath) ? filePath : "/" + filePath.replaceAll("\\\\", "/"));
                map.put(EdsMetaInfo.CONTENT_TYPE.getStringValue(), contentType);
                map.put(EdsMetaInfo.PROJECT_UUID.getStringValue(), projectUuid);
                filesInfo = this.externalDataManagementService.getExternalStorageService().getFilesInfoByMetadataMapParams(map);
            }
            return filesInfo.stream().map(fileInfo -> new UIFileInfo(fileInfo.getObjectId().toString(), fileInfo.getFileName(), fileInfo.getFilePath(), fileInfo.getFileLength(), dateFormat.format(fileInfo.getUploadDate()), fileInfo.getContentType(), fileInfo.getUserName())).collect(Collectors.toSet());
        }
        catch (Exception e) {
            log.error("An error occurred while getting files from external storage.", (Throwable)e);
            return Collections.emptySet();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Set<UIFileInfo> getFilesInfoFromCurrentService(String filePath, String contentType, UUID projectUuid) {
        Path folderPath = this.fileManagementService.getDirectoryPath(contentType, projectUuid, filePath);
        if (!new File(folderPath.toString()).exists()) {
            return Collections.emptySet();
        }
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(folderPath);){
            HashSet<UIFileInfo> files = new HashSet<UIFileInfo>();
            for (Path path : directoryStream) {
                BasicFileAttributes attributes = Files.readAttributes(path, BasicFileAttributes.class, new LinkOption[0]);
                if (attributes.isDirectory()) continue;
                UIFileInfo fileInfo = new UIFileInfo(ObjectId.get().toString(), path.getFileName().toString(), filePath, Long.valueOf(attributes.size()), dateFormat.format(new Date(attributes.lastModifiedTime().toMillis())), contentType, "Undefined");
                files.add(fileInfo);
            }
            HashSet<UIFileInfo> hashSet = files;
            return hashSet;
        }
        catch (IOException e) {
            log.error("An error occurred while getting files from local storage (path {}, contentType {}, project {})", new Object[]{filePath, contentType, projectUuid, e});
            return Collections.emptySet();
        }
    }
}

