/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.ui.controls.integration;

import java.util.HashMap;
import java.util.Map;
import org.qubership.automation.itf.core.model.communication.TransportType;

public class InboundTransportClassToTypeMapping {
    private static final Map<String, TransportType> transportClassToType = InboundTransportClassToTypeMapping.initializeMap();

    private static Map<String, TransportType> initializeMap() {
        HashMap<String, TransportType> map = new HashMap<String, TransportType>();
        map.put("org.qubership.automation.itf.transport.cli.inbound.CLIInboundTransport", TransportType.CLI_INBOUND);
        map.put("org.qubership.automation.itf.transport.file.inbound.FileInbound", TransportType.FILE_INBOUND);
        map.put("org.qubership.automation.itf.transport.http.inbound.HTTPInboundTransport", TransportType.HTTP_INBOUND);
        map.put("org.qubership.automation.itf.transport.http2.inbound.HTTP2InboundTransport", TransportType.HTTP2_INBOUND);
        map.put("org.qubership.automation.itf.transport.jms.inbound.JMSInboundTransport", TransportType.JMS_INBOUND);
        map.put("org.qubership.automation.itf.transport.kafka.inbound.KafkaInboundTransport", TransportType.KAFKA_INBOUND);
        map.put("org.qubership.automation.itf.transport.rest.inbound.RESTInboundTransport", TransportType.REST_INBOUND);
        map.put("org.qubership.automation.itf.transport.snmp.inbound.SNMPInboundTransport", TransportType.SNMP_INBOUND);
        map.put("org.qubership.automation.itf.transport.smpp.inbound.SmppInboundTransport", TransportType.SMPP_INBOUND);
        map.put("org.qubership.automation.itf.transport.soap.http.inbound.SOAPOverHTTPInboundTransport", TransportType.SOAP_OVER_HTTP_INBOUND);
        return map;
    }

    public static TransportType getTransportType(String transportClassName) {
        return transportClassToType.get(transportClassName);
    }

    public static String getTransportClassName(TransportType transportType) {
        for (Map.Entry<String, TransportType> entry : transportClassToType.entrySet()) {
            if (!entry.getValue().equals((Object)transportType)) continue;
            return entry.getKey();
        }
        return "";
    }
}

