/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.ui.controls.integration;

import java.beans.ConstructorProperties;
import java.math.BigInteger;
import java.util.List;
import java.util.UUID;
import org.qubership.atp.integration.configuration.configuration.AuditAction;
import org.qubership.automation.itf.core.model.communication.EnvironmentSample;
import org.qubership.automation.itf.core.model.communication.TriggerSample;
import org.qubership.automation.itf.ui.controls.integration.Result;
import org.qubership.automation.itf.ui.controls.service.integration.ItfStubsRequestsService;
import org.qubership.automation.itf.ui.messages.objects.integration.stubs.UIUpdateTriggerStatus;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class ItfStubsRequestsController {
    private final ItfStubsRequestsService itfStubsRequestsService;

    @GetMapping(value={"/trigger/all/active"})
    @AuditAction(auditAction="Get all Active Triggers")
    public List<TriggerSample> getAllActiveTriggers() {
        return this.itfStubsRequestsService.getAllActiveTriggers();
    }

    @Transactional(readOnly=true)
    @GetMapping(value={"/trigger/all"})
    @AuditAction(auditAction="Get all Triggers in the project {{#projectUuid}}")
    public List<TriggerSample> getAllTriggersByProject(@RequestParam(value="projectUuid") UUID projectUuid) {
        return this.itfStubsRequestsService.getAllTriggersByProject(projectUuid);
    }

    @Transactional(readOnly=true)
    @GetMapping(value={"/trigger/all/reactivate"})
    @AuditAction(auditAction="Get all Active/Error Triggers in the project {{#projectUuid}}")
    public List<TriggerSample> getAllActiveAndErrorTriggersByProject(@RequestParam(value="projectUuid") UUID projectUuid) {
        return this.itfStubsRequestsService.getAllActiveAndErrorTriggersByProject(projectUuid);
    }

    @Transactional(readOnly=true)
    @GetMapping(value={"/trigger/environment/folder/{id}"})
    @AuditAction(auditAction="Get all Triggers under Folder id {{#envFolderId}}")
    public List<EnvironmentSample> getTriggersByEnvFolder(@PathVariable(value="id") BigInteger envFolderId) {
        return this.itfStubsRequestsService.getTriggersByEnvFolder(envFolderId);
    }

    @Transactional(readOnly=true)
    @GetMapping(value={"/trigger/environmentId/{id}"})
    @AuditAction(auditAction="Get all Triggers under Environment id {{#environmentId}}")
    public EnvironmentSample getTriggersByEnvironment(@PathVariable(value="id") BigInteger environmentId) {
        return this.itfStubsRequestsService.getTriggersByEnvironment(environmentId);
    }

    @Transactional(readOnly=true)
    @GetMapping(value={"/trigger/{id}"})
    @AuditAction(auditAction="Get Trigger by id {{#id}}")
    public TriggerSample getTriggerById(@PathVariable(value="id") BigInteger id) {
        return this.itfStubsRequestsService.getTriggerById(id);
    }

    @Transactional
    @PatchMapping(value={"/trigger"})
    @AuditAction(auditAction="Update Trigger status by id {{#uiUpdateTriggerStatus.id}}")
    public Result updateTriggerStatus(@RequestBody UIUpdateTriggerStatus uiUpdateTriggerStatus) {
        return this.itfStubsRequestsService.updateTriggerStatus(uiUpdateTriggerStatus);
    }

    @ConstructorProperties(value={"itfStubsRequestsService"})
    public ItfStubsRequestsController(ItfStubsRequestsService itfStubsRequestsService) {
        this.itfStubsRequestsService = itfStubsRequestsService;
    }
}

