/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.ui.controls.service.integration;

import java.beans.ConstructorProperties;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.qubership.atp.multitenancy.core.context.TenantContext;
import org.qubership.automation.itf.core.hibernate.spring.managers.custom.SearchManager;
import org.qubership.automation.itf.core.hibernate.spring.managers.executor.TriggerConfigurationObjectManager;
import org.qubership.automation.itf.core.model.communication.EnvironmentSample;
import org.qubership.automation.itf.core.model.communication.TriggerSample;
import org.qubership.automation.itf.core.model.jpa.environment.Environment;
import org.qubership.automation.itf.core.model.jpa.environment.InboundTransportConfiguration;
import org.qubership.automation.itf.core.model.jpa.environment.TriggerConfiguration;
import org.qubership.automation.itf.core.model.jpa.folder.EnvFolder;
import org.qubership.automation.itf.core.model.jpa.project.StubProject;
import org.qubership.automation.itf.core.model.jpa.server.Server;
import org.qubership.automation.itf.core.model.jpa.system.System;
import org.qubership.automation.itf.core.model.transport.ConnectionProperties;
import org.qubership.automation.itf.core.util.constants.TriggerState;
import org.qubership.automation.itf.core.util.converter.IdConverter;
import org.qubership.automation.itf.core.util.converter.PropertiesConverter;
import org.qubership.automation.itf.core.util.db.TxExecutor;
import org.qubership.automation.itf.core.util.exception.TransportException;
import org.qubership.automation.itf.core.util.manager.CoreObjectManager;
import org.qubership.automation.itf.executor.service.ProjectSettingsService;
import org.qubership.automation.itf.ui.controls.integration.InboundTransportClassToTypeMapping;
import org.qubership.automation.itf.ui.controls.integration.Result;
import org.qubership.automation.itf.ui.controls.util.MultiTenantProjectCollector;
import org.qubership.automation.itf.ui.messages.objects.integration.stubs.UIUpdateTriggerStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ItfStubsRequestsService {
    private static final Logger log = LoggerFactory.getLogger(ItfStubsRequestsService.class);
    private final MultiTenantProjectCollector multiTenantProjectCollector;
    private final ProjectSettingsService projectSettingsService;
    @Value(value="${atp.multi-tenancy.enabled}")
    private Boolean multiTenancyEnabled;

    private static ConnectionProperties getTriggerConnectionProperties(TriggerConfiguration trigger) {
        ConnectionProperties triggerConnectionProperties = new ConnectionProperties(new HashMap());
        try {
            triggerConnectionProperties = PropertiesConverter.convert((String)trigger.getTypeName(), (Map[])new Map[]{trigger.getParent().getReferencedConfiguration().getConfiguration(), trigger.getParent().getConfiguration(), trigger.getConfiguration()});
        }
        catch (TransportException e) {
            log.error("Error while computing connection properties for trigger {}. Empty or partial connection properties are returned!", (Object)trigger.getName(), (Object)e);
        }
        return triggerConnectionProperties;
    }

    public TriggerSample createTriggerSample(TriggerConfiguration trigger) {
        return this.createTriggerSample(trigger, this.getProjectUuidForServer((Server)trigger.getParent().getParent()));
    }

    @Transactional(readOnly=true)
    public TriggerSample createTriggerSample(TriggerConfiguration trigger, UUID projectUuid) {
        TriggerSample triggerSample = new TriggerSample();
        triggerSample.setTriggerId((BigInteger)trigger.getID());
        triggerSample.setTriggerName(trigger.getName());
        triggerSample.setTriggerTypeName(trigger.getTypeName());
        triggerSample.setTriggerState(trigger.getState());
        triggerSample.setTransportName(trigger.getParent().getReferencedConfiguration().getName());
        triggerSample.setServerName(trigger.getParent().getParent().getName());
        triggerSample.setTriggerProperties(ItfStubsRequestsService.getTriggerConnectionProperties(trigger));
        triggerSample.setTransportType(InboundTransportClassToTypeMapping.getTransportType(trigger.getTypeName()));
        triggerSample.setProjectUuid(projectUuid);
        triggerSample.setProjectId(trigger.getParent().getParent().getProjectId());
        return triggerSample;
    }

    private UUID getProjectUuidForServer(Server server) {
        return ((StubProject)CoreObjectManager.getInstance().getManager(StubProject.class).getById((Object)server.getProjectId())).getUuid();
    }

    public List<TriggerSample> getAllActiveTriggers() {
        long startTime = java.lang.System.nanoTime();
        log.info("Getting transport triggers for activation...");
        Map<String, Collection<StubProject>> projects = this.multiTenantProjectCollector.collectProjects();
        HashMap<BigInteger, UUID> projectUuids = new HashMap<BigInteger, UUID>();
        Map<String, List<StubProject>> projectsWithEnabledProperty = this.getProjectsWithEnabledStartTriggersAtStartup(projects, projectUuids);
        List<TriggerSample> triggers = this.collectActiveTriggers(projectsWithEnabledProperty, projectUuids);
        long elapsedTime = java.lang.System.nanoTime() - startTime;
        log.info("Getting transport triggers for activation is completed, triggers count {}, elapsed time {} (s)", (Object)Objects.requireNonNull(triggers).size(), (Object)String.format("%.3f", (double)elapsedTime / 1.0E9));
        return triggers;
    }

    public List<TriggerSample> getAllTriggersByProject(UUID projectUuid) {
        Function<StubProject, ArrayList<TriggerSample>> function = proj -> (ArrayList)this.getAndCreateTriggerSimpleObjects((StubProject)proj);
        return this.getTriggersByProject(projectUuid, "all", function);
    }

    public List<TriggerSample> getAllActiveAndErrorTriggersByProject(UUID projectUuid) {
        Function<StubProject, ArrayList<TriggerSample>> function = proj -> (ArrayList)this.getActiveAndErrorAndCreateTriggerSimpleObjects((StubProject)proj);
        return this.getTriggersByProject(projectUuid, "active/error", function);
    }

    public List<TriggerSample> getTriggersByProject(UUID projectUuid, String actionName, Function<StubProject, ArrayList<TriggerSample>> function) {
        long startTime = java.lang.System.nanoTime();
        log.info("Getting {} triggers of {} project...", (Object)actionName, (Object)projectUuid);
        StubProject project = (StubProject)((SearchManager)CoreObjectManager.getInstance().getSpecialManager(StubProject.class, SearchManager.class)).getByUuid(projectUuid);
        List<TriggerSample> triggers = this.collectTriggersByProject(Objects.requireNonNull(project), function);
        long elapsedTime = java.lang.System.nanoTime() - startTime;
        log.info("Getting {} triggers of {} project is completed: triggers count {}, elapsed time {} (s)", new Object[]{actionName, projectUuid, Objects.requireNonNull(triggers).size(), String.format("%.3f", (double)elapsedTime / 1.0E9)});
        return triggers;
    }

    public List<EnvironmentSample> getTriggersByEnvFolder(BigInteger envFolderId) {
        EnvFolder envFolder = (EnvFolder)CoreObjectManager.getInstance().getManager(EnvFolder.class).getById((Object)envFolderId);
        if (Objects.isNull(envFolder)) {
            log.debug("There is no environment folder with id={}. Null will be returned.", (Object)envFolderId);
            return Collections.emptyList();
        }
        Collection environments = CoreObjectManager.getInstance().getManager(Environment.class).getAllByParentId((Object)envFolderId);
        ArrayList<EnvironmentSample> environmentSamples = new ArrayList<EnvironmentSample>();
        UUID projectUuid = envFolder.getProject().getUuid();
        environments.forEach(environment -> environmentSamples.add(this.getEnvironmentSampleObject((Environment)environment, projectUuid)));
        return environmentSamples;
    }

    public EnvironmentSample getTriggersByEnvironment(BigInteger environmentId) {
        Environment environment = (Environment)CoreObjectManager.getInstance().getManager(Environment.class).getById((Object)environmentId);
        if (environment == null) {
            log.debug("There is no environment with id={}. Null is returned.", (Object)environmentId);
            return null;
        }
        UUID projectUuid = ((StubProject)CoreObjectManager.getInstance().getManager(StubProject.class).getById((Object)environment.getProjectId())).getUuid();
        return this.getEnvironmentSampleObject(environment, projectUuid);
    }

    public TriggerSample getTriggerById(BigInteger id) {
        TriggerConfiguration trigger = (TriggerConfiguration)CoreObjectManager.getInstance().getManager(TriggerConfiguration.class).getById((Object)id);
        return trigger == null ? null : this.createTriggerSample(trigger);
    }

    public Result updateTriggerStatus(UIUpdateTriggerStatus uiUpdateTriggerStatus) {
        BigInteger triggerId = uiUpdateTriggerStatus.getId();
        TriggerConfiguration triggerConfiguration = (TriggerConfiguration)CoreObjectManager.getInstance().getManager(TriggerConfiguration.class).getById((Object)triggerId);
        if (triggerConfiguration == null) {
            String errorMsg = String.format("Trigger [id=%s] doesn't exist.", triggerId);
            log.debug(errorMsg);
            return new Result(false, errorMsg);
        }
        TriggerState triggerState = TriggerState.fromString((String)uiUpdateTriggerStatus.getStatus());
        if (triggerState != null) {
            triggerConfiguration.setActivationErrorMessage(uiUpdateTriggerStatus.getDescription());
            triggerConfiguration.setState(triggerState);
            triggerConfiguration.store();
            String statusChangeMessage = String.format("Status of trigger [id=%s] is changed to %s.", triggerId, triggerState);
            log.debug(statusChangeMessage);
            return new Result(!TriggerState.ERROR.equals((Object)triggerState), statusChangeMessage);
        }
        String errorMsg = String.format("Status can't be found by value=%s. Trigger [id=%s] is not updated", uiUpdateTriggerStatus.getStatus(), triggerId);
        log.debug(errorMsg);
        return new Result(false, errorMsg);
    }

    private List<TriggerSample> collectTriggersByProject(StubProject project, Function<StubProject, ArrayList<TriggerSample>> function) {
        ArrayList<TriggerSample> triggers = new ArrayList<TriggerSample>();
        if (this.multiTenancyEnabled.booleanValue()) {
            TenantContext.setTenantInfo((String)project.getUuid().toString());
            triggers.addAll((Collection<TriggerSample>)function.apply(project));
            TenantContext.setDefaultTenantInfo();
        } else {
            triggers.addAll((Collection)function.apply(project));
        }
        return triggers;
    }

    private List<TriggerSample> collectActiveTriggers(Map<String, List<StubProject>> projects, Map<BigInteger, UUID> projectUuids) {
        ArrayList<TriggerSample> activeTriggers = new ArrayList<TriggerSample>();
        if (this.multiTenancyEnabled.booleanValue()) {
            log.info("getAllActiveTriggers: additional cluster(s) are processed...");
            this.collectActiveTriggers(projects.get("additional"), activeTriggers, projectUuids, false);
            TenantContext.setDefaultTenantInfo();
        }
        log.info("getAllActiveTriggers: default cluster is processed...");
        this.collectActiveTriggers(projects.get("default"), activeTriggers, projectUuids, true);
        return activeTriggers;
    }

    private void collectActiveTriggers(List<StubProject> projects, List<TriggerSample> to, Map<BigInteger, UUID> projectUuids, boolean isDefault) {
        projects.forEach(project -> {
            log.info("getAllActiveTriggers, project {} is processed...", (Object)project.getUuid());
            if (this.multiTenancyEnabled.booleanValue() && !isDefault) {
                TenantContext.setTenantInfo((String)((UUID)projectUuids.get((BigInteger)project.getID())).toString());
            }
            to.addAll(this.getActiveAndCreateTriggerSamples((BigInteger)project.getID(), project.getUuid()));
            log.info("getAllActiveTriggers, project {} is added: triggers total {}", (Object)project.getUuid(), (Object)to.size());
        });
    }

    protected List<TriggerSample> getActiveAndCreateTriggerSamples(BigInteger projectId, UUID projectUuid) {
        try {
            return (List)TxExecutor.execute(() -> {
                Collection triggers = ((TriggerConfigurationObjectManager)CoreObjectManager.getInstance().getSpecialManager(TriggerConfiguration.class, TriggerConfigurationObjectManager.class)).getAllActiveTriggersByProjectId(projectId);
                return triggers.stream().map(trigger -> {
                    try {
                        return this.createTriggerSample((TriggerConfiguration)trigger, projectUuid);
                    }
                    catch (Exception ex) {
                        log.warn("getAllActiveTriggers: trigger {} processing is failed", trigger.getID(), (Object)ex);
                        return null;
                    }
                }).collect(Collectors.toList());
            }, (TransactionDefinition)TxExecutor.readOnlyTransaction());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected List<TriggerSample> getAndCreateTriggerSimpleObjects(StubProject project) {
        try {
            return (List)TxExecutor.execute(() -> {
                BigInteger projectId = (BigInteger)project.getID();
                Collection triggers = ((TriggerConfigurationObjectManager)CoreObjectManager.getInstance().getSpecialManager(TriggerConfiguration.class, TriggerConfigurationObjectManager.class)).getAllTriggersByProjectId(projectId);
                return triggers.parallelStream().map(trigger -> {
                    try {
                        return this.createTriggerSample((TriggerConfiguration)trigger, project.getUuid());
                    }
                    catch (Exception ex) {
                        throw new RuntimeException(String.format("Error while getting all triggers for activation: trigger %s", trigger.getID()), ex);
                    }
                }).collect(Collectors.toList());
            }, (TransactionDefinition)TxExecutor.readOnlyTransaction());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected List<TriggerSample> getActiveAndErrorAndCreateTriggerSimpleObjects(StubProject project) {
        try {
            return (List)TxExecutor.execute(() -> {
                BigInteger projectId = (BigInteger)project.getID();
                Collection triggers = ((TriggerConfigurationObjectManager)CoreObjectManager.getInstance().getSpecialManager(TriggerConfiguration.class, TriggerConfigurationObjectManager.class)).getAllActiveAndErrorTriggersByProjectId(projectId);
                return triggers.parallelStream().map(trigger -> {
                    try {
                        return this.createTriggerSample((TriggerConfiguration)trigger, project.getUuid());
                    }
                    catch (Exception ex) {
                        throw new RuntimeException(String.format("Error while getting all active and error triggers: trigger %s", trigger.getID()), ex);
                    }
                }).collect(Collectors.toList());
            }, (TransactionDefinition)TxExecutor.readOnlyTransaction());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected EnvironmentSample getEnvironmentSampleObject(Environment environment, UUID projectUuid) {
        EnvironmentSample environmentSample = new EnvironmentSample();
        environmentSample.setEnvId((BigInteger)environment.getID());
        environmentSample.setTurnedOn(environment.getEnvironmentState().isOn());
        environmentSample.setTriggerSamples(new ArrayList());
        for (Map.Entry entry : environment.getInbound().entrySet()) {
            if (entry.getValue() == null) continue;
            for (InboundTransportConfiguration configuration : ((Server)entry.getValue()).getInbounds((System)entry.getKey())) {
                if (configuration.getTriggerConfigurations().isEmpty()) continue;
                for (TriggerConfiguration triggerConfiguration : configuration.getTriggerConfigurations()) {
                    environmentSample.getTriggerSamples().add(this.createTriggerSample(triggerConfiguration, projectUuid));
                }
            }
        }
        return environmentSample;
    }

    private Map<String, List<StubProject>> getProjectsWithEnabledStartTriggersAtStartup(Map<String, Collection<StubProject>> projects, Map<BigInteger, UUID> projectUuids) {
        HashMap<String, List<StubProject>> activeProjects = new HashMap<String, List<StubProject>>();
        log.info("getAllActiveTriggers: Collect projects to activate triggers...");
        if (this.multiTenancyEnabled.booleanValue()) {
            this.collectProjectsInfoIfNeedToActivateTriggers(projects.get("additional"), activeProjects, "additional", false, projectUuids);
            log.info("getAllActiveTriggers, additional clusters processing: projects count {}", (Object)((List)activeProjects.get("additional")).size());
            TenantContext.setDefaultTenantInfo();
        }
        this.collectProjectsInfoIfNeedToActivateTriggers(projects.get("default"), activeProjects, "default", true, projectUuids);
        log.info("getAllActiveTriggers, default cluster processing: projects count {}", (Object)((List)activeProjects.get("default")).size());
        return activeProjects;
    }

    private void collectProjectsInfoIfNeedToActivateTriggers(Collection<StubProject> projects, Map<String, List<StubProject>> to, String key, boolean isDefault, Map<BigInteger, UUID> projectUuids) {
        to.put(key, this.collectProjectsInfoIfNeedToActivateTriggers(projects, isDefault, projectUuids));
    }

    private List<StubProject> collectProjectsInfoIfNeedToActivateTriggers(Collection<StubProject> projects, boolean isDefaultCluster, Map<BigInteger, UUID> projectUuids) {
        ArrayList<StubProject> enabled = new ArrayList<StubProject>();
        for (StubProject project : projects) {
            if (!isDefaultCluster) {
                TenantContext.setTenantInfo((String)project.getUuid().toString());
            }
            if (!this.isNeedToActivateTriggersAtStartUp(project)) continue;
            enabled.add(project);
            projectUuids.put((BigInteger)project.getID(), project.getUuid());
        }
        log.info("Projects count with start.transport.triggers.at.startup = true for {} cluster: {}", (Object)(isDefaultCluster ? "default" : "additional"), (Object)enabled.size());
        return enabled;
    }

    private boolean isNeedToActivateTriggersAtStartUp(StubProject project) {
        return this.projectSettingsService.getBoolean((Object)IdConverter.toBigInt((Object)project.getID()), "start.transport.triggers.at.startup");
    }

    @ConstructorProperties(value={"multiTenantProjectCollector", "projectSettingsService"})
    public ItfStubsRequestsService(MultiTenantProjectCollector multiTenantProjectCollector, ProjectSettingsService projectSettingsService) {
        this.multiTenantProjectCollector = multiTenantProjectCollector;
        this.projectSettingsService = projectSettingsService;
    }
}

