/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.ui.controls.util;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.IllegalClassException;
import org.aspectj.apache.bcel.classfile.ClassFormatException;
import org.qubership.automation.itf.core.model.common.Storable;
import org.qubership.automation.itf.core.model.jpa.callchain.CallChain;
import org.qubership.automation.itf.core.model.jpa.folder.ChainFolder;
import org.qubership.automation.itf.core.model.jpa.folder.SystemFolder;
import org.qubership.automation.itf.core.model.jpa.message.template.Template;
import org.qubership.automation.itf.core.model.jpa.step.EmbeddedStep;
import org.qubership.automation.itf.core.model.jpa.step.IntegrationStep;
import org.qubership.automation.itf.core.model.jpa.step.SituationStep;
import org.qubership.automation.itf.core.model.jpa.step.Step;
import org.qubership.automation.itf.core.model.jpa.system.System;
import org.qubership.automation.itf.core.model.jpa.system.operation.Operation;
import org.qubership.automation.itf.core.model.jpa.system.stub.Situation;

public class Collector {
    public static Set<System> collectSystemsFromSituationSteps(Collection<SituationStep> steps) {
        HashSet<System> collectedSystems = new HashSet<System>();
        for (Step step : steps.stream().filter(Objects::nonNull).collect(Collectors.toSet())) {
            if (step instanceof SituationStep) {
                SituationStep situationStep = (SituationStep)step;
                if (situationStep.getSituation() != null) {
                    collectedSystems.add(situationStep.getSituation().getParent().getParent());
                }
                situationStep.getEndSituations().stream().filter(Objects::nonNull).forEach(endS -> collectedSystems.add(endS.getParent().getParent()));
                situationStep.getExceptionalSituations().stream().filter(Objects::nonNull).forEach(exS -> collectedSystems.add(exS.getParent().getParent()));
                continue;
            }
            if (step instanceof EmbeddedStep) continue;
            throw new ClassFormatException("Unexpected step type: " + step.getClass().getName());
        }
        return collectedSystems;
    }

    public static Set<SituationStep> collectSituationStepsFromStorables(Collection<? extends Storable> storables, Class<? extends Storable> clazz) throws ClassNotFoundException {
        Set<Object> steps;
        if (ChainFolder.class.equals(clazz)) {
            steps = Collector.collectSituationStepsFromCallChains(Collector.collectCallChainsFromFolders((Set)storables));
        } else if (CallChain.class.equals(clazz)) {
            steps = Collector.collectSituationStepsFromCallChains((Set)storables);
        } else if (Step.class.isAssignableFrom(clazz)) {
            steps = storables.stream().filter(step -> SituationStep.class.isAssignableFrom(step.getClass())).collect(Collectors.toSet());
        } else {
            throw new ClassNotFoundException("Class " + clazz.getName() + " isn't supported by reference regenerator.");
        }
        return steps;
    }

    public static Set<System> collectSystemsFromSystems(Collection<System> systems) {
        HashSet<System> collectedSystems = new HashSet<System>();
        for (System system : systems) {
            for (Operation operation : system.getOperations()) {
                collectedSystems.addAll(Collector.collectSystemsFromSituations(operation.getSituations()));
            }
        }
        return collectedSystems;
    }

    public static Set<System> collectSystemsFromSituations(Collection<Situation> situations) {
        HashSet<System> collectedSystems = new HashSet<System>();
        for (Situation situation : situations) {
            IntegrationStep step = situation.getIntegrationStep();
            if (step == null) continue;
            if (step.getReceiver() != null) {
                collectedSystems.add(step.getReceiver());
            }
            if (step.getSender() == null) continue;
            collectedSystems.add(step.getSender());
        }
        return collectedSystems;
    }

    public static Set<? extends Step> collectSituationStepsFromCallChains(Collection<CallChain> callChains) {
        return callChains.stream().flatMap(storable -> storable.getSteps().stream()).filter(step -> step != null && SituationStep.class.isAssignableFrom(step.getClass())).collect(Collectors.toSet());
    }

    public static Set<CallChain> collectCallChainsFromCallChainsAndFolders(Collection<Storable> storables) {
        HashSet<CallChain> callChains = new HashSet<CallChain>();
        HashSet<ChainFolder> callChainFolders = new HashSet<ChainFolder>();
        for (Storable storable : storables) {
            if (storable instanceof CallChain) {
                callChains.add((CallChain)storable);
                continue;
            }
            if (storable instanceof ChainFolder) {
                callChainFolders.add((ChainFolder)storable);
                continue;
            }
            throw new IllegalClassException("Unexpected class: " + storable);
        }
        callChains.addAll(Collector.collectCallChainsFromFolders(callChainFolders));
        return callChains;
    }

    public static Set<CallChain> collectCallChainsFromFolders(Set<ChainFolder> chainFolders) {
        Set<CallChain> collectedCallChains = chainFolders.stream().flatMap(chainFolder -> chainFolder.getObjects().stream()).collect(Collectors.toSet());
        if (chainFolders.size() > 0) {
            collectedCallChains.addAll(Collector.collectCallChainsFromFolders(chainFolders.stream().flatMap(chainFolder -> chainFolder.getSubFolders().stream()).collect(Collectors.toSet())));
        }
        return collectedCallChains;
    }

    public static Set<System> collectSystemsFromSystemsAndFolders(Collection<Storable> storables) {
        HashSet<System> systems = new HashSet<System>();
        HashSet<SystemFolder> systemFolders = new HashSet<SystemFolder>();
        for (Storable storable : storables) {
            if (storable instanceof System) {
                systems.add((System)storable);
                continue;
            }
            if (storable instanceof SystemFolder) {
                systemFolders.add((SystemFolder)storable);
                continue;
            }
            throw new IllegalClassException("Unexpected class: " + storable);
        }
        systems.addAll(Collector.collectSystemsFromFolders(systemFolders));
        return systems;
    }

    public static Set<System> collectSystemsFromFolders(Set<SystemFolder> systemFolders) {
        Set<System> collectedSystems = systemFolders.stream().flatMap(systemFolder -> systemFolder.getObjects().stream()).collect(Collectors.toSet());
        if (systemFolders.size() > 0) {
            collectedSystems.addAll(Collector.collectSystemsFromFolders(systemFolders.stream().flatMap(systemFolder -> systemFolder.getSubFolders().stream()).collect(Collectors.toSet())));
        }
        return collectedSystems;
    }

    public static Map<String, Template> collectTemplatesFromSystems(Collection<System> systems) {
        HashMap<String, Template> replacements = new HashMap<String, Template>();
        for (System system : systems) {
            for (Template t : system.returnTemplates()) {
                if (t.getNaturalId() == null) continue;
                replacements.put(t.getNaturalId().toString(), t);
            }
            for (Operation o : system.getOperations()) {
                for (Template t : o.returnTemplates()) {
                    if (t.getNaturalId() == null) continue;
                    replacements.put(t.getNaturalId().toString(), t);
                }
            }
        }
        return replacements;
    }

    public static Map<String, Operation> collectOperationsFromSystem(System system) {
        HashMap<String, Operation> replacements = new HashMap<String, Operation>();
        for (Operation o : system.getOperations()) {
            if (o.getNaturalId() == null) continue;
            replacements.put(o.getNaturalId().toString(), o);
        }
        return replacements;
    }

    public static HashMap<String, HashMap<String, Situation>> collectSituationsFromSystemsMap(HashMap<System, System> systems) {
        HashMap<String, HashMap<String, Situation>> replacements = new HashMap<String, HashMap<String, Situation>>();
        for (System targetSystem : systems.keySet()) {
            HashMap<String, Situation> systemReplacements = new HashMap<String, Situation>();
            System replacementSystem = systems.get(targetSystem);
            if (replacementSystem.getNaturalId() == null) continue;
            for (Operation operation : replacementSystem.getOperations()) {
                for (Situation situation : operation.getSituations()) {
                    if (situation.getNaturalId() == null) continue;
                    systemReplacements.put(situation.getNaturalId().toString(), situation);
                }
            }
            replacements.put(targetSystem.getID().toString(), systemReplacements);
        }
        return replacements;
    }
}

