/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.ui.controls.util;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.qubership.atp.multitenancy.core.context.TenantContext;
import org.qubership.automation.itf.core.hibernate.spring.managers.executor.StubProjectObjectManager;
import org.qubership.automation.itf.core.model.jpa.project.StubProject;
import org.qubership.automation.itf.core.util.manager.CoreObjectManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class MultiTenantProjectCollector {
    private static final Logger log = LoggerFactory.getLogger(MultiTenantProjectCollector.class);
    public static final String DEFAULT_CLUSTER = "default";
    public static final String ADDITIONAL_CLUSTERS = "additional";
    @Value(value="${atp.multi-tenancy.enabled}")
    private Boolean multiTenancyEnabled;

    public Map<String, Collection<StubProject>> collectProjects() {
        HashMap<String, Collection<StubProject>> allProjects = new HashMap<String, Collection<StubProject>>();
        ArrayList<StubProject> additionalClustersProjects = new ArrayList<StubProject>();
        if (this.multiTenancyEnabled.booleanValue()) {
            StubProjectObjectManager manager = (StubProjectObjectManager)CoreObjectManager.getInstance().getSpecialManager(StubProject.class, StubProjectObjectManager.class);
            for (String tenantId : TenantContext.getTenantIds((boolean)false)) {
                if (StringUtils.isEmpty((CharSequence)tenantId)) {
                    log.warn("TenantId is null or empty, skipped.");
                    continue;
                }
                TenantContext.setTenantInfo((String)tenantId);
                try {
                    UUID projectUuid = UUID.fromString(tenantId);
                    BigInteger projectId = this.getInternalProjectIdByUuid(manager, projectUuid);
                    if (projectId != null) {
                        StubProject project = this.getProject(manager, projectId);
                        if (project != null) {
                            additionalClustersProjects.add(project);
                            continue;
                        }
                        log.warn("Can't find the project by id = {}", (Object)projectId);
                        continue;
                    }
                    log.warn("Can't find the project internal id by UUID = {}", (Object)tenantId);
                }
                catch (IllegalArgumentException ex) {
                    log.error("Illegal value of tenantId: {}", (Object)tenantId, (Object)ex);
                }
                catch (Exception ex) {
                    log.error("Exception while processing of tenantId: {}", (Object)tenantId, (Object)ex);
                }
            }
            if (additionalClustersProjects.isEmpty()) {
                log.warn("Please note: no projects in additional cluster(s) are found!");
            }
            TenantContext.setDefaultTenantInfo();
        }
        allProjects.put(DEFAULT_CLUSTER, this.getProjectsFromDefault(additionalClustersProjects));
        allProjects.put(ADDITIONAL_CLUSTERS, additionalClustersProjects);
        return allProjects;
    }

    @Transactional(readOnly=true)
    StubProject getProject(StubProjectObjectManager manager, BigInteger projectId) {
        return (StubProject)manager.getById((Object)projectId);
    }

    @Transactional(readOnly=true)
    BigInteger getInternalProjectIdByUuid(StubProjectObjectManager manager, String tenantId) {
        return manager.getEntityInternalIdByUuid(UUID.fromString(tenantId));
    }

    @Transactional(readOnly=true)
    BigInteger getInternalProjectIdByUuid(StubProjectObjectManager manager, UUID tenantId) {
        return manager.getEntityInternalIdByUuid(tenantId);
    }

    private Collection<StubProject> getProjectsFromDefault(Collection<StubProject> additionalClustersProjects) {
        Collection<StubProject> projectsFromDefaultCluster = this.getProjectsFromDefault();
        projectsFromDefaultCluster.removeAll(additionalClustersProjects);
        return projectsFromDefaultCluster;
    }

    @Transactional(readOnly=true)
    Collection<StubProject> getProjectsFromDefault() {
        return CoreObjectManager.getInstance().getManager(StubProject.class).getAll();
    }
}

