/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.ui.messages.objects;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.qubership.automation.itf.core.model.common.Storable;
import org.qubership.automation.itf.core.model.jpa.message.parser.ParsingRule;
import org.qubership.automation.itf.core.model.jpa.message.parser.SystemParsingRule;
import org.qubership.automation.itf.core.model.jpa.message.template.SystemTemplate;
import org.qubership.automation.itf.core.model.jpa.message.template.Template;
import org.qubership.automation.itf.core.model.jpa.system.System;
import org.qubership.automation.itf.core.model.jpa.system.operation.Operation;
import org.qubership.automation.itf.core.model.jpa.transport.TransportConfiguration;
import org.qubership.automation.itf.core.util.constants.SystemMode;
import org.qubership.automation.itf.core.util.provider.ParsingRuleProvider;
import org.qubership.automation.itf.ui.messages.objects.UIECIObject;
import org.qubership.automation.itf.ui.messages.objects.UIOperation;
import org.qubership.automation.itf.ui.messages.objects.UIParsingRule;
import org.qubership.automation.itf.ui.messages.objects.template.UITemplate;
import org.qubership.automation.itf.ui.messages.objects.transport.UITransport;
import org.qubership.automation.itf.ui.messages.objects.wrap.UIWrapper;
import org.qubership.automation.itf.ui.util.UIHelper;

public class UISystem
extends UIECIObject {
    private UIWrapper<Set<UITransport>> transports;
    private UIWrapper<Set<UIOperation>> operations;
    private UIWrapper<Set<UIParsingRule>> parsingRules;
    private UIWrapper<Set<UITemplate>> templates;
    private UIWrapper<String> incoming;
    private UIWrapper<String> outgoing;
    private UIWrapper<String> operationDefinition;
    private String mode;

    public UISystem() {
    }

    public UISystem(String id, String name) {
        this.setId(id);
        this.setName(name);
    }

    public UISystem(Storable system) {
        this((System)system);
    }

    public UISystem(System systemObject) {
        super((Storable)systemObject);
        this.defineTransports(systemObject.getTransports());
        this.defineOperations(systemObject.getOperations());
        this.defineParsingRules(systemObject.returnParsingRules());
        this.defineTemplates(systemObject.returnTemplates());
        this.setMode(Objects.toString(systemObject.getMode(), SystemMode.STUB.toString()));
        this.setIncoming(new UIWrapper<String>(this.getKeyDefinitionValue(systemObject.getIncomingContextKeyDefinition())));
        this.setOutgoing(new UIWrapper<String>(this.getKeyDefinitionValue(systemObject.getOutgoingContextKeyDefinition())));
        this.setOperationDefinition(new UIWrapper<String>(this.getKeyDefinitionValue(systemObject.getOperationKeyDefinition())));
    }

    @Override
    public void loadChildrenByClass(Class childClass, List<Storable> children) {
        if (childClass.isAssignableFrom(TransportConfiguration.class)) {
            HashSet uiTransports = Sets.newHashSet();
            for (Storable child : children) {
                uiTransports.add(new UITransport((TransportConfiguration)child));
            }
            this.setTransports(new UIWrapper<Set<UITransport>>(uiTransports));
        }
        if (childClass.isAssignableFrom(SystemParsingRule.class)) {
            HashSet uiParsingRules = Sets.newHashSet();
            for (Storable child : children) {
                uiParsingRules.add(new UIParsingRule((ParsingRule<? extends ParsingRuleProvider>)((ParsingRule)child)));
            }
            this.setParsingRules(new UIWrapper<Set<UIParsingRule>>(uiParsingRules));
        }
        if (childClass.isAssignableFrom(SystemTemplate.class)) {
            HashSet uiTemplates = Sets.newHashSet();
            for (Storable child : children) {
                uiTemplates.add(new UITemplate((Template)child));
            }
            this.setTemplates(new UIWrapper<Set<UITemplate>>(uiTemplates));
        }
        if (childClass.isAssignableFrom(Operation.class)) {
            HashSet uiOperations = Sets.newHashSet();
            for (Storable child : children) {
                uiOperations.add(new UIOperation((Operation)child));
            }
            this.setOperations(new UIWrapper<Set<UIOperation>>(uiOperations));
        }
    }

    private String getKeyDefinitionValue(String keyDefinition) {
        return UIHelper.getDefinitionValue(keyDefinition);
    }

    public UIWrapper<Set<UITransport>> getTransports() {
        return this.transports;
    }

    public void setTransports(UIWrapper<Set<UITransport>> transports) {
        this.transports = transports;
    }

    public void defineTransports(Set<TransportConfiguration> transports) {
        if (this.transports == null) {
            this.transports = new UIWrapper();
            this.transports.setData(Sets.newHashSetWithExpectedSize((int)transports.size()));
        }
        if (transports != null) {
            for (TransportConfiguration entry : transports) {
                this.transports.getData().add(new UITransport(entry));
            }
        }
    }

    public UIWrapper<Set<UIOperation>> getOperations() {
        return this.operations;
    }

    public void setOperations(UIWrapper<Set<UIOperation>> operations) {
        this.operations = operations;
    }

    public void defineOperations(Set<Operation> operations) {
        if (this.operations == null) {
            this.operations = new UIWrapper();
            this.operations.setData(Sets.newHashSetWithExpectedSize((int)operations.size()));
        }
        if (operations != null) {
            for (Operation entry : operations) {
                this.operations.getData().add(new UIOperation(entry));
            }
        }
    }

    public UIWrapper<Set<UIParsingRule>> getParsingRules() {
        return this.parsingRules;
    }

    public void setParsingRules(UIWrapper<Set<UIParsingRule>> parsingRules) {
        this.parsingRules = parsingRules;
    }

    public void defineParsingRules(Set<ParsingRule> parsingRules) {
        if (this.parsingRules == null) {
            this.parsingRules = new UIWrapper();
            this.parsingRules.setData(Sets.newHashSetWithExpectedSize((int)parsingRules.size()));
        }
        if (parsingRules != null) {
            for (ParsingRule entry : parsingRules) {
                this.parsingRules.getData().add(new UIParsingRule((ParsingRule<? extends ParsingRuleProvider>)entry));
            }
        }
    }

    public UIWrapper<Set<UITemplate>> getTemplates() {
        return this.templates;
    }

    public void setTemplates(UIWrapper<Set<UITemplate>> templates) {
        this.templates = templates;
    }

    public void defineTemplates(Set<Template> templates) {
        if (this.templates == null) {
            this.templates = new UIWrapper();
            this.templates.setData(Sets.newHashSetWithExpectedSize((int)templates.size()));
        }
        if (templates != null) {
            for (Template entry : templates) {
                this.templates.getData().add(new UITemplate(entry));
            }
        }
    }

    public UIWrapper<String> getIncoming() {
        return this.incoming;
    }

    public void setIncoming(UIWrapper<String> incoming) {
        this.incoming = incoming;
    }

    public UIWrapper<String> getOutgoing() {
        return this.outgoing;
    }

    public void setOutgoing(UIWrapper<String> outgoing) {
        this.outgoing = outgoing;
    }

    public UIWrapper<String> getOperationDefinition() {
        return this.operationDefinition;
    }

    public void setOperationDefinition(UIWrapper<String> operationDefinition) {
        this.operationDefinition = operationDefinition;
    }

    public String getMode() {
        return this.mode;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }
}

