/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.ui.messages.objects.callchain;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.qubership.automation.itf.core.model.common.Storable;
import org.qubership.automation.itf.core.model.dataset.DataSetList;
import org.qubership.automation.itf.core.model.jpa.callchain.CallChain;
import org.qubership.automation.itf.core.model.jpa.step.EmbeddedStep;
import org.qubership.automation.itf.core.model.jpa.step.SituationStep;
import org.qubership.automation.itf.core.model.jpa.step.Step;
import org.qubership.automation.itf.ui.messages.objects.UIDataSetList;
import org.qubership.automation.itf.ui.messages.objects.UIKey;
import org.qubership.automation.itf.ui.messages.objects.UIObject;
import org.qubership.automation.itf.ui.messages.objects.callchain.step.UIAbstractCallChainStep;
import org.qubership.automation.itf.ui.messages.objects.callchain.step.UIEmbeddedChainStep;
import org.qubership.automation.itf.ui.messages.objects.callchain.step.UISituationStep;
import org.qubership.automation.itf.ui.messages.objects.wrap.UIWrapper;
import org.qubership.automation.itf.ui.util.UIHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UICallChain
extends UIObject {
    private static final Logger LOGGER = LoggerFactory.getLogger(UICallChain.class);
    private UIWrapper<List<UIAbstractCallChainStep>> steps;
    private UIWrapper<List<UIKey>> keys;
    private UIWrapper<List<UIDataSetList>> dataSetLists;

    public UICallChain() {
    }

    public UICallChain(Storable callchain) {
        this((CallChain)callchain);
    }

    public UICallChain(CallChain chain) {
        super((Storable)chain);
    }

    public UICallChain(CallChain chain, boolean isFull) {
        super((Storable)chain, isFull);
        try {
            ArrayList dataSetLists = Lists.newArrayList();
            for (Object child : chain.getCompatibleDataSetLists((Object)chain.getProjectId())) {
                dataSetLists.add(new UIDataSetList((DataSetList)child));
            }
            this.setDataSetLists(new UIWrapper<List<UIDataSetList>>(dataSetLists));
        }
        catch (Exception e) {
            LOGGER.warn("Exception occurred during getting compatible dataset lists: ", (Throwable)e);
        }
        ArrayList keys = Lists.newArrayList();
        for (Object child : chain.getKeys()) {
            keys.add(new UIKey((String)child));
        }
        this.setKeys(new UIWrapper<List<UIKey>>(keys));
        UIWrapper<List<UIAbstractCallChainStep>> wrapper = new UIWrapper<List<UIAbstractCallChainStep>>();
        wrapper.setData(Lists.newArrayList());
        for (Step step : chain.getSteps()) {
            if (step instanceof SituationStep) {
                SituationStep situationStep = (SituationStep)step;
                wrapper.getData().add(new UISituationStep(situationStep, isFull));
                continue;
            }
            if (!(step instanceof EmbeddedStep)) continue;
            EmbeddedStep embeddedStep = (EmbeddedStep)step;
            wrapper.getData().add(new UIEmbeddedChainStep(embeddedStep, isFull));
        }
        this.setSteps(wrapper);
    }

    public UIWrapper<List<UIAbstractCallChainStep>> getSteps() {
        return this.steps;
    }

    public void setSteps(UIWrapper<List<UIAbstractCallChainStep>> steps) {
        this.steps = steps;
    }

    public UIWrapper<List<UIKey>> getKeys() {
        return this.keys;
    }

    public void setKeys(UIWrapper<List<UIKey>> keys) {
        this.keys = keys;
    }

    public UIWrapper<List<UIDataSetList>> getDataSetLists() {
        return this.dataSetLists;
    }

    public void setDataSetLists(UIWrapper<List<UIDataSetList>> dataSetLists) {
        this.dataSetLists = dataSetLists;
    }

    @Override
    public void loadChildrenByClass(Class childClass, List<Storable> children) {
        if (Step.class.isAssignableFrom(childClass)) {
            ArrayList uiSteps = Lists.newArrayList();
            for (Storable child : children) {
                uiSteps.add((UIAbstractCallChainStep)UIHelper.getUIPresentationByStorable(child, null, Lists.newArrayList()));
            }
            this.setSteps(new UIWrapper<List<UIAbstractCallChainStep>>(uiSteps));
        }
    }
}

