/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.ui.messages.objects.callchain.step;

import org.qubership.automation.itf.core.model.common.Storable;
import org.qubership.automation.itf.core.model.jpa.callchain.CallChain;
import org.qubership.automation.itf.core.model.jpa.step.AbstractCallChainStep;
import org.qubership.automation.itf.core.model.jpa.step.EmbeddedStep;
import org.qubership.automation.itf.core.util.manager.CoreObjectManager;
import org.qubership.automation.itf.ui.controls.util.ControllerHelper;
import org.qubership.automation.itf.ui.messages.objects.UIObject;
import org.qubership.automation.itf.ui.messages.objects.callchain.step.UIAbstractCallChainStep;

public class UIEmbeddedChainStep
extends UIAbstractCallChainStep {
    private UIObject embeddedChain;

    public UIEmbeddedChainStep() {
        this.setType("embeddedChainStep");
    }

    public UIEmbeddedChainStep(EmbeddedStep step) {
        super((AbstractCallChainStep)step, true);
        this.fillUiEmbeddedChainStep(step, true);
    }

    public UIEmbeddedChainStep(EmbeddedStep step, boolean isFullWithParent) {
        super((AbstractCallChainStep)step, isFullWithParent);
        this.fillUiEmbeddedChainStep(step, isFullWithParent);
    }

    private void fillUiEmbeddedChainStep(EmbeddedStep step, boolean isFullWithParent) {
        this.setType("embeddedChainStep");
        if (step.getChain() != null) {
            this.setEmbeddedChain(new UIObject((Storable)step.getChain(), isFullWithParent));
        }
        this.fillConditionsFromStep((AbstractCallChainStep)step);
        this.setConditionRetry(step.isConditionRetry());
        this.setConditionMaxAttempts(step.getConditionMaxAttempts());
        this.setConditionMaxTime(step.getConditionMaxTime());
        this.setConditionUnitMaxTime(step.getConditionUnitMaxTime());
        this.setPreScript(step.getPreScript());
    }

    @Override
    public void _updateStep(AbstractCallChainStep step) {
        EmbeddedStep embeddedStep = (EmbeddedStep)step;
        if (this.embeddedChain != null) {
            CallChain callChain = (CallChain)CoreObjectManager.getInstance().getManager(CallChain.class).getById((Object)this.embeddedChain.getId());
            ControllerHelper.throwExceptionIfNull((Storable)callChain, this.embeddedChain.getName(), this.embeddedChain.getId(), CallChain.class, "get CallChain by id");
            embeddedStep.setChain(callChain);
        } else {
            embeddedStep.setChain(null);
        }
        embeddedStep.setConditionRetry(this.isConditionRetry());
        embeddedStep.setConditionMaxAttempts(this.getConditionMaxAttempts());
        embeddedStep.setConditionMaxTime(this.getConditionMaxTime());
        embeddedStep.setConditionUnitMaxTime(this.getConditionUnitMaxTime());
        this.processConditions((AbstractCallChainStep)embeddedStep);
    }

    public UIObject getEmbeddedChain() {
        return this.embeddedChain;
    }

    public void setEmbeddedChain(UIObject embeddedChain) {
        this.embeddedChain = embeddedChain;
    }
}

