/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.ui.messages.objects.transport;

import com.google.common.base.Function;
import com.google.common.base.Strings;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.qubership.automation.itf.core.model.common.Storable;
import org.qubership.automation.itf.core.model.jpa.environment.InboundTransportConfiguration;
import org.qubership.automation.itf.core.model.jpa.environment.TriggerConfiguration;
import org.qubership.automation.itf.core.model.jpa.transport.Configuration;
import org.qubership.automation.itf.core.util.descriptor.PropertyDescriptor;
import org.qubership.automation.itf.core.util.exception.TransportException;
import org.qubership.automation.itf.core.util.transport.manager.TransportRegistryManager;
import org.qubership.automation.itf.ui.messages.objects.UIObject;
import org.qubership.automation.itf.ui.messages.objects.transport.UIConfiguration;
import org.qubership.automation.itf.ui.messages.objects.transport.UIProperty;
import org.qubership.automation.itf.ui.messages.objects.transport.UITriggerConfiguration;

public class UIInboundConfiguration
extends UIConfiguration {
    private static final String DUMB_ID = "from " + UIInboundConfiguration.class.getSimpleName();
    private static final Function<TriggerConfiguration, UITriggerConfiguration> TO_UI_TRIGGER_CONF = new Function<TriggerConfiguration, UITriggerConfiguration>(){

        public UITriggerConfiguration apply(TriggerConfiguration input) {
            UITriggerConfiguration uiTriggerConfiguration = new UITriggerConfiguration((Configuration)input);
            try {
                uiTriggerConfiguration.defineProperties(input);
            }
            catch (RemoteException | TransportException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
            uiTriggerConfiguration.setState(input.getState().toString());
            uiTriggerConfiguration.setError(input.getActivationErrorMessage());
            return uiTriggerConfiguration;
        }
    };
    private ImmutableList<UITriggerConfiguration> triggers;
    private UIObject transport;
    private UITriggerConfiguration etalonTrigger;

    public UIInboundConfiguration() {
    }

    public UIInboundConfiguration(InboundTransportConfiguration configuration) {
        super((Configuration)configuration);
        this.transport = new UIObject((Storable)configuration.getReferencedConfiguration());
        try {
            TriggerConfiguration someTrigger = new TriggerConfiguration(configuration);
            someTrigger.setID((Object)DUMB_ID);
            this.etalonTrigger = new UITriggerConfiguration((Configuration)someTrigger);
            this.etalonTrigger.defineProperties(someTrigger);
        }
        catch (RemoteException | TransportException throwable) {
            // empty catch block
        }
    }

    @Nonnull
    static List<UIProperty> define(Collection<PropertyDescriptor> descriptors, Configuration parent, Configuration configuration) throws RemoteException {
        ArrayList uiProperties = Lists.newArrayListWithExpectedSize((int)descriptors.size());
        for (PropertyDescriptor descriptor : descriptors) {
            UIProperty uiProperty;
            if (!descriptor.isForServer()) continue;
            if (!Strings.isNullOrEmpty((String)configuration.get((Object)descriptor.getShortName()))) {
                uiProperty = new UIProperty(descriptor, configuration.get((Object)descriptor.getShortName()));
                uiProperty.setOverridden("Overridden");
                uiProperty.setInheritedValue(parent.get((Object)descriptor.getShortName()));
                uiProperties.add(uiProperty);
                continue;
            }
            uiProperty = new UIProperty(descriptor, parent.get((Object)descriptor.getShortName()));
            uiProperty.setOverridden("Inherited");
            uiProperties.add(uiProperty);
        }
        return uiProperties;
    }

    public ImmutableList<UITriggerConfiguration> getTriggers() {
        return this.triggers;
    }

    public void setTriggers(Collection<UITriggerConfiguration> triggers) {
        this.triggers = ImmutableList.copyOf(triggers);
    }

    public boolean defineProperties(InboundTransportConfiguration inboundTransport) throws RemoteException, TransportException {
        Map transportParameters = TransportRegistryManager.getInstance().getProperties(inboundTransport.getTypeName());
        boolean transportDeployed = transportParameters != null;
        List<UIProperty> uiProperties = transportDeployed ? UIInboundConfiguration.define(transportParameters.values(), (Configuration)inboundTransport.getReferencedConfiguration(), (Configuration)inboundTransport) : UIInboundConfiguration.defineNonDeployed((Configuration)inboundTransport);
        this.setProperties(uiProperties);
        return transportDeployed;
    }

    public void defineTriggers(Collection<TriggerConfiguration> triggerConfigurations) throws RemoteException {
        this.setTriggers(Collections2.transform(triggerConfigurations, TO_UI_TRIGGER_CONF));
    }

    public UIObject getTransport() {
        return this.transport;
    }

    public void setTransport(UIObject transport) {
        this.transport = transport;
    }

    public UITriggerConfiguration getEtalonTrigger() {
        return this.etalonTrigger;
    }

    public void setEtalonTrigger(UITriggerConfiguration etalonTrigger) {
        this.etalonTrigger = etalonTrigger;
    }
}

