/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.ui.services;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.liquibase.LiquibaseProperties;
import org.springframework.stereotype.Service;

@Service
public class LiquibaseCustomParametersInitializerService {
    @Value(value="${spring.application.name}")
    private String serviceName;
    @Value(value="${service.entities.migration.enabled:true}")
    private String serviceEntitiesMigrationEnabled;

    public void putCustomParameters(LiquibaseProperties liquibaseProperties) {
        Map<String, String> parameters = this.getLiquibaseParameters(liquibaseProperties);
        parameters.put("spring.application.name", this.serviceName);
        parameters.put("service.entities.migration.enabled", this.serviceEntitiesMigrationEnabled);
        liquibaseProperties.setParameters(parameters);
    }

    private Map<String, String> getLiquibaseParameters(LiquibaseProperties liquibaseProperties) {
        HashMap parameters = liquibaseProperties.getParameters();
        if (Objects.isNull(parameters)) {
            parameters = new HashMap();
        }
        return parameters;
    }
}

