/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.ui.services.javers.history;

import java.beans.ConstructorProperties;
import java.time.LocalDateTime;
import net.javacrumbs.shedlock.spring.annotation.SchedulerLock;
import org.qubership.atp.multitenancy.core.context.TenantContext;
import org.qubership.automation.itf.ui.services.javers.history.DeleteHistoryService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;

@Service
@ConditionalOnProperty(name={"javers.history.enabled"}, havingValue="true")
public class HistoryOldRevisionsCleaner {
    private static final Logger log = LoggerFactory.getLogger(HistoryOldRevisionsCleaner.class);
    private static final String UTC_TIMEZONE = "UTC";
    private final DeleteHistoryService deleteHistoryService;
    @Value(value="${atp.multi-tenancy.enabled}")
    private Boolean multiTenancyEnabled;
    @Value(value="${atp.itf.history.clean.job.revision.max.count}")
    private long maxRevisionCount;
    @Value(value="${atp.itf.history.clean.job.page-size}")
    private Integer pageSize;

    @Scheduled(cron="${atp.itf.history.clean.job.expression}", zone="UTC")
    @SchedulerLock(name="${atp.itf.history.clean.job.name}", lockAtMostFor="5m")
    public void run() {
        log.info("Schedule task: Start execute at {}.", (Object)LocalDateTime.now());
        try {
            if (this.multiTenancyEnabled.booleanValue()) {
                for (String tenantId : TenantContext.getTenantIds((boolean)true)) {
                    TenantContext.setTenantInfo((String)tenantId);
                    this.deleteSnapshots();
                }
                TenantContext.setDefaultTenantInfo();
            }
            this.deleteSnapshots();
        }
        catch (Exception e) {
            log.error("Error while executing a scheduled task {}, message: {}.", (Object)LocalDateTime.now(), (Object)e.getMessage());
        }
        finally {
            log.info("Schedule task: Finish execute at {}.", (Object)LocalDateTime.now());
        }
    }

    private void deleteSnapshots() {
        this.deleteHistoryService.deleteTerminatedSnapshots(this.pageSize);
        this.deleteHistoryService.deleteOldSnapshots(this.maxRevisionCount);
    }

    @ConstructorProperties(value={"deleteHistoryService"})
    public HistoryOldRevisionsCleaner(DeleteHistoryService deleteHistoryService) {
        this.deleteHistoryService = deleteHistoryService;
    }
}

