/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.ui.swagger;

import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.info.Info;
import io.swagger.v3.oas.models.info.License;
import io.swagger.v3.oas.models.security.SecurityRequirement;
import io.swagger.v3.oas.models.security.SecurityScheme;
import java.util.Map;
import java.util.TreeMap;
import org.springdoc.core.SpringDocUtils;
import org.springdoc.core.converters.models.Pageable;
import org.springdoc.core.customizers.OpenApiCustomiser;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.domain.PageRequest;
import org.springframework.util.StringUtils;

@Configuration
@ConditionalOnProperty(name={"springdoc.api-docs.enabled"}, havingValue="true")
public class SwaggerConfiguration {
    private static final String API_VERSION = "4.3.10";

    @Bean
    public OpenApiCustomiser globalOperationOpenApiCustomiser() {
        return openAPI -> openAPI.getPaths().values().forEach(pathItem -> pathItem.readOperations().forEach(operation -> {
            if (!StringUtils.hasLength((String)operation.getSummary())) {
                operation.setSummary(operation.getOperationId().split("_")[0]);
            }
        }));
    }

    @Bean
    public OpenApiCustomiser sortSchemasAlphabetically() {
        return openApi -> {
            Map schemas = openApi.getComponents().getSchemas();
            openApi.getComponents().setSchemas(new TreeMap(schemas));
        };
    }

    @Bean
    public OpenAPI itfExecutorOpenAPI() {
        SpringDocUtils.getConfig().replaceParameterObjectWithClass(org.springframework.data.domain.Pageable.class, Pageable.class).replaceParameterObjectWithClass(PageRequest.class, Pageable.class).removeRequestWrapperToIgnore(new Class[]{Map.class});
        return new OpenAPI().addSecurityItem(new SecurityRequirement().addList("Bearer Authentication")).components(new Components().addSecuritySchemes("Bearer Authentication", this.createAPIKeyScheme())).info(new Info().title("ITF Executor API").version(API_VERSION).license(new License().name("(C) Copyright Qubership")));
    }

    private SecurityScheme createAPIKeyScheme() {
        return new SecurityScheme().type(SecurityScheme.Type.HTTP).bearerFormat("JWT").scheme("bearer");
    }
}

