/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.ui.util;

import java.math.BigInteger;
import java.util.Collection;
import java.util.stream.Collectors;
import org.qubership.automation.itf.core.hibernate.spring.managers.executor.OperationEventTriggerObjectManager;
import org.qubership.automation.itf.core.hibernate.spring.managers.executor.SituationEventTriggerObjectManager;
import org.qubership.automation.itf.core.model.common.Storable;
import org.qubership.automation.itf.core.model.jpa.system.stub.EventTrigger;
import org.qubership.automation.itf.core.model.jpa.system.stub.OperationEventTrigger;
import org.qubership.automation.itf.core.model.jpa.system.stub.SituationEventTrigger;
import org.qubership.automation.itf.core.util.constants.TriggerState;
import org.qubership.automation.itf.core.util.converter.IdConverter;
import org.qubership.automation.itf.core.util.exception.TriggerException;
import org.qubership.automation.itf.core.util.manager.CoreObjectManager;
import org.qubership.automation.itf.executor.event.trigger.EventTriggerSwitcherFactory;
import org.qubership.automation.itf.executor.event.trigger.IEventTriggerSwitcher;
import org.qubership.automation.itf.ui.controls.util.ControllerConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventTriggerHelper {
    private static final Logger log = LoggerFactory.getLogger(EventTriggerHelper.class);

    public static void activateEventTriggers(BigInteger projectId) {
        EventTriggerHelper.activate(EventTriggerHelper.getAllActiveByProject(projectId), projectId);
    }

    private static void activate(Collection<? extends EventTrigger> eventTriggers, BigInteger projectId) {
        String logProjectString = projectId == null ? "" : "Project " + projectId + ":";
        log.info("{} Activation of Event Triggers is started...", (Object)logProjectString);
        int total = eventTriggers.size();
        int count = 0;
        int totalActive = 0;
        int countActive = 0;
        for (EventTrigger eventTrigger : eventTriggers) {
            if (eventTrigger.getState() != null && TriggerState.ACTIVE.equals((Object)eventTrigger.getState())) {
                ++totalActive;
                try {
                    IEventTriggerSwitcher switcher = EventTriggerSwitcherFactory.getSwitcherByEventTriggerType((String)eventTrigger.getType());
                    switcher.activate(eventTrigger);
                    ++countActive;
                    log.debug("Trigger {} is activated", (Object)eventTrigger);
                }
                catch (TriggerException e) {
                    log.error("Error activating trigger {}: {}", (Object)eventTrigger, (Object)e.getMessage());
                }
            }
            if (++count % 50 != 0) continue;
            log.info("{} Processed {} of {}; activated: {} of {}...", new Object[]{logProjectString, count, total, countActive, totalActive});
        }
        log.info("{} Activation of Event Triggers is finished - total {}; activated {} of {}.", new Object[]{logProjectString, total, countActive, totalActive});
    }

    private static Collection<EventTrigger> getAllActiveByProject(BigInteger projectId) {
        return ((SituationEventTriggerObjectManager)CoreObjectManager.getInstance().getSpecialManager(SituationEventTrigger.class, SituationEventTriggerObjectManager.class)).getActiveByProject(projectId).stream().map(EventTrigger.class::cast).collect(Collectors.toList());
    }

    public static EventTrigger getById(Object id) {
        SituationEventTrigger situationEventTrigger = ((SituationEventTriggerObjectManager)CoreObjectManager.getInstance().getSpecialManager(SituationEventTrigger.class, SituationEventTriggerObjectManager.class)).getByIdOnly(IdConverter.toBigInt((Object)id));
        return situationEventTrigger != null ? situationEventTrigger : ((OperationEventTriggerObjectManager)CoreObjectManager.getInstance().getSpecialManager(OperationEventTrigger.class, OperationEventTriggerObjectManager.class)).getByIdOnly(IdConverter.toBigInt((Object)id));
    }

    public static EventTrigger getByIdAndType(Object id, String type) {
        return ControllerConstants.OPERATION_EVENT_TRIGGER_TYPE.getStringValue().equals(type) ? (EventTrigger)CoreObjectManager.getInstance().getManager(OperationEventTrigger.class).getById(id) : (EventTrigger)CoreObjectManager.getInstance().getManager(SituationEventTrigger.class).getById(id);
    }

    public static EventTrigger create(Storable parent, String type) {
        return ControllerConstants.OPERATION_EVENT_TRIGGER_TYPE.getStringValue().equals(type) ? (EventTrigger)CoreObjectManager.getInstance().getManager(OperationEventTrigger.class).create(parent, type) : (EventTrigger)CoreObjectManager.getInstance().getManager(SituationEventTrigger.class).create(parent, type);
    }
}

