package org.qubership.atp.catalogue.openapi.dto;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.qubership.atp.catalogue.openapi.dto.CertificateDto;
import org.qubership.atp.catalogue.openapi.dto.ObjectOperationDto;
import org.qubership.atp.catalogue.openapi.dto.UserInfoDto;
import org.springframework.format.annotation.DateTimeFormat;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import javax.annotation.Generated;

/**
 * ProjectDto
 */

@JsonTypeName("Project")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2025-10-22T13:00:23.028Z[Etc/UTC]")
public class ProjectDto {

  @JsonProperty("numberOfThreshold")
  private Integer numberOfThreshold;

  @JsonProperty("dataSets")
  @Valid
  private List<String> dataSets = null;

  /**
   * Gets or Sets datasetFormat
   */
  public enum DatasetFormatEnum {
    DEFAULT("Default"),
    
    OBJECT("Object"),
    
    OPTIMIZED("Optimized");

    private String value;

    DatasetFormatEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static DatasetFormatEnum fromValue(String value) {
      for (DatasetFormatEnum b : DatasetFormatEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  @JsonProperty("datasetFormat")
  private DatasetFormatEnum datasetFormat;

  @JsonProperty("leads")
  @Valid
  private List<UUID> leads = null;

  @JsonProperty("qaTaEngineers")
  @Valid
  private List<UUID> qaTaEngineers = null;

  @JsonProperty("devOpsEngineers")
  @Valid
  private List<UUID> devOpsEngineers = null;

  @JsonProperty("atpRunners")
  @Valid
  private List<UUID> atpRunners = null;

  @JsonProperty("atpSupports")
  @Valid
  private List<UUID> atpSupports = null;

  @JsonProperty("taTools")
  @Valid
  private List<UUID> taTools = null;

  @JsonProperty("disableWarnMsgSizeExceed")
  private Boolean disableWarnMsgSizeExceed;

  @JsonProperty("disableWarnOutOfSyncTime")
  private Boolean disableWarnOutOfSyncTime;

  @JsonProperty("disableAutoSyncAtpTestCasesWithJiraTickets")
  private Boolean disableAutoSyncAtpTestCasesWithJiraTickets;

  @JsonProperty("projectLabel")
  private String projectLabel;

  @JsonProperty("notificationMessageSubjectTemplate")
  private String notificationMessageSubjectTemplate;

  /**
   * Gets or Sets projectType
   */
  public enum ProjectTypeEnum {
    IMPLEMENTATION("IMPLEMENTATION"),
    
    PRODUCT("PRODUCT"),
    
    OTHER("OTHER"),
    
    SANDBOX("SANDBOX");

    private String value;

    ProjectTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static ProjectTypeEnum fromValue(String value) {
      for (ProjectTypeEnum b : ProjectTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  @JsonProperty("projectType")
  private ProjectTypeEnum projectType;

  @JsonProperty("tshooterUrl")
  private String tshooterUrl;

  @JsonProperty("monitoringToolUrl")
  private String monitoringToolUrl;

  @JsonProperty("missionControlToolUrl")
  private String missionControlToolUrl;

  @JsonProperty("childrenOperations")
  @Valid
  private List<ObjectOperationDto> childrenOperations = null;

  @JsonProperty("certificate")
  private CertificateDto certificate;

  @JsonProperty("dateFormat")
  private String dateFormat;

  @JsonProperty("timeFormat")
  private String timeFormat;

  @JsonProperty("timeZone")
  private String timeZone;

  @JsonProperty("createdBy")
  private UserInfoDto createdBy;

  @JsonProperty("createdWhen")
  @DateTimeFormat(iso = DateTimeFormat.ISO.DATE_TIME)
  private OffsetDateTime createdWhen;

  @JsonProperty("modifiedBy")
  private UserInfoDto modifiedBy;

  @JsonProperty("modifiedWhen")
  @DateTimeFormat(iso = DateTimeFormat.ISO.DATE_TIME)
  private OffsetDateTime modifiedWhen;

  @JsonProperty("uuid")
  private UUID uuid;

  @JsonProperty("name")
  private String name;

  @JsonProperty("description")
  private String description;

  @JsonProperty("sourceId")
  private UUID sourceId;

  public ProjectDto numberOfThreshold(Integer numberOfThreshold) {
    this.numberOfThreshold = numberOfThreshold;
    return this;
  }

  /**
   * Get numberOfThreshold
   * @return numberOfThreshold
  */
  
  @Schema(name = "numberOfThreshold", required = false)
  public Integer getNumberOfThreshold() {
    return numberOfThreshold;
  }

  public void setNumberOfThreshold(Integer numberOfThreshold) {
    this.numberOfThreshold = numberOfThreshold;
  }

  public ProjectDto dataSets(List<String> dataSets) {
    this.dataSets = dataSets;
    return this;
  }

  public ProjectDto addDataSetsItem(String dataSetsItem) {
    if (this.dataSets == null) {
      this.dataSets = new ArrayList<>();
    }
    this.dataSets.add(dataSetsItem);
    return this;
  }

  /**
   * Get dataSets
   * @return dataSets
  */
  
  @Schema(name = "dataSets", required = false)
  public List<String> getDataSets() {
    return dataSets;
  }

  public void setDataSets(List<String> dataSets) {
    this.dataSets = dataSets;
  }

  public ProjectDto datasetFormat(DatasetFormatEnum datasetFormat) {
    this.datasetFormat = datasetFormat;
    return this;
  }

  /**
   * Get datasetFormat
   * @return datasetFormat
  */
  
  @Schema(name = "datasetFormat", required = false)
  public DatasetFormatEnum getDatasetFormat() {
    return datasetFormat;
  }

  public void setDatasetFormat(DatasetFormatEnum datasetFormat) {
    this.datasetFormat = datasetFormat;
  }

  public ProjectDto leads(List<UUID> leads) {
    this.leads = leads;
    return this;
  }

  public ProjectDto addLeadsItem(UUID leadsItem) {
    if (this.leads == null) {
      this.leads = new ArrayList<>();
    }
    this.leads.add(leadsItem);
    return this;
  }

  /**
   * Get leads
   * @return leads
  */
  @Valid 
  @Schema(name = "leads", required = false)
  public List<UUID> getLeads() {
    return leads;
  }

  public void setLeads(List<UUID> leads) {
    this.leads = leads;
  }

  public ProjectDto qaTaEngineers(List<UUID> qaTaEngineers) {
    this.qaTaEngineers = qaTaEngineers;
    return this;
  }

  public ProjectDto addQaTaEngineersItem(UUID qaTaEngineersItem) {
    if (this.qaTaEngineers == null) {
      this.qaTaEngineers = new ArrayList<>();
    }
    this.qaTaEngineers.add(qaTaEngineersItem);
    return this;
  }

  /**
   * Get qaTaEngineers
   * @return qaTaEngineers
  */
  @Valid 
  @Schema(name = "qaTaEngineers", required = false)
  public List<UUID> getQaTaEngineers() {
    return qaTaEngineers;
  }

  public void setQaTaEngineers(List<UUID> qaTaEngineers) {
    this.qaTaEngineers = qaTaEngineers;
  }

  public ProjectDto devOpsEngineers(List<UUID> devOpsEngineers) {
    this.devOpsEngineers = devOpsEngineers;
    return this;
  }

  public ProjectDto addDevOpsEngineersItem(UUID devOpsEngineersItem) {
    if (this.devOpsEngineers == null) {
      this.devOpsEngineers = new ArrayList<>();
    }
    this.devOpsEngineers.add(devOpsEngineersItem);
    return this;
  }

  /**
   * Get devOpsEngineers
   * @return devOpsEngineers
  */
  @Valid 
  @Schema(name = "devOpsEngineers", required = false)
  public List<UUID> getDevOpsEngineers() {
    return devOpsEngineers;
  }

  public void setDevOpsEngineers(List<UUID> devOpsEngineers) {
    this.devOpsEngineers = devOpsEngineers;
  }

  public ProjectDto atpRunners(List<UUID> atpRunners) {
    this.atpRunners = atpRunners;
    return this;
  }

  public ProjectDto addAtpRunnersItem(UUID atpRunnersItem) {
    if (this.atpRunners == null) {
      this.atpRunners = new ArrayList<>();
    }
    this.atpRunners.add(atpRunnersItem);
    return this;
  }

  /**
   * Get atpRunners
   * @return atpRunners
  */
  @Valid 
  @Schema(name = "atpRunners", required = false)
  public List<UUID> getAtpRunners() {
    return atpRunners;
  }

  public void setAtpRunners(List<UUID> atpRunners) {
    this.atpRunners = atpRunners;
  }

  public ProjectDto atpSupports(List<UUID> atpSupports) {
    this.atpSupports = atpSupports;
    return this;
  }

  public ProjectDto addAtpSupportsItem(UUID atpSupportsItem) {
    if (this.atpSupports == null) {
      this.atpSupports = new ArrayList<>();
    }
    this.atpSupports.add(atpSupportsItem);
    return this;
  }

  /**
   * Get atpSupports
   * @return atpSupports
  */
  @Valid 
  @Schema(name = "atpSupports", required = false)
  public List<UUID> getAtpSupports() {
    return atpSupports;
  }

  public void setAtpSupports(List<UUID> atpSupports) {
    this.atpSupports = atpSupports;
  }

  public ProjectDto taTools(List<UUID> taTools) {
    this.taTools = taTools;
    return this;
  }

  public ProjectDto addTaToolsItem(UUID taToolsItem) {
    if (this.taTools == null) {
      this.taTools = new ArrayList<>();
    }
    this.taTools.add(taToolsItem);
    return this;
  }

  /**
   * Get taTools
   * @return taTools
  */
  @Valid 
  @Schema(name = "taTools", required = false)
  public List<UUID> getTaTools() {
    return taTools;
  }

  public void setTaTools(List<UUID> taTools) {
    this.taTools = taTools;
  }

  public ProjectDto disableWarnMsgSizeExceed(Boolean disableWarnMsgSizeExceed) {
    this.disableWarnMsgSizeExceed = disableWarnMsgSizeExceed;
    return this;
  }

  /**
   * Get disableWarnMsgSizeExceed
   * @return disableWarnMsgSizeExceed
  */
  
  @Schema(name = "disableWarnMsgSizeExceed", required = false)
  public Boolean getDisableWarnMsgSizeExceed() {
    return disableWarnMsgSizeExceed;
  }

  public void setDisableWarnMsgSizeExceed(Boolean disableWarnMsgSizeExceed) {
    this.disableWarnMsgSizeExceed = disableWarnMsgSizeExceed;
  }

  public ProjectDto disableWarnOutOfSyncTime(Boolean disableWarnOutOfSyncTime) {
    this.disableWarnOutOfSyncTime = disableWarnOutOfSyncTime;
    return this;
  }

  /**
   * Get disableWarnOutOfSyncTime
   * @return disableWarnOutOfSyncTime
  */
  
  @Schema(name = "disableWarnOutOfSyncTime", required = false)
  public Boolean getDisableWarnOutOfSyncTime() {
    return disableWarnOutOfSyncTime;
  }

  public void setDisableWarnOutOfSyncTime(Boolean disableWarnOutOfSyncTime) {
    this.disableWarnOutOfSyncTime = disableWarnOutOfSyncTime;
  }

  public ProjectDto disableAutoSyncAtpTestCasesWithJiraTickets(Boolean disableAutoSyncAtpTestCasesWithJiraTickets) {
    this.disableAutoSyncAtpTestCasesWithJiraTickets = disableAutoSyncAtpTestCasesWithJiraTickets;
    return this;
  }

  /**
   * Get disableAutoSyncAtpTestCasesWithJiraTickets
   * @return disableAutoSyncAtpTestCasesWithJiraTickets
  */
  
  @Schema(name = "disableAutoSyncAtpTestCasesWithJiraTickets", required = false)
  public Boolean getDisableAutoSyncAtpTestCasesWithJiraTickets() {
    return disableAutoSyncAtpTestCasesWithJiraTickets;
  }

  public void setDisableAutoSyncAtpTestCasesWithJiraTickets(Boolean disableAutoSyncAtpTestCasesWithJiraTickets) {
    this.disableAutoSyncAtpTestCasesWithJiraTickets = disableAutoSyncAtpTestCasesWithJiraTickets;
  }

  public ProjectDto projectLabel(String projectLabel) {
    this.projectLabel = projectLabel;
    return this;
  }

  /**
   * Get projectLabel
   * @return projectLabel
  */
  
  @Schema(name = "projectLabel", required = false)
  public String getProjectLabel() {
    return projectLabel;
  }

  public void setProjectLabel(String projectLabel) {
    this.projectLabel = projectLabel;
  }

  public ProjectDto notificationMessageSubjectTemplate(String notificationMessageSubjectTemplate) {
    this.notificationMessageSubjectTemplate = notificationMessageSubjectTemplate;
    return this;
  }

  /**
   * Get notificationMessageSubjectTemplate
   * @return notificationMessageSubjectTemplate
  */
  
  @Schema(name = "notificationMessageSubjectTemplate", required = false)
  public String getNotificationMessageSubjectTemplate() {
    return notificationMessageSubjectTemplate;
  }

  public void setNotificationMessageSubjectTemplate(String notificationMessageSubjectTemplate) {
    this.notificationMessageSubjectTemplate = notificationMessageSubjectTemplate;
  }

  public ProjectDto projectType(ProjectTypeEnum projectType) {
    this.projectType = projectType;
    return this;
  }

  /**
   * Get projectType
   * @return projectType
  */
  
  @Schema(name = "projectType", required = false)
  public ProjectTypeEnum getProjectType() {
    return projectType;
  }

  public void setProjectType(ProjectTypeEnum projectType) {
    this.projectType = projectType;
  }

  public ProjectDto tshooterUrl(String tshooterUrl) {
    this.tshooterUrl = tshooterUrl;
    return this;
  }

  /**
   * Get tshooterUrl
   * @return tshooterUrl
  */
  
  @Schema(name = "tshooterUrl", required = false)
  public String getTshooterUrl() {
    return tshooterUrl;
  }

  public void setTshooterUrl(String tshooterUrl) {
    this.tshooterUrl = tshooterUrl;
  }

  public ProjectDto monitoringToolUrl(String monitoringToolUrl) {
    this.monitoringToolUrl = monitoringToolUrl;
    return this;
  }

  /**
   * Get monitoringToolUrl
   * @return monitoringToolUrl
  */
  
  @Schema(name = "monitoringToolUrl", required = false)
  public String getMonitoringToolUrl() {
    return monitoringToolUrl;
  }

  public void setMonitoringToolUrl(String monitoringToolUrl) {
    this.monitoringToolUrl = monitoringToolUrl;
  }

  public ProjectDto missionControlToolUrl(String missionControlToolUrl) {
    this.missionControlToolUrl = missionControlToolUrl;
    return this;
  }

  /**
   * Get missionControlToolUrl
   * @return missionControlToolUrl
  */
  
  @Schema(name = "missionControlToolUrl", required = false)
  public String getMissionControlToolUrl() {
    return missionControlToolUrl;
  }

  public void setMissionControlToolUrl(String missionControlToolUrl) {
    this.missionControlToolUrl = missionControlToolUrl;
  }

  public ProjectDto childrenOperations(List<ObjectOperationDto> childrenOperations) {
    this.childrenOperations = childrenOperations;
    return this;
  }

  public ProjectDto addChildrenOperationsItem(ObjectOperationDto childrenOperationsItem) {
    if (this.childrenOperations == null) {
      this.childrenOperations = new ArrayList<>();
    }
    this.childrenOperations.add(childrenOperationsItem);
    return this;
  }

  /**
   * Get childrenOperations
   * @return childrenOperations
  */
  @Valid 
  @Schema(name = "childrenOperations", required = false)
  public List<ObjectOperationDto> getChildrenOperations() {
    return childrenOperations;
  }

  public void setChildrenOperations(List<ObjectOperationDto> childrenOperations) {
    this.childrenOperations = childrenOperations;
  }

  public ProjectDto certificate(CertificateDto certificate) {
    this.certificate = certificate;
    return this;
  }

  /**
   * Get certificate
   * @return certificate
  */
  @Valid 
  @Schema(name = "certificate", required = false)
  public CertificateDto getCertificate() {
    return certificate;
  }

  public void setCertificate(CertificateDto certificate) {
    this.certificate = certificate;
  }

  public ProjectDto dateFormat(String dateFormat) {
    this.dateFormat = dateFormat;
    return this;
  }

  /**
   * Get dateFormat
   * @return dateFormat
  */
  
  @Schema(name = "dateFormat", required = false)
  public String getDateFormat() {
    return dateFormat;
  }

  public void setDateFormat(String dateFormat) {
    this.dateFormat = dateFormat;
  }

  public ProjectDto timeFormat(String timeFormat) {
    this.timeFormat = timeFormat;
    return this;
  }

  /**
   * Get timeFormat
   * @return timeFormat
  */
  
  @Schema(name = "timeFormat", required = false)
  public String getTimeFormat() {
    return timeFormat;
  }

  public void setTimeFormat(String timeFormat) {
    this.timeFormat = timeFormat;
  }

  public ProjectDto timeZone(String timeZone) {
    this.timeZone = timeZone;
    return this;
  }

  /**
   * Get timeZone
   * @return timeZone
  */
  
  @Schema(name = "timeZone", required = false)
  public String getTimeZone() {
    return timeZone;
  }

  public void setTimeZone(String timeZone) {
    this.timeZone = timeZone;
  }

  public ProjectDto createdBy(UserInfoDto createdBy) {
    this.createdBy = createdBy;
    return this;
  }

  /**
   * Get createdBy
   * @return createdBy
  */
  @Valid 
  @Schema(name = "createdBy", required = false)
  public UserInfoDto getCreatedBy() {
    return createdBy;
  }

  public void setCreatedBy(UserInfoDto createdBy) {
    this.createdBy = createdBy;
  }

  public ProjectDto createdWhen(OffsetDateTime createdWhen) {
    this.createdWhen = createdWhen;
    return this;
  }

  /**
   * Get createdWhen
   * @return createdWhen
  */
  @Valid 
  @Schema(name = "createdWhen", required = false)
  public OffsetDateTime getCreatedWhen() {
    return createdWhen;
  }

  public void setCreatedWhen(OffsetDateTime createdWhen) {
    this.createdWhen = createdWhen;
  }

  public ProjectDto modifiedBy(UserInfoDto modifiedBy) {
    this.modifiedBy = modifiedBy;
    return this;
  }

  /**
   * Get modifiedBy
   * @return modifiedBy
  */
  @Valid 
  @Schema(name = "modifiedBy", required = false)
  public UserInfoDto getModifiedBy() {
    return modifiedBy;
  }

  public void setModifiedBy(UserInfoDto modifiedBy) {
    this.modifiedBy = modifiedBy;
  }

  public ProjectDto modifiedWhen(OffsetDateTime modifiedWhen) {
    this.modifiedWhen = modifiedWhen;
    return this;
  }

  /**
   * Get modifiedWhen
   * @return modifiedWhen
  */
  @Valid 
  @Schema(name = "modifiedWhen", required = false)
  public OffsetDateTime getModifiedWhen() {
    return modifiedWhen;
  }

  public void setModifiedWhen(OffsetDateTime modifiedWhen) {
    this.modifiedWhen = modifiedWhen;
  }

  public ProjectDto uuid(UUID uuid) {
    this.uuid = uuid;
    return this;
  }

  /**
   * Get uuid
   * @return uuid
  */
  @Valid 
  @Schema(name = "uuid", required = false)
  public UUID getUuid() {
    return uuid;
  }

  public void setUuid(UUID uuid) {
    this.uuid = uuid;
  }

  public ProjectDto name(String name) {
    this.name = name;
    return this;
  }

  /**
   * Get name
   * @return name
  */
  
  @Schema(name = "name", required = false)
  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public ProjectDto description(String description) {
    this.description = description;
    return this;
  }

  /**
   * Get description
   * @return description
  */
  
  @Schema(name = "description", required = false)
  public String getDescription() {
    return description;
  }

  public void setDescription(String description) {
    this.description = description;
  }

  public ProjectDto sourceId(UUID sourceId) {
    this.sourceId = sourceId;
    return this;
  }

  /**
   * Get sourceId
   * @return sourceId
  */
  @Valid 
  @Schema(name = "sourceId", required = false)
  public UUID getSourceId() {
    return sourceId;
  }

  public void setSourceId(UUID sourceId) {
    this.sourceId = sourceId;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ProjectDto project = (ProjectDto) o;
    return Objects.equals(this.numberOfThreshold, project.numberOfThreshold) &&
        Objects.equals(this.dataSets, project.dataSets) &&
        Objects.equals(this.datasetFormat, project.datasetFormat) &&
        Objects.equals(this.leads, project.leads) &&
        Objects.equals(this.qaTaEngineers, project.qaTaEngineers) &&
        Objects.equals(this.devOpsEngineers, project.devOpsEngineers) &&
        Objects.equals(this.atpRunners, project.atpRunners) &&
        Objects.equals(this.atpSupports, project.atpSupports) &&
        Objects.equals(this.taTools, project.taTools) &&
        Objects.equals(this.disableWarnMsgSizeExceed, project.disableWarnMsgSizeExceed) &&
        Objects.equals(this.disableWarnOutOfSyncTime, project.disableWarnOutOfSyncTime) &&
        Objects.equals(this.disableAutoSyncAtpTestCasesWithJiraTickets, project.disableAutoSyncAtpTestCasesWithJiraTickets) &&
        Objects.equals(this.projectLabel, project.projectLabel) &&
        Objects.equals(this.notificationMessageSubjectTemplate, project.notificationMessageSubjectTemplate) &&
        Objects.equals(this.projectType, project.projectType) &&
        Objects.equals(this.tshooterUrl, project.tshooterUrl) &&
        Objects.equals(this.monitoringToolUrl, project.monitoringToolUrl) &&
        Objects.equals(this.missionControlToolUrl, project.missionControlToolUrl) &&
        Objects.equals(this.childrenOperations, project.childrenOperations) &&
        Objects.equals(this.certificate, project.certificate) &&
        Objects.equals(this.dateFormat, project.dateFormat) &&
        Objects.equals(this.timeFormat, project.timeFormat) &&
        Objects.equals(this.timeZone, project.timeZone) &&
        Objects.equals(this.createdBy, project.createdBy) &&
        Objects.equals(this.createdWhen, project.createdWhen) &&
        Objects.equals(this.modifiedBy, project.modifiedBy) &&
        Objects.equals(this.modifiedWhen, project.modifiedWhen) &&
        Objects.equals(this.uuid, project.uuid) &&
        Objects.equals(this.name, project.name) &&
        Objects.equals(this.description, project.description) &&
        Objects.equals(this.sourceId, project.sourceId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(numberOfThreshold, dataSets, datasetFormat, leads, qaTaEngineers, devOpsEngineers, atpRunners, atpSupports, taTools, disableWarnMsgSizeExceed, disableWarnOutOfSyncTime, disableAutoSyncAtpTestCasesWithJiraTickets, projectLabel, notificationMessageSubjectTemplate, projectType, tshooterUrl, monitoringToolUrl, missionControlToolUrl, childrenOperations, certificate, dateFormat, timeFormat, timeZone, createdBy, createdWhen, modifiedBy, modifiedWhen, uuid, name, description, sourceId);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ProjectDto {\n");
    sb.append("    numberOfThreshold: ").append(toIndentedString(numberOfThreshold)).append("\n");
    sb.append("    dataSets: ").append(toIndentedString(dataSets)).append("\n");
    sb.append("    datasetFormat: ").append(toIndentedString(datasetFormat)).append("\n");
    sb.append("    leads: ").append(toIndentedString(leads)).append("\n");
    sb.append("    qaTaEngineers: ").append(toIndentedString(qaTaEngineers)).append("\n");
    sb.append("    devOpsEngineers: ").append(toIndentedString(devOpsEngineers)).append("\n");
    sb.append("    atpRunners: ").append(toIndentedString(atpRunners)).append("\n");
    sb.append("    atpSupports: ").append(toIndentedString(atpSupports)).append("\n");
    sb.append("    taTools: ").append(toIndentedString(taTools)).append("\n");
    sb.append("    disableWarnMsgSizeExceed: ").append(toIndentedString(disableWarnMsgSizeExceed)).append("\n");
    sb.append("    disableWarnOutOfSyncTime: ").append(toIndentedString(disableWarnOutOfSyncTime)).append("\n");
    sb.append("    disableAutoSyncAtpTestCasesWithJiraTickets: ").append(toIndentedString(disableAutoSyncAtpTestCasesWithJiraTickets)).append("\n");
    sb.append("    projectLabel: ").append(toIndentedString(projectLabel)).append("\n");
    sb.append("    notificationMessageSubjectTemplate: ").append(toIndentedString(notificationMessageSubjectTemplate)).append("\n");
    sb.append("    projectType: ").append(toIndentedString(projectType)).append("\n");
    sb.append("    tshooterUrl: ").append(toIndentedString(tshooterUrl)).append("\n");
    sb.append("    monitoringToolUrl: ").append(toIndentedString(monitoringToolUrl)).append("\n");
    sb.append("    missionControlToolUrl: ").append(toIndentedString(missionControlToolUrl)).append("\n");
    sb.append("    childrenOperations: ").append(toIndentedString(childrenOperations)).append("\n");
    sb.append("    certificate: ").append(toIndentedString(certificate)).append("\n");
    sb.append("    dateFormat: ").append(toIndentedString(dateFormat)).append("\n");
    sb.append("    timeFormat: ").append(toIndentedString(timeFormat)).append("\n");
    sb.append("    timeZone: ").append(toIndentedString(timeZone)).append("\n");
    sb.append("    createdBy: ").append(toIndentedString(createdBy)).append("\n");
    sb.append("    createdWhen: ").append(toIndentedString(createdWhen)).append("\n");
    sb.append("    modifiedBy: ").append(toIndentedString(modifiedBy)).append("\n");
    sb.append("    modifiedWhen: ").append(toIndentedString(modifiedWhen)).append("\n");
    sb.append("    uuid: ").append(toIndentedString(uuid)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    sourceId: ").append(toIndentedString(sourceId)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

