/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech) (6.2.1).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
package org.qubership.atp.environments.openapi.controllers;

import org.qubership.atp.environments.openapi.dto.ConnectionFullVer1ViewDto;
import org.qubership.atp.environments.openapi.dto.CreateSystemDtoDto;
import org.qubership.atp.environments.openapi.dto.ParametersGettingVersionDto;
import org.qubership.atp.environments.openapi.dto.ShortExternalServiceDto;
import org.qubership.atp.environments.openapi.dto.SynchronizeCloudServicesRequestDto;
import org.qubership.atp.environments.openapi.dto.SystemDtoDto;
import org.qubership.atp.environments.openapi.dto.SystemEnvironmentsViewDto;
import org.qubership.atp.environments.openapi.dto.SystemFullVer1ViewDto;
import org.qubership.atp.environments.openapi.dto.SystemFullVer2ViewDto;
import java.util.UUID;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.multipart.MultipartFile;

import javax.validation.Valid;
import javax.validation.constraints.*;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;

@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2025-10-22T13:00:23.702Z[Etc/UTC]")
@Validated
@Tag(name = "SystemController", description = "System Controller")
public interface SystemControllerApi {

    /**
     * POST /api/systems/{systemId}/copy : copy
     *
     * @param systemId systemId (required)
     * @param createSystemDtoDto  (optional)
     * @return OK (status code 200)
     *         or Created (status code 201)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "copy",
        summary = "copy",
        tags = { "system-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = SystemFullVer1ViewDto.class))
            }),
            @ApiResponse(responseCode = "201", description = "Created"),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.POST,
        value = "/api/systems/{systemId}/copy",
        produces = { "application/json" },
        consumes = { "application/json" }
    )
    ResponseEntity<SystemFullVer1ViewDto> copy(
        @Parameter(name = "systemId", description = "systemId", required = true) @PathVariable("systemId") UUID systemId,
        @Parameter(name = "CreateSystemDtoDto", description = "") @Valid @RequestBody(required = false) CreateSystemDtoDto createSystemDtoDto
    );


    /**
     * POST /api/systems : create
     *
     * @param createSystemDtoDto  (optional)
     * @return OK (status code 200)
     *         or Created (status code 201)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "createSystem",
        summary = "create",
        tags = { "system-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = SystemFullVer1ViewDto.class))
            }),
            @ApiResponse(responseCode = "201", description = "Created"),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.POST,
        value = "/api/systems",
        produces = { "application/json" },
        consumes = { "application/json" }
    )
    ResponseEntity<SystemFullVer1ViewDto> createSystem(
        @Parameter(name = "CreateSystemDtoDto", description = "") @Valid @RequestBody(required = false) CreateSystemDtoDto createSystemDtoDto
    );


    /**
     * DELETE /api/systems/link/{systemId}/{environmentId} : deleteLinkedSystems
     *
     * @param systemId systemId (required)
     * @param environmentId systemId (required)
     * @return No Content (status code 204)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     */
    @Operation(
        operationId = "deleteLinkedSystems",
        summary = "deleteLinkedSystems",
        tags = { "system-controller" },
        responses = {
            @ApiResponse(responseCode = "204", description = "No Content"),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden")
        }
    )
    @RequestMapping(
        method = RequestMethod.DELETE,
        value = "/api/systems/link/{systemId}/{environmentId}"
    )
    ResponseEntity<Void> deleteLinkedSystems(
        @Parameter(name = "systemId", description = "systemId", required = true) @PathVariable("systemId") UUID systemId,
        @Parameter(name = "environmentId", description = "systemId", required = true) @PathVariable("environmentId") UUID environmentId
    );


    /**
     * DELETE /api/systems/{systemId} : delete
     *
     * @param systemId systemId (required)
     * @param environmentId environmentId (required)
     * @return No Content (status code 204)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     */
    @Operation(
        operationId = "deleteSystem",
        summary = "delete",
        tags = { "system-controller" },
        responses = {
            @ApiResponse(responseCode = "204", description = "No Content"),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden")
        }
    )
    @RequestMapping(
        method = RequestMethod.DELETE,
        value = "/api/systems/{systemId}"
    )
    ResponseEntity<Void> deleteSystem(
        @Parameter(name = "systemId", description = "systemId", required = true) @PathVariable("systemId") UUID systemId,
        @NotNull @Parameter(name = "environmentId", description = "environmentId", required = true) @Valid @RequestParam(value = "environmentId", required = true) UUID environmentId
    );


    /**
     * GET /api/systems : getAll
     *
     * @param full full (optional)
     * @return OK (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "getAll",
        summary = "getAll",
        tags = { "system-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = SystemFullVer1ViewDto.class))
            }),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/api/systems",
        produces = { "application/json" }
    )
    ResponseEntity<List<SystemFullVer1ViewDto>> getAll(
        @Parameter(name = "full", description = "full") @Valid @RequestParam(value = "full", required = false) Boolean full
    );


    /**
     * GET /api/systems/short : Endpoint for getting list of systems on all projects 
     *
     * @param full full (optional)
     * @return OK (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "getAllSystems",
        summary = "Endpoint for getting list of systems on all projects ",
        tags = { "system-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = SystemEnvironmentsViewDto.class))
            }),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/api/systems/short",
        produces = { "application/json" }
    )
    ResponseEntity<List<SystemEnvironmentsViewDto>> getAllSystems(
        @Parameter(name = "full", description = "full") @Valid @RequestParam(value = "full", required = false) Boolean full
    );


    /**
     * GET /api/public/v1/systems/{systemId}/version : getCachedVersion
     *
     * @param systemId systemId (required)
     * @return OK (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "getCachedVersion",
        summary = "getCachedVersion",
        tags = { "system-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = Object.class))
            }),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/api/public/v1/systems/{systemId}/version",
        produces = { "application/json" }
    )
    ResponseEntity<Object> getCachedVersion(
        @Parameter(name = "systemId", description = "systemId", required = true) @PathVariable("systemId") UUID systemId
    );


    /**
     * GET /api/systems/{systemId}/htmlVersion : getHtmlVersion
     *
     * @param systemId systemId (required)
     * @return OK (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "getHtmlVersion",
        summary = "getHtmlVersion",
        tags = { "system-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "text/plain", schema = @Schema(implementation = String.class))
            }),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/api/systems/{systemId}/htmlVersion",
        produces = { "text/plain" }
    )
    ResponseEntity<String> getHtmlVersion(
        @Parameter(name = "systemId", description = "systemId", required = true) @PathVariable("systemId") UUID systemId
    );


    /**
     * GET /api/systems/shortKubeServices/{systemId} : getKubernetesServiceNames
     *
     * @param systemId systemId (required)
     * @return OK (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "getKubernetesServiceNames",
        summary = "getKubernetesServiceNames",
        tags = { "system-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = ShortExternalServiceDto.class))
            }),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/api/systems/shortKubeServices/{systemId}",
        produces = { "application/json" }
    )
    ResponseEntity<List<ShortExternalServiceDto>> getKubernetesServiceNames(
        @Parameter(name = "systemId", description = "systemId", required = true) @PathVariable("systemId") UUID systemId
    );


    /**
     * GET /api/systems/link/{systemId} : getLinkedCloudServices
     *
     * @param systemId systemId (required)
     * @return OK (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "getLinkedCloudServices",
        summary = "getLinkedCloudServices",
        tags = { "system-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = SystemFullVer1ViewDto.class))
            }),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/api/systems/link/{systemId}",
        produces = { "application/json" }
    )
    ResponseEntity<List<SystemFullVer1ViewDto>> getLinkedCloudServices(
        @Parameter(name = "systemId", description = "systemId", required = true) @PathVariable("systemId") UUID systemId
    );


    /**
     * GET /api/systems/shortOpenshiftServices/{systemId} : getOpenshiftServiceNames
     *
     * @param systemId systemId (required)
     * @return OK (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "getOpenshiftServiceNames",
        summary = "getOpenshiftServiceNames",
        tags = { "system-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = ShortExternalServiceDto.class))
            }),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/api/systems/shortOpenshiftServices/{systemId}",
        produces = { "application/json" }
    )
    ResponseEntity<List<ShortExternalServiceDto>> getOpenshiftServiceNames(
        @Parameter(name = "systemId", description = "systemId", required = true) @PathVariable("systemId") UUID systemId
    );


    /**
     * GET /api/public/v1/systems/{systemId}/htmlVersion : getPublicHtmlVersion
     *
     * @param systemId systemId (required)
     * @return OK (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "getPublicHtmlVersion",
        summary = "getPublicHtmlVersion",
        tags = { "system-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "text/plain", schema = @Schema(implementation = String.class))
            }),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/api/public/v1/systems/{systemId}/htmlVersion",
        produces = { "text/plain" }
    )
    ResponseEntity<String> getPublicHtmlVersion(
        @Parameter(name = "systemId", description = "systemId", required = true) @PathVariable("systemId") UUID systemId
    );


    /**
     * GET /api/systems/{systemId} : getSystem
     *
     * @param systemId systemId (required)
     * @param full full (optional)
     * @return OK (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "getSystem",
        summary = "getSystem",
        tags = { "system-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = SystemFullVer1ViewDto.class))
            }),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/api/systems/{systemId}",
        produces = { "application/json" }
    )
    ResponseEntity<SystemFullVer1ViewDto> getSystem(
        @Parameter(name = "systemId", description = "systemId", required = true) @PathVariable("systemId") UUID systemId,
        @Parameter(name = "full", description = "full") @Valid @RequestParam(value = "full", required = false) Boolean full
    );


    /**
     * GET /api/systems/{systemId}/connections : getSystems
     *
     * @param systemId systemId (required)
     * @param full full (optional)
     * @return OK (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "getSystemConnections",
        summary = "getSystems",
        tags = { "system-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = ConnectionFullVer1ViewDto.class))
            }),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/api/systems/{systemId}/connections",
        produces = { "application/json" }
    )
    ResponseEntity<List<ConnectionFullVer1ViewDto>> getSystemConnections(
        @Parameter(name = "systemId", description = "systemId", required = true) @PathVariable("systemId") UUID systemId,
        @Parameter(name = "full", description = "full") @Valid @RequestParam(value = "full", required = false) Boolean full
    );


    /**
     * GET /api/v2/systems/{systemId} : getSystemV2
     *
     * @param systemId systemId (required)
     * @param full full (optional)
     * @return OK (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "getSystemV2",
        summary = "getSystemV2",
        tags = { "system-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = SystemFullVer2ViewDto.class))
            }),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/api/v2/systems/{systemId}",
        produces = { "application/json" }
    )
    ResponseEntity<SystemFullVer2ViewDto> getSystemV2(
        @Parameter(name = "systemId", description = "systemId", required = true) @PathVariable("systemId") UUID systemId,
        @Parameter(name = "full", description = "full") @Valid @RequestParam(value = "full", required = false) Boolean full
    );


    /**
     * PUT /api/systems/openshift : openshiftUpdateRoutes
     *
     * @param createSystemDtoDto  (optional)
     * @return OK (status code 200)
     *         or Created (status code 201)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "openshiftUpdateRoutes",
        summary = "openshiftUpdateRoutes",
        tags = { "system-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = ConnectionFullVer1ViewDto.class))
            }),
            @ApiResponse(responseCode = "201", description = "Created"),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.PUT,
        value = "/api/systems/openshift",
        produces = { "application/json" },
        consumes = { "application/json" }
    )
    ResponseEntity<List<ConnectionFullVer1ViewDto>> openshiftUpdateRoutes(
        @Parameter(name = "CreateSystemDtoDto", description = "") @Valid @RequestBody(required = false) CreateSystemDtoDto createSystemDtoDto
    );


    /**
     * PUT /api/systems/{systemId}/share : share
     *
     * @param systemId systemId (required)
     * @param environmentId environmentId (required)
     * @param modified modified (optional)
     * @return OK (status code 200)
     *         or Created (status code 201)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "share",
        summary = "share",
        tags = { "system-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = SystemFullVer2ViewDto.class))
            }),
            @ApiResponse(responseCode = "201", description = "Created"),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.PUT,
        value = "/api/systems/{systemId}/share",
        produces = { "application/json" }
    )
    ResponseEntity<SystemFullVer2ViewDto> share(
        @Parameter(name = "systemId", description = "systemId", required = true) @PathVariable("systemId") UUID systemId,
        @NotNull @Parameter(name = "environmentId", description = "environmentId", required = true) @Valid @RequestParam(value = "environmentId", required = true) UUID environmentId,
        @Parameter(name = "modified", description = "modified") @Valid @RequestParam(value = "modified", required = false) Long modified
    );


    /**
     * POST /api/systems/kubeServices/{environmentId}/{systemId} : synchronizeServicesFromKubernetes
     *
     * @param systemId systemId (required)
     * @param environmentId environmentId (required)
     * @param synchronizeCloudServicesRequestDto  (optional)
     * @return OK (status code 200)
     *         or Created (status code 201)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "synchronizeServicesFromKubernetes",
        summary = "synchronizeServicesFromKubernetes",
        tags = { "system-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = SystemFullVer1ViewDto.class))
            }),
            @ApiResponse(responseCode = "201", description = "Created"),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.POST,
        value = "/api/systems/kubeServices/{environmentId}/{systemId}",
        produces = { "application/json" },
        consumes = { "application/json" }
    )
    ResponseEntity<List<SystemFullVer1ViewDto>> synchronizeServicesFromKubernetes(
        @Parameter(name = "systemId", description = "systemId", required = true) @PathVariable("systemId") UUID systemId,
        @Parameter(name = "environmentId", description = "environmentId", required = true) @PathVariable("environmentId") UUID environmentId,
        @Parameter(name = "SynchronizeCloudServicesRequestDto", description = "") @Valid @RequestBody(required = false) SynchronizeCloudServicesRequestDto synchronizeCloudServicesRequestDto
    );


    /**
     * POST /api/systems/openshiftServices/{environmentId}/{systemId} : synchronizeServicesFromOpenShift
     *
     * @param systemId systemId (required)
     * @param environmentId environmentId (required)
     * @param synchronizeCloudServicesRequestDto  (optional)
     * @return OK (status code 200)
     *         or Created (status code 201)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "synchronizeServicesFromOpenShift",
        summary = "synchronizeServicesFromOpenShift",
        tags = { "system-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = SystemFullVer1ViewDto.class))
            }),
            @ApiResponse(responseCode = "201", description = "Created"),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.POST,
        value = "/api/systems/openshiftServices/{environmentId}/{systemId}",
        produces = { "application/json" },
        consumes = { "application/json" }
    )
    ResponseEntity<List<SystemFullVer1ViewDto>> synchronizeServicesFromOpenShift(
        @Parameter(name = "systemId", description = "systemId", required = true) @PathVariable("systemId") UUID systemId,
        @Parameter(name = "environmentId", description = "environmentId", required = true) @PathVariable("environmentId") UUID environmentId,
        @Parameter(name = "SynchronizeCloudServicesRequestDto", description = "") @Valid @RequestBody(required = false) SynchronizeCloudServicesRequestDto synchronizeCloudServicesRequestDto
    );


    /**
     * PUT /api/systems/{systemId}/unshare : unShare
     *
     * @param systemId systemId (required)
     * @param environmentId environmentId (required)
     * @param modified modified (optional)
     * @return OK (status code 200)
     *         or Created (status code 201)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "unShare",
        summary = "unShare",
        tags = { "system-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = SystemFullVer2ViewDto.class))
            }),
            @ApiResponse(responseCode = "201", description = "Created"),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.PUT,
        value = "/api/systems/{systemId}/unshare",
        produces = { "application/json" }
    )
    ResponseEntity<SystemFullVer2ViewDto> unShare(
        @Parameter(name = "systemId", description = "systemId", required = true) @PathVariable("systemId") UUID systemId,
        @NotNull @Parameter(name = "environmentId", description = "environmentId", required = true) @Valid @RequestParam(value = "environmentId", required = true) UUID environmentId,
        @Parameter(name = "modified", description = "modified") @Valid @RequestParam(value = "modified", required = false) Long modified
    );


    /**
     * PUT /api/systems/{systemId}/parametersGettingVersion : updateParametersGettingVersion
     *
     * @param systemId systemId (required)
     * @param parametersGettingVersionDto  (optional)
     * @return OK (status code 200)
     *         or Created (status code 201)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "updateParametersGettingVersion",
        summary = "updateParametersGettingVersion",
        tags = { "system-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = SystemFullVer1ViewDto.class))
            }),
            @ApiResponse(responseCode = "201", description = "Created"),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.PUT,
        value = "/api/systems/{systemId}/parametersGettingVersion",
        produces = { "application/json" },
        consumes = { "application/json" }
    )
    ResponseEntity<SystemFullVer1ViewDto> updateParametersGettingVersion(
        @Parameter(name = "systemId", description = "systemId", required = true) @PathVariable("systemId") UUID systemId,
        @Parameter(name = "ParametersGettingVersionDto", description = "") @Valid @RequestBody(required = false) ParametersGettingVersionDto parametersGettingVersionDto
    );


    /**
     * GET /api/systems/kubeServices/{systemId} : updateServicesFromKubernetes
     *
     * @param systemId systemId (required)
     * @return OK (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "updateServicesFromKubernetes",
        summary = "updateServicesFromKubernetes",
        tags = { "system-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = SystemFullVer2ViewDto.class))
            }),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/api/systems/kubeServices/{systemId}",
        produces = { "application/json" }
    )
    ResponseEntity<List<SystemFullVer2ViewDto>> updateServicesFromKubernetes(
        @Parameter(name = "systemId", description = "systemId", required = true) @PathVariable("systemId") UUID systemId
    );


    /**
     * GET /api/systems/openshiftServices/{systemId} : updateServicesFromOpenshift
     *
     * @param systemId systemId (required)
     * @return OK (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "updateServicesFromOpenshift",
        summary = "updateServicesFromOpenshift",
        tags = { "system-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = SystemFullVer2ViewDto.class))
            }),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/api/systems/openshiftServices/{systemId}",
        produces = { "application/json" }
    )
    ResponseEntity<List<SystemFullVer2ViewDto>> updateServicesFromOpenshift(
        @Parameter(name = "systemId", description = "systemId", required = true) @PathVariable("systemId") UUID systemId
    );


    /**
     * PUT /api/systems : update
     *
     * @param systemDtoDto  (optional)
     * @return OK (status code 200)
     *         or Created (status code 201)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "updateSystem",
        summary = "update",
        tags = { "system-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = SystemFullVer1ViewDto.class))
            }),
            @ApiResponse(responseCode = "201", description = "Created"),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.PUT,
        value = "/api/systems",
        produces = { "application/json" },
        consumes = { "application/json" }
    )
    ResponseEntity<SystemFullVer1ViewDto> updateSystem(
        @Parameter(name = "SystemDtoDto", description = "") @Valid @RequestBody(required = false) SystemDtoDto systemDtoDto
    );


    /**
     * GET /api/systems/{systemId}/version : updateVersion
     *
     * @param systemId systemId (required)
     * @return OK (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "updateVersion",
        summary = "updateVersion",
        tags = { "system-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = SystemFullVer1ViewDto.class))
            }),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/api/systems/{systemId}/version",
        produces = { "application/json" }
    )
    ResponseEntity<SystemFullVer1ViewDto> updateVersion(
        @Parameter(name = "systemId", description = "systemId", required = true) @PathVariable("systemId") UUID systemId
    );

}
