package org.qubership.atp.users.clients.dto;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import javax.annotation.Generated;

/**
 * EntityDto
 */

@JsonTypeName("Entity")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2025-10-22T13:00:22.898Z[Etc/UTC]")
public class EntityDto {

  @JsonProperty("entities")
  @Valid
  private List<String> entities = null;

  @JsonProperty("service")
  private String service;

  @JsonProperty("uuid")
  private UUID uuid;

  public EntityDto entities(List<String> entities) {
    this.entities = entities;
    return this;
  }

  public EntityDto addEntitiesItem(String entitiesItem) {
    if (this.entities == null) {
      this.entities = new ArrayList<>();
    }
    this.entities.add(entitiesItem);
    return this;
  }

  /**
   * Get entities
   * @return entities
  */
  
  @Schema(name = "entities", required = false)
  public List<String> getEntities() {
    return entities;
  }

  public void setEntities(List<String> entities) {
    this.entities = entities;
  }

  public EntityDto service(String service) {
    this.service = service;
    return this;
  }

  /**
   * Get service
   * @return service
  */
  
  @Schema(name = "service", required = false)
  public String getService() {
    return service;
  }

  public void setService(String service) {
    this.service = service;
  }

  public EntityDto uuid(UUID uuid) {
    this.uuid = uuid;
    return this;
  }

  /**
   * Get uuid
   * @return uuid
  */
  @Valid 
  @Schema(name = "uuid", required = false)
  public UUID getUuid() {
    return uuid;
  }

  public void setUuid(UUID uuid) {
    this.uuid = uuid;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    EntityDto entity = (EntityDto) o;
    return Objects.equals(this.entities, entity.entities) &&
        Objects.equals(this.service, entity.service) &&
        Objects.equals(this.uuid, entity.uuid);
  }

  @Override
  public int hashCode() {
    return Objects.hash(entities, service, uuid);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class EntityDto {\n");
    sb.append("    entities: ").append(toIndentedString(entities)).append("\n");
    sb.append("    service: ").append(toIndentedString(service)).append("\n");
    sb.append("    uuid: ").append(toIndentedString(uuid)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

