/*
 * # Copyright 2024-2025 NetCracker Technology Corporation
 * #
 * # Licensed under the Apache License, Version 2.0 (the "License");
 * # you may not use this file except in compliance with the License.
 * # You may obtain a copy of the License at
 * #
 * #      http://www.apache.org/licenses/LICENSE-2.0
 * #
 * # Unless required by applicable law or agreed to in writing, software
 * # distributed under the License is distributed on an "AS IS" BASIS,
 * # WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * # See the License for the specific language governing permissions and
 * # limitations under the License.
 *
 */

package org.qubership.automation.itf.ui.controls.entities.parsingrule;

import static org.qubership.automation.itf.ui.util.UIHelper.convertMapOfTypeToUITypeList;

import java.util.Map;
import java.util.UUID;

import org.qubership.automation.itf.core.model.jpa.message.parser.ParsingRule;
import org.qubership.automation.itf.core.util.helper.ClassResolver;
import org.qubership.automation.itf.ui.messages.UITypeList;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class ParsingRuleTypeController {

    @Transactional(readOnly = true)
    @PreAuthorize("@entityAccess.checkAccess("
            + "T(org.qubership.automation.itf.ui.util.UserManagementEntities).PARSING_RULE.getName(),"
            + "#projectUuid, 'READ')")
    @RequestMapping(value = "/parsingrule/types", method = RequestMethod.GET)
    public UITypeList getTypes(@RequestParam(value = "projectUuid") UUID projectUuid) {
        Map<String, String> objectParsingRuleTypes = ClassResolver.getInstance().resolveByInterface(ParsingRule.class);
        return convertMapOfTypeToUITypeList(objectParsingRuleTypes);
    }
}
