/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.integration.users;

import java.beans.ConstructorProperties;
import java.util.List;
import java.util.UUID;
import org.qubership.atp.auth.springbootstarter.entities.Project;
import org.qubership.automation.itf.integration.converter.DtoConvertService;
import org.qubership.automation.itf.integration.users.UsersProjectFeignClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class AtpUsersService {
    private static final Logger log = LoggerFactory.getLogger(AtpUsersService.class);
    private final UsersProjectFeignClient usersProjectFeignClient;
    private final DtoConvertService dtoConvertService;

    public List<Project> getAllProjects() {
        return this.dtoConvertService.convertList((List)this.usersProjectFeignClient.getAllProjects().getBody(), Project.class);
    }

    public Project getProjectUsersByProjectId(UUID projectId) {
        return this.dtoConvertService.convert(this.usersProjectFeignClient.getProjectUsersByProjectId(projectId).getBody(), Project.class);
    }

    @ConstructorProperties(value={"usersProjectFeignClient", "dtoConvertService"})
    public AtpUsersService(UsersProjectFeignClient usersProjectFeignClient, DtoConvertService dtoConvertService) {
        this.usersProjectFeignClient = usersProjectFeignClient;
        this.dtoConvertService = dtoConvertService;
    }
}

