/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.openapi.reporting.controllers;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Validated
@Tag(name="ContextController", description="Context Controller")
public interface ContextControllerApi {
    @Operation(operationId="getContextProperties", summary="getContextProperties", tags={"context-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=Object.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/context/getProperties"}, produces={"application/json"})
    public ResponseEntity<List<List<Object>>> getContextProperties(@NotNull @Parameter(name="contextId", description="contextId", required=true) @Valid @RequestParam(value="contextId", required=true) String var1, @NotNull @Parameter(name="projectUuid", description="projectUuid", required=true) @Valid @RequestParam(value="projectUuid", required=true) UUID var2);

    @Operation(operationId="getContextVariables", summary="getContextVariables", tags={"context-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="text/plain", schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/context/getContextVariables"}, produces={"text/plain"})
    public ResponseEntity<String> getContextVariables(@NotNull @Parameter(name="contextId", description="contextId", required=true) @Valid @RequestParam(value="contextId", required=true) String var1, @NotNull @Parameter(name="projectUuid", description="projectUuid", required=true) @Valid @RequestParam(value="projectUuid", required=true) UUID var2);

    @Operation(operationId="getCurrentPartitionNumbers", summary="getCurrentPartitionNumbers", tags={"context-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=Map.class))})})
    @RequestMapping(method={RequestMethod.GET}, value={"/partition/current"}, produces={"application/json"})
    public ResponseEntity<Map<String, Integer>> getCurrentPartitionNumbers();

    @Operation(operationId="getKeys", summary="getKeys", tags={"context-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/context/getKeys"}, produces={"application/json"})
    public ResponseEntity<Set<String>> getKeys(@NotNull @Parameter(name="contextId", description="contextId", required=true) @Valid @RequestParam(value="contextId", required=true) String var1, @NotNull @Parameter(name="projectUuid", description="projectUuid", required=true) @Valid @RequestParam(value="projectUuid", required=true) UUID var2);
}

