/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.ui.config;

import org.javers.core.Javers;
import org.javers.core.MappingStyle;
import org.javers.core.json.JsonTypeAdapter;
import org.javers.repository.api.JaversRepository;
import org.javers.spring.auditable.CommitPropertiesProvider;
import org.javers.spring.jpa.TransactionalJpaJaversBuilder;
import org.qubership.atp.auth.springbootstarter.entities.UserInfo;
import org.qubership.atp.auth.springbootstarter.ssl.Provider;
import org.qubership.automation.itf.ui.config.ItfJaversAuditableAspect;
import org.qubership.automation.itf.ui.config.ItfJaversSpringDataJpaAuditableRepositoryAspect;
import org.qubership.automation.itf.ui.config.JaversAuthorProvider;
import org.qubership.automation.itf.ui.config.codec.BigIntegerTypeAdapter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.orm.jpa.JpaTransactionManager;
import org.springframework.transaction.PlatformTransactionManager;

@Configuration
@ConditionalOnProperty(name={"javers.history.enabled"}, havingValue="true")
public class ItfJaversConfiguration {
    @Bean
    public JaversAuthorProvider javersAuthorProvider(Provider<UserInfo> userInfoProvider) {
        return new JaversAuthorProvider(userInfoProvider);
    }

    @Bean
    public Javers javers(JaversRepository javersRepository, JpaTransactionManager transactionManager) {
        return TransactionalJpaJaversBuilder.javers().withTxManager((PlatformTransactionManager)transactionManager).registerJaversRepository(javersRepository).withPackagesToScan("org.qubership.automation.itf.core.model.javers.history").withMappingStyle(MappingStyle.FIELD).registerValueTypeAdapter((JsonTypeAdapter)new BigIntegerTypeAdapter()).build();
    }

    @Bean
    public ItfJaversSpringDataJpaAuditableRepositoryAspect javersSpringDataAuditableAspect(Javers javers, JaversAuthorProvider javersAuthorProvider, CommitPropertiesProvider commitPropertiesProvider) {
        return new ItfJaversSpringDataJpaAuditableRepositoryAspect(javers, javersAuthorProvider, commitPropertiesProvider);
    }

    @Bean
    public ItfJaversAuditableAspect javersAuditableAspect(Javers javers, JaversAuthorProvider javersAuthorProvider, CommitPropertiesProvider commitPropertiesProvider) {
        return new ItfJaversAuditableAspect(javers, javersAuthorProvider, commitPropertiesProvider);
    }
}

