/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.ui.config;

import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Aspect;
import org.javers.core.Javers;
import org.javers.spring.auditable.AspectUtil;
import org.javers.spring.auditable.AuthorProvider;
import org.javers.spring.auditable.CommitPropertiesProvider;
import org.qubership.automation.itf.core.model.common.Storable;
import org.qubership.automation.itf.ui.config.ItfAbstractSpringAuditableRepositoryAspect;
import org.qubership.automation.itf.ui.services.javers.history.HistoryEntityHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;

@Aspect
@Order(value=0)
public class ItfJaversSpringDataJpaAuditableRepositoryAspect
extends ItfAbstractSpringAuditableRepositoryAspect {
    private static final Logger log = LoggerFactory.getLogger(ItfJaversSpringDataJpaAuditableRepositoryAspect.class);
    private static final String NOT_IMPLEMENTED_MESSAGE = "This aspect isn't implemented yet";

    public ItfJaversSpringDataJpaAuditableRepositoryAspect(Javers javers, AuthorProvider authorProvider, CommitPropertiesProvider commitPropertiesProvider) {
        super(javers, authorProvider, commitPropertiesProvider);
    }

    @AfterReturning(value="execution(public * delete(..)) && this(org.springframework.data.repository.CrudRepository)")
    public void onDeleteExecuted(JoinPoint pjp) {
        for (Object deletedObject : AspectUtil.collectArguments((JoinPoint)pjp)) {
            if (!(deletedObject instanceof Storable)) continue;
            try {
                if (HistoryEntityHelper.isNotSupportEntity(deletedObject.getClass())) {
                    log.debug("Entity with type {} is skipped, because it isn't supported in itf history.", (Object)deletedObject.getClass().getName());
                    return;
                }
                if (!this.isHistoryEnabled(deletedObject)) {
                    log.debug("Project setting 'enable.history.versioning' for project id {} is disabled, so history commit is skipped.", (Object)((Storable)deletedObject).getProjectId());
                    return;
                }
                this.deleteHistoryEntity(((Storable)deletedObject).getID(), deletedObject.getClass());
            }
            catch (Exception e) {
                log.error("An error occurred while object history processing for type {}.", deletedObject.getClass(), (Object)e);
            }
        }
    }

    @AfterReturning(value="execution(public * deleteById(..)) && this(org.springframework.data.repository.CrudRepository)")
    public void onDeleteByIdExecuted(JoinPoint pjp) {
        log.error(NOT_IMPLEMENTED_MESSAGE);
    }

    @AfterReturning(value="execution(public * deleteAll(..)) && this(org.springframework.data.repository.CrudRepository)")
    public void onDeleteAllExecuted(JoinPoint pjp) {
        log.error(NOT_IMPLEMENTED_MESSAGE);
    }

    @AfterReturning(value="execution(public * save(..)) && this(org.springframework.data.repository.CrudRepository)", returning="responseEntity")
    public void onSaveExecuted(JoinPoint pjp, Object responseEntity) {
        this.processOnSave(pjp, responseEntity, false);
    }

    @AfterReturning(value="execution(public * saveAll(..)) && this(org.springframework.data.repository.CrudRepository)", returning="responseEntity")
    public void onSaveAllExecuted(JoinPoint pjp, Object responseEntity) {
        log.error(NOT_IMPLEMENTED_MESSAGE);
    }

    @AfterReturning(value="execution(public * saveAndFlush(..)) && this(org.springframework.data.jpa.repository.JpaRepository)", returning="responseEntity")
    public void onSaveAndFlushExecuted(JoinPoint pjp, Object responseEntity) {
        log.error(NOT_IMPLEMENTED_MESSAGE);
    }

    @AfterReturning(value="execution(public * deleteInBatch(..)) && this(org.springframework.data.jpa.repository.JpaRepository)")
    public void onDeleteInBatchExecuted(JoinPoint pjp) {
        log.error(NOT_IMPLEMENTED_MESSAGE);
    }
}

