/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.ui.controls;

import java.math.BigInteger;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.qubership.atp.integration.configuration.configuration.AuditAction;
import org.qubership.automation.itf.core.hibernate.spring.managers.custom.IDataSetListManager;
import org.qubership.automation.itf.core.model.common.Named;
import org.qubership.automation.itf.core.model.common.Storable;
import org.qubership.automation.itf.core.model.dataset.DataSetList;
import org.qubership.automation.itf.core.model.dataset.DataSetListsSource;
import org.qubership.automation.itf.core.model.dataset.IDataSet;
import org.qubership.automation.itf.core.model.jpa.callchain.CallChain;
import org.qubership.automation.itf.core.model.jpa.context.JsonContext;
import org.qubership.automation.itf.core.model.testcase.AbstractTestCase;
import org.qubership.automation.itf.core.util.manager.CoreObjectManager;
import org.qubership.automation.itf.ui.controls.util.ControllerHelper;
import org.qubership.automation.itf.ui.messages.UIList;
import org.qubership.automation.itf.ui.messages.objects.UIDataSet;
import org.qubership.automation.itf.ui.messages.objects.UIDataSetList;
import org.qubership.automation.itf.ui.messages.objects.UIDataSetParameter;
import org.qubership.automation.itf.ui.messages.objects.UIDataSetParametersGroup;
import org.qubership.automation.itf.ui.messages.objects.UIObject;
import org.qubership.automation.itf.ui.util.UIHelper;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class DatasetController
extends UIHelper {
    private static final Function<DataSetList, UIDataSetList> UI_DS_LIST_FUNC = UIDataSetList::new;
    private static ConcurrentHashMap<String, Set<DataSetList>> dataSetListsHolder = new ConcurrentHashMap();

    @Transactional(readOnly=true)
    @PreAuthorize(value="@entityAccess.checkAccess(#projectUuid, \"READ\")")
    @RequestMapping(value={"/datasetlists"}, method={RequestMethod.GET})
    @AuditAction(auditAction="Get Dataset Lists for project {{#projectUuid}}")
    public UIList<UIObject> getLists(@RequestParam(value="projectUuid") UUID projectUuid) {
        Collection dataSetLists = ((IDataSetListManager)CoreObjectManager.getInstance().getSpecialManager(DataSetList.class, IDataSetListManager.class)).getAllSources((Object)projectUuid);
        if (Objects.isNull(dataSetLists)) {
            return null;
        }
        return DatasetController.getObjectList(dataSetLists.stream().sorted(Comparator.comparing(Named::getName)).collect(Collectors.toList()));
    }

    @Transactional(readOnly=true)
    @PreAuthorize(value="@entityAccess.checkAccess(#projectUuid, \"READ\")")
    @RequestMapping(value={"/datasetlist"}, method={RequestMethod.GET})
    @AuditAction(auditAction="Get all Dataset Lists by VA id {{#id}} in the project {{#projectUuid}}")
    public UIList<UIDataSetList> getList(@RequestParam(value="source", required=false) String id, @RequestParam(value="projectUuid") UUID projectUuid) throws Exception {
        IDataSetListManager man = (IDataSetListManager)CoreObjectManager.getInstance().getSpecialManager(DataSetList.class, IDataSetListManager.class);
        DataSetListsSource lists = man.getSourceById((Object)id, (Object)projectUuid);
        if (lists == null) {
            return null;
        }
        return DatasetController.getUIList(lists.getDataSetLists().stream().sorted(Comparator.comparing(Named::getName)).collect(Collectors.toList()), UI_DS_LIST_FUNC::apply);
    }

    @Transactional(readOnly=true)
    @PreAuthorize(value="@entityAccess.checkAccess(#projectUuid, \"READ\")")
    @RequestMapping(value={"/dataset/all"}, method={RequestMethod.GET})
    @AuditAction(auditAction="Get all Datasets under Sources '{{#sources}}' in the project {{#projectUuid}}")
    public String getAllDatasets(@RequestParam(value="sources", defaultValue="") String sources, @RequestParam(value="projectUuid") UUID projectUuid) {
        JSONObject result = new JSONObject();
        JSONArray datasets = new JSONArray();
        DataSetListsSource dataSetListsSources = ((IDataSetListManager)CoreObjectManager.getInstance().getManager(DataSetList.class)).getSourceById((Object)sources, (Object)projectUuid);
        Set dataSetLists = dataSetListsSources.getDataSetLists();
        for (DataSetList dataSetList : dataSetLists) {
            for (IDataSet dataSet : dataSetList.getDataSets((Object)projectUuid)) {
                final String groupName = dataSetList.getName();
                final String datasetName = dataSet.getName();
                final String displayName = String.format("[%s] %s", groupName, datasetName);
                datasets.add((Object)new JSONObject(){
                    {
                        this.put("groupName", groupName);
                        this.put("datasetName", datasetName);
                        this.put("name", displayName);
                    }
                });
            }
        }
        dataSetListsHolder.put("dataSetLists", dataSetLists);
        result.put((Object)"datasets", (Object)datasets);
        return result.toJSONString();
    }

    @Transactional(readOnly=true)
    @PreAuthorize(value="@entityAccess.checkAccess(#projectUuid, \"READ\")")
    @RequestMapping(value={"/datasetsources/all"}, method={RequestMethod.GET})
    @AuditAction(auditAction="Get all DSLs and Datasets in the project {{#projectUuid}}")
    public String getAllDatalists(@RequestParam(value="projectUuid") UUID projectUuid) {
        JSONObject result = new JSONObject();
        JSONArray datasets = new JSONArray();
        Collection dataSetListsSources = ((IDataSetListManager)CoreObjectManager.getInstance().getSpecialManager(DataSetList.class, IDataSetListManager.class)).getAllSources((Object)projectUuid);
        dataSetListsSources.forEach(dataSetListsSource -> datasets.add((Object)new JSONObject((DataSetListsSource)dataSetListsSource){
            final /* synthetic */ DataSetListsSource val$dataSetListsSource;
            {
                this.val$dataSetListsSource = dataSetListsSource;
                this.put("naturalId", this.val$dataSetListsSource.getNaturalId().toString());
                this.put("name", this.val$dataSetListsSource.getName());
            }
        }));
        result.put((Object)"datasets", (Object)datasets);
        return result.toJSONString();
    }

    @Transactional(readOnly=true)
    @PreAuthorize(value="@entityAccess.checkAccess(#projectUuid, \"READ\")")
    @RequestMapping(value={"/dataset/read/debug"}, method={RequestMethod.GET})
    @AuditAction(auditAction="Read dataset with name {{#datasetName}} for debug, project {{#projectUuid}}")
    public JsonContext readDatasetForDebugger(@RequestParam(value="name", defaultValue="") String datasetName, @RequestParam(value="projectUuid") UUID projectUuid, @RequestParam(value="projectId") BigInteger projectId) {
        JsonContext result = null;
        Set<DataSetList> dataSetLists = dataSetListsHolder.get("dataSetLists");
        if (CollectionUtils.isNotEmpty(dataSetLists)) {
            for (DataSetList dataSetList : dataSetLists) {
                IDataSet dataSet = dataSetList.getDataSet(datasetName, (Object)projectId);
                if (dataSet == null) continue;
                result = dataSet.read((Object)projectId);
                break;
            }
        }
        return result;
    }

    @Transactional(readOnly=true)
    @PreAuthorize(value="@entityAccess.checkAccess(#projectUuid, \"READ\")")
    @RequestMapping(value={"/dataset/read"}, method={RequestMethod.GET})
    @AuditAction(auditAction="Read dataset with name {{#datasetName}}, for Entity id {{#entityId}} and type {{#entityType}}, project {{#projectUuid}}")
    public UIDataSet readDataset(@RequestParam(value="name", defaultValue="") String datasetName, @RequestParam(value="entity", defaultValue="") String entityId, @RequestParam(value="type", defaultValue="") String entityType, @RequestParam(value="projectUuid") UUID projectUuid, @RequestParam(value="projectId") BigInteger projectId) {
        if (datasetName != null) {
            AbstractTestCase entity = (AbstractTestCase)CoreObjectManager.getInstance().getManager(CallChain.class).getById((Object)entityId);
            ControllerHelper.throwExceptionIfNull((Storable)entity, null, entityId, CallChain.class, "get callchain by id");
            for (DataSetList dataSetList : entity.getCompatibleDataSetLists((Object)projectUuid)) {
                JsonContext datasetContent;
                IDataSet dataSet = dataSetList.getDataSet(datasetName, (Object)projectId);
                if (dataSet == null || (datasetContent = dataSet.read((Object)projectId)) == null) continue;
                UIDataSet uiDataSet = new UIDataSet();
                HashSet<UIDataSetParametersGroup> dataSetParametersGroup = new HashSet<UIDataSetParametersGroup>();
                LinkedHashSet<UIDataSetParameter> ungroupedDatasetParameters = new LinkedHashSet<UIDataSetParameter>();
                for (Object o : datasetContent.entrySet()) {
                    Map.Entry entry = (Map.Entry)o;
                    UIDataSetParametersGroup parametersGroup = new UIDataSetParametersGroup();
                    if (!(entry.getValue() instanceof Map)) {
                        this.processParameter(entry.getValue(), (String)entry.getKey(), ungroupedDatasetParameters);
                        continue;
                    }
                    parametersGroup.setName((String)entry.getKey());
                    LinkedHashSet<UIDataSetParameter> datasetParameters = new LinkedHashSet<UIDataSetParameter>();
                    datasetParameters.add(new UIDataSetParameter("", ""));
                    for (Map.Entry parameter : ((Map)entry.getValue()).entrySet()) {
                        this.processParameter(parameter.getValue(), (String)parameter.getKey(), datasetParameters);
                    }
                    parametersGroup.setDataSetParameter(datasetParameters);
                    dataSetParametersGroup.add(parametersGroup);
                }
                if (!ungroupedDatasetParameters.isEmpty()) {
                    UIDataSetParametersGroup ungroupedParametersGroup = new UIDataSetParametersGroup();
                    ungroupedParametersGroup.setName("Autogenerated_No_Group");
                    ungroupedParametersGroup.setDataSetParameter(ungroupedDatasetParameters);
                    dataSetParametersGroup.add(ungroupedParametersGroup);
                }
                uiDataSet.setDataSetParametersGroup(dataSetParametersGroup);
                return uiDataSet;
            }
        }
        return null;
    }

    private void processParameter(Object value, String key, Set<UIDataSetParameter> datasetParameters) {
        if (value instanceof JSONArray) {
            int indx = 0;
            for (Object arrayValue : (JSONArray)value) {
                datasetParameters.add(new UIDataSetParameter(key + "[" + indx++ + "]", (String)arrayValue));
            }
        } else {
            datasetParameters.add(new UIDataSetParameter(key, (String)value));
        }
    }
}

