/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.ui.controls;

import java.beans.ConstructorProperties;
import java.math.BigInteger;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang3.time.DurationFormatUtils;
import org.json.simple.JSONObject;
import org.qubership.atp.integration.configuration.configuration.AuditAction;
import org.qubership.automation.itf.core.message.TcContextOperationMessage;
import org.qubership.automation.itf.core.model.jpa.context.TcContext;
import org.qubership.automation.itf.core.model.jpa.context.TcContextBriefInfo;
import org.qubership.automation.itf.core.model.jpa.instance.chain.CallChainInstance;
import org.qubership.automation.itf.core.util.config.Config;
import org.qubership.automation.itf.core.util.constants.Status;
import org.qubership.automation.itf.core.util.manager.CoreObjectManager;
import org.qubership.automation.itf.executor.cache.service.CacheServices;
import org.qubership.automation.itf.executor.service.ExecutionServices;
import org.qubership.automation.itf.executor.service.ExecutorToMessageBrokerSender;
import org.qubership.automation.itf.executor.service.ProjectSettingsService;
import org.qubership.automation.itf.ui.messages.UIIds;
import org.qubership.automation.itf.ui.messages.monitoring.UIGetReportList;
import org.qubership.automation.itf.ui.messages.objects.UIReportItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class MonitoringController {
    private static final Logger log = LoggerFactory.getLogger(MonitoringController.class);
    private static final String DATE_FORMAT = Config.getConfig().getString("log.appender.date.format");
    private static final DateTimeFormatter dateFormatter = DateTimeFormatter.ofPattern(DATE_FORMAT).withZone(ZoneId.systemDefault());
    private final ExecutorToMessageBrokerSender executorToMessageBrokerSender;
    private final ProjectSettingsService projectSettingsService;

    public static UIReportItem buildUIReportItem(TcContext item) {
        return MonitoringController.buildUIReportItem(new TcContextBriefInfo(item));
    }

    private static UIReportItem buildUIReportItem(TcContextBriefInfo item) {
        UIReportItem uiReportItem = new UIReportItem();
        uiReportItem.setId(item.getId().toString());
        uiReportItem.setName(item.getName());
        uiReportItem.setEnvironment(item.getEnvironment() != null ? item.getEnvname() : "Environment not set");
        uiReportItem.setInitiator(item.getInitiator() != null ? item.getIniname() : "Initiator not set");
        uiReportItem.setStatus(item.getStatus().toString());
        uiReportItem.setStartTime(item.getStartTime() == null ? "" : item.getStartTime().toInstant().atZone(ZoneId.systemDefault()).format(dateFormatter));
        uiReportItem.setEndTime(item.getEndTime() == null ? "" : item.getEndTime().toInstant().atZone(ZoneId.systemDefault()).format(dateFormatter));
        uiReportItem.setDuration(item.getDuration() == null ? "" : DurationFormatUtils.formatDuration((long)Long.parseLong(item.getDuration().toString()), (String)"HH:mm:ss", (boolean)true));
        uiReportItem.setClient(item.getClient());
        return uiReportItem;
    }

    @Transactional
    @PreAuthorize(value="@entityAccess.checkAccess(#projectUuid, \"UPDATE\")")
    @RequestMapping(value={"/monitoring/page/size"}, method={RequestMethod.POST})
    @AuditAction(auditAction="Set page size to {{#size}} for project {{#projectId}}/{{#projectUuid}}")
    public void setPageSize(@RequestParam String size, @RequestParam(value="projectId") BigInteger projectId, @RequestParam(value="projectUuid") UUID projectUuid) {
        this.projectSettingsService.update((Object)projectId, "monitoring.pagination.size", size, true);
        log.info("Parameter value is changed for project [{}]: '{}'={}", new Object[]{projectId, "monitoring.pagination.size", size});
    }

    @Transactional(readOnly=true)
    @PreAuthorize(value="@entityAccess.checkAccess(#projectUuid, \"READ\")")
    @RequestMapping(value={"/monitoring/page/size"}, method={RequestMethod.GET})
    @AuditAction(auditAction="Get page size for project {{#projectId}}/{{#projectUuid}}")
    public int getPageSize(@RequestParam(value="projectId") BigInteger projectId, @RequestParam(value="projectUuid") UUID projectUuid) {
        return this.projectSettingsService.getInt((Object)projectId, "monitoring.pagination.size", 20);
    }

    @Deprecated
    @Transactional
    @PreAuthorize(value="@entityAccess.checkAccess(#projectUuid, \"EXECUTE\")")
    @RequestMapping(value={"/monitoring/setcontext"}, method={RequestMethod.POST}, consumes={"application/json"}, headers={"Accept=application/json"})
    @AuditAction(auditAction="Merge context into tc-context id {{#contextId}} in the project {{#projectUuid}}")
    public void setContext(@RequestParam(value="contextId") String contextId, @RequestBody JSONObject context, @RequestParam(value="projectUuid") UUID projectUuid) throws Exception {
        TcContext tcContext = (TcContext)CoreObjectManager.getInstance().getManager(TcContext.class).getById((Object)contextId);
        if (tcContext.getInitiator() == null || !(tcContext.getInitiator() instanceof CallChainInstance)) {
            throw new IllegalArgumentException(String.format("Context ID=%s: initiator is NOT a callchain;  Update is cancelled", contextId));
        }
        tcContext.merge((Map)context);
        CacheServices.getTcBindingCacheService().bind(tcContext);
        ExecutionServices.getExecutionProcessManagerService().updateContext(tcContext);
        tcContext.store();
    }

    @Transactional
    @PreAuthorize(value="@entityAccess.checkAccess(#projectUuid, \"EXECUTE\")")
    @RequestMapping(value={"/monitoring/terminateContexts"}, method={RequestMethod.POST})
    @AuditAction(auditAction="Terminate contexts for project {{#projectUuid}}")
    public void terminate(@RequestBody UIIds ids, @RequestParam(value="projectUuid") UUID projectUuid, @RequestHeader(value="X-Project-Id") String tenantId) {
        for (String id : ids.getIds()) {
            ExecutionServices.getTCContextService().stop(new BigInteger(id), tenantId);
        }
    }

    @Transactional(readOnly=true)
    @PreAuthorize(value="@entityAccess.checkAccess(#projectUuid, \"EXECUTE\")")
    @RequestMapping(value={"/monitoring/context/pauseResume"}, method={RequestMethod.POST})
    @AuditAction(auditAction="Do '{{#action}}' action for contexts in the project {{#projectUuid}}")
    public UIGetReportList pauseResumeContext(@RequestParam(value="action") String action, @RequestBody UIIds uiIds, @RequestParam(value="projectUuid") UUID projectUuid, @RequestHeader(value="X-Project-Id") String tenantId) {
        Status newStatus;
        if (action == null) {
            throw new IllegalArgumentException("Parameter 'action' (values are pause or resume) is null or missed");
        }
        if (action.equalsIgnoreCase("pause")) {
            newStatus = Status.PAUSED;
        } else if (action.equalsIgnoreCase("resume")) {
            newStatus = Status.IN_PROGRESS;
        } else {
            throw new IllegalArgumentException(String.format("Parameter 'action' (values are pause or resume) value is incorrect: '%s'", action));
        }
        UIGetReportList result = new UIGetReportList();
        for (String id : uiIds.getIds()) {
            this.executorToMessageBrokerSender.sendMessageToTcContextOperationsTopic((Object)new TcContextOperationMessage(newStatus.name(), new BigInteger(id)), tenantId);
            result.getReportItems().add(MonitoringController.buildUIReportItem(CacheServices.getTcContextCacheService().getById((Object)new BigInteger(id))));
        }
        return result;
    }

    @ConstructorProperties(value={"executorToMessageBrokerSender", "projectSettingsService"})
    public MonitoringController(ExecutorToMessageBrokerSender executorToMessageBrokerSender, ProjectSettingsService projectSettingsService) {
        this.executorToMessageBrokerSender = executorToMessageBrokerSender;
        this.projectSettingsService = projectSettingsService;
    }
}

