/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.ui.controls;

import java.math.BigInteger;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.hibernate.JDBCException;
import org.json.simple.parser.ParseException;
import org.qubership.atp.integration.configuration.configuration.AuditAction;
import org.qubership.automation.itf.core.hibernate.spring.managers.custom.SearchManager;
import org.qubership.automation.itf.core.model.jpa.context.InstanceContext;
import org.qubership.automation.itf.core.model.jpa.context.JsonContext;
import org.qubership.automation.itf.core.model.jpa.context.SpContext;
import org.qubership.automation.itf.core.model.jpa.context.TcContext;
import org.qubership.automation.itf.core.model.jpa.project.StubProject;
import org.qubership.automation.itf.core.util.engine.TemplateEngineFactory;
import org.qubership.automation.itf.core.util.manager.CoreObjectManager;
import org.qubership.automation.itf.executor.cache.service.CacheServices;
import org.qubership.automation.itf.integration.reports.ReportsService;
import org.qubership.automation.itf.ui.messages.objects.ResponseObject;
import org.qubership.automation.itf.ui.messages.objects.UIVelocityRequestBody;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class VelocityController {
    private final ReportsService reportsService;

    @Autowired
    public VelocityController(ReportsService reportsService) {
        this.reportsService = reportsService;
    }

    @Transactional
    @PreAuthorize(value="@entityAccess.checkAccess(#projectUuid, \"READ\")")
    @PutMapping(value={"/velocity"}, produces={"application/json"})
    @AuditAction(auditAction="Parse velocity content, project {{#projectId}}/{{#projectUuid}}")
    public ResponseObject parseContent(@RequestBody UIVelocityRequestBody requestBody, @RequestParam(value="projectId", required=false) BigInteger projectId, @RequestParam(value="projectUuid") UUID projectUuid) throws ParseException, IllegalAccessException, InstantiationException {
        if (projectId == null && (projectId = ((SearchManager)CoreObjectManager.getInstance().getSpecialManager(StubProject.class, SearchManager.class)).getEntityInternalIdByUuid(projectUuid)) == null) {
            ResponseObject responseObject = new ResponseObject();
            responseObject.setResponse(String.format("Can't find project by uuid = %s", projectUuid));
            return responseObject;
        }
        String context = requestBody.getContext();
        String message = requestBody.getMessage();
        String process = "";
        try {
            TcContext tcContext;
            if (StringUtils.isBlank((CharSequence)context)) {
                tcContext = new TcContext();
            } else {
                List<Object[]> contextProperties = this.reportsService.getContextProperties(context, projectUuid);
                if (contextProperties == null || contextProperties.isEmpty()) {
                    tcContext = CacheServices.getTcBindingCacheService().findByKey(context, false, projectId, projectUuid);
                    if (tcContext == null) {
                        tcContext = new TcContext();
                    }
                } else {
                    tcContext = (TcContext)JsonContext.fromJson((String)contextProperties.get(0)[7].toString(), TcContext.class);
                }
            }
            if (tcContext.getProjectId() == null) {
                tcContext.setProjectId(projectId);
                tcContext.setProjectUuid(projectUuid);
            }
            SpContext sp = new SpContext();
            Object saved = tcContext.get((Object)"saved");
            if (saved instanceof Map) {
                sp.putAll((Map)saved);
            }
            InstanceContext instanceContext = InstanceContext.from((TcContext)tcContext, (SpContext)sp);
            process = process + TemplateEngineFactory.process(null, (String)message, (JsonContext)instanceContext);
        }
        catch (Exception e) {
            process = this.processException(e);
        }
        ResponseObject responseObject = new ResponseObject();
        responseObject.setResponse(process);
        return responseObject;
    }

    @Transactional
    @PreAuthorize(value="@entityAccess.checkAccess(#projectUuid, \"READ\")")
    @RequestMapping(value={"/velocity/processTemplate"}, method={RequestMethod.PUT})
    @AuditAction(auditAction="Process velocity template, project {{#projectId}}/{{#projectUuid}}")
    public ResponseObject processTemplate(@RequestBody UIVelocityRequestBody requestBody, @RequestParam(value="projectId") BigInteger projectId, @RequestParam(value="projectUuid") UUID projectUuid) throws ParseException, IllegalAccessException, InstantiationException {
        String result;
        String tcContextStr = requestBody.getTc();
        String spContextStr = requestBody.getSp();
        if (tcContextStr == null && spContextStr == null) {
            return this.parseContent(requestBody, projectId, projectUuid);
        }
        String templateBody = requestBody.getMessage();
        try {
            InstanceContext context = new InstanceContext();
            TcContext tcContext = null;
            if (tcContextStr != null) {
                tcContext = (TcContext)TcContext.fromJson((String)tcContextStr, TcContext.class);
                if (projectId != null) {
                    tcContext.setProjectId(projectId);
                    tcContext.setProjectUuid(projectUuid);
                }
                context.setTC(tcContext);
            }
            if (spContextStr != null) {
                Object saved;
                SpContext spContext = (SpContext)SpContext.fromJson((String)spContextStr, SpContext.class);
                if (tcContext != null && (saved = tcContext.get((Object)"saved")) instanceof Map) {
                    spContext.putAll((Map)saved);
                }
                context.setSP(spContext);
            }
            result = TemplateEngineFactory.process(null, (String)templateBody, (JsonContext)context);
        }
        catch (Exception e) {
            result = this.processException(e);
        }
        ResponseObject response = new ResponseObject();
        response.setResponse(result);
        return response;
    }

    private String processException(Throwable ex) {
        Throwable cause = ex.getCause();
        if (cause == null) {
            return ExceptionUtils.getMessage((Throwable)ex) + (ex instanceof ParseException ? ex.toString() : "");
        }
        if (cause instanceof JDBCException) {
            throw new RuntimeException(ex.getMessage() + "\nCaused by: " + ((JDBCException)cause).getSQLException().getMessage());
        }
        if (cause instanceof DataAccessException) {
            throw new RuntimeException(ex.getMessage() + "\nCaused by: " + ((DataAccessException)cause).getMessage() + (cause.getCause() != null && cause.getCause() instanceof JDBCException ? "\nCaused by: " + ((JDBCException)cause.getCause()).getSQLException().getMessage() : ""));
        }
        if (cause instanceof RuntimeException) {
            return this.processException(cause);
        }
        return ExceptionUtils.getMessage((Throwable)ex);
    }
}

