/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.ui.controls.common;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.qubership.atp.multitenancy.core.context.TenantContext;
import org.qubership.automation.itf.core.exceptions.operation.NotActualVersionException;
import org.qubership.automation.itf.core.hibernate.spring.managers.base.ObjectManager;
import org.qubership.automation.itf.core.model.common.Storable;
import org.qubership.automation.itf.core.model.usage.UsageInfo;
import org.qubership.automation.itf.ui.controls.common.AbstractStorableController;
import org.qubership.automation.itf.ui.controls.common.EntityController;
import org.qubership.automation.itf.ui.controls.util.ControllerHelper;
import org.qubership.automation.itf.ui.messages.UIIds;
import org.qubership.automation.itf.ui.messages.objects.UIECIObject;
import org.qubership.automation.itf.ui.messages.objects.UIObject;
import org.qubership.automation.itf.ui.messages.objects.UIResult;
import org.qubership.automation.itf.ui.messages.objects.parents.UIIdentifiedObject;
import org.qubership.automation.itf.ui.messages.objects.parents.UINamedObject;
import org.qubership.automation.itf.ui.util.UIHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;

public abstract class AbstractController<T extends UIObject, U extends Storable>
extends AbstractStorableController<U>
implements EntityController<T> {
    protected static final Logger LOGGER = LoggerFactory.getLogger(AbstractController.class);
    private boolean isSimple = false;
    @Value(value="${atp.multi-tenancy.enabled}")
    private Boolean isMultiTenant;

    @Override
    public List<? extends UIObject> getAll() {
        return this.asListUIObject(this.isMultiTenant != false ? this.getAllPerCluster() : this.manager().getAll(), false, this.isSimple, new String[0]);
    }

    private Collection<? extends U> getAllPerCluster() {
        ArrayList allTenantObjectsList = new ArrayList();
        for (String tenantId : TenantContext.getTenantIds((boolean)true)) {
            TenantContext.setTenantInfo((String)tenantId);
            Collection allObjectsList = this.manager().getAll();
            allTenantObjectsList.addAll(allObjectsList);
        }
        TenantContext.setDefaultTenantInfo();
        allTenantObjectsList.addAll(this.manager().getAll());
        return allTenantObjectsList;
    }

    public List<UIECIObject> getAllWithEciParams() {
        ArrayList<UIECIObject> uiEciObjects = new ArrayList<UIECIObject>();
        Collection collection = this.isMultiTenant != false ? this.getAllPerCluster() : this.manager().getAll();
        for (Storable object : collection) {
            uiEciObjects.add(new UIECIObject(object));
        }
        return uiEciObjects;
    }

    @Override
    public List<? extends UIObject> getAll(String parentId) {
        if (Objects.nonNull(parentId)) {
            return this.asListUIObject(this.manager().getAllByParentId((Object)parentId), false, this.isSimple, new String[0]);
        }
        return this.getAll();
    }

    @Override
    public T getById(String id) {
        U object = ControllerHelper.get(id, this._getGenericUClass());
        return this._newInstanceTClass(object);
    }

    @Override
    public T create(String parentId) {
        return this.create(this._getParent(parentId));
    }

    @Override
    public T create(Storable parent) {
        Storable object = this.manager().create(parent);
        object.setName("New " + object.getClass().getSimpleName());
        LOGGER.info("Storable {} is created", (Object)object);
        object.store();
        object.flush();
        return this._newInstanceTClass(object);
    }

    @Override
    public T create(String parentId, BigInteger projectId) {
        Storable object = this.manager().create(this._getParent(parentId));
        object.setName("New " + object.getClass().getSimpleName());
        object.setProjectId(projectId);
        LOGGER.info("Storable {} is created", (Object)object);
        object.store();
        object.flush();
        return this._newInstanceTClass(object);
    }

    @Override
    public T create(String parentId, String name, String type, String description, List<String> labels) {
        Storable object = this.manager().create(this._getParent(parentId), name, type, description, labels);
        object.setName("New " + object.getClass().getSimpleName());
        LOGGER.info("Storable {} is created", (Object)object);
        object.store();
        object.flush();
        return this._newInstanceTClass(object);
    }

    @Override
    public T create(String parentId, String type) {
        Storable object = this.manager().create(this._getParent(parentId), type);
        object.setName("New " + object.getClass().getSimpleName());
        LOGGER.info("Storable {} is created", (Object)object);
        object.store();
        object.flush();
        return this._newInstanceTClass(object);
    }

    @Override
    public T create(String parentId, String name, String type) {
        Storable object = this.manager().create(this._getParent(parentId), name, type);
        LOGGER.info("Storable {} is created", (Object)object);
        object.store();
        object.flush();
        return this._newInstanceTClass(object);
    }

    @Override
    public T update(T uiObject) {
        return this.updateUIObject(this.manager().getById((Object)((UIIdentifiedObject)uiObject).getId()), uiObject);
    }

    protected T updateUIObject(U object, T uiObject) {
        this.beforeStoreUpdated(object, uiObject);
        return this.storeUpdated(object, uiObject);
    }

    protected void beforeStoreUpdated(U object, T uiObject) {
        ControllerHelper.throwExceptionIfNull(object, ((UINamedObject)uiObject).getName(), ((UIIdentifiedObject)uiObject).getId(), this._getGenericUClass());
        this.checkVersion(object, uiObject);
        UIHelper.updateObject(uiObject, object);
        this._beforeUpdate(uiObject, object);
    }

    protected void checkVersion(U object, T uiObject) {
        if (!((UIObject)uiObject).calcIsVersionActual((Storable)object)) {
            throw new NotActualVersionException(((UINamedObject)uiObject).getName(), String.valueOf(((UIObject)uiObject).getVersion()), String.valueOf(object.getVersion()));
        }
    }

    protected T storeUpdated(U object, T uiObject) {
        object.store();
        object.flush();
        uiObject = this._newInstanceTClass(object);
        return uiObject;
    }

    @Override
    public UIResult update(List<T> uiObjects) {
        return null;
    }

    @Override
    public List<UIObject> delete(UIIds objectsToDelete) {
        ArrayList<UIObject> uiObjects = new ArrayList<UIObject>();
        for (String string : objectsToDelete.getIds()) {
            Storable object = this.manager().getById((Object)string);
            uiObjects.add(new UIObject(object));
            this.delete(object);
            LOGGER.info("Storable {} is deleted", (Object)object);
        }
        return uiObjects;
    }

    @Override
    public void delete(Collection<T> objectsToDelete) {
        for (UIObject uiObject : objectsToDelete) {
            this.delete(this.manager().getById((Object)uiObject.getId()));
        }
    }

    public void setSimple(boolean simple) {
        this.isSimple = simple;
    }

    public void delete(U object) {
        if (object != null) {
            this._deleteSubObjects(object);
            object.remove();
        }
    }

    protected List<? extends UIObject> getAllSuitable(String parentId, String ... param) {
        if (Objects.nonNull(parentId)) {
            return this.asListUIObject(this.manager().getAllByParentId((Object)parentId), true, this.isSimple, param);
        }
        ArrayList<U> allObjects = new ArrayList<U>();
        if (this.isMultiTenant.booleanValue()) {
            allObjects.addAll(this.getAllPerCluster());
            return this.asListUIObject(allObjects, false, this.isSimple, param);
        }
        allObjects.addAll(this.manager().getAll());
        return this.asListUIObject(allObjects, false, this.isSimple, param);
    }

    protected List<? extends UIObject> getAllSimple() {
        ArrayList<U> allObjects = new ArrayList<U>();
        if (this.isMultiTenant.booleanValue()) {
            allObjects.addAll(this.getAllPerCluster());
            return this.asListUIObject(allObjects, false, this.isSimple, new String[0]);
        }
        allObjects.addAll(this.manager().getAll());
        return this.asListUIObject(allObjects, false, this.isSimple, new String[0]);
    }

    protected List<List<UIObject>> delete(Boolean ignoreUsages, UIIds objectsToDelete) {
        ArrayList<UIObject> deletedUiObjects = new ArrayList<UIObject>();
        ArrayList<UIObject> usedUiObjects = new ArrayList<UIObject>();
        HashMap result = Maps.newHashMap();
        for (String string : objectsToDelete.getIds()) {
            Storable uiObject = this.manager().getById((Object)string);
            if (this.haveUsages(uiObject, result, ignoreUsages)) {
                usedUiObjects.add(new UIObject(uiObject));
                continue;
            }
            deletedUiObjects.add(new UIObject(uiObject));
            this.delete(uiObject);
            LOGGER.info("Storable {} is deleted", (Object)uiObject);
        }
        ArrayList<List<UIObject>> allObjects = new ArrayList<List<UIObject>>();
        allObjects.add(deletedUiObjects);
        allObjects.add(usedUiObjects);
        return allObjects;
    }

    protected U _beforeUpdate(T uiObject, U object) {
        return object;
    }

    protected void _deleteSubObjects(U object) {
    }

    protected boolean _isObjectSuitable(U object, String ... param) {
        return true;
    }

    protected ObjectManager<U> manager() {
        return ControllerHelper.getManager(this._getGenericUClass());
    }

    protected abstract Class<U> _getGenericUClass();

    protected abstract T _newInstanceTClass(U var1);

    protected abstract Storable _getParent(String var1);

    private UIObject newInstanceTClass(boolean isAdded, boolean isSimple, U object) {
        if (isAdded) {
            if (isSimple) {
                return new UIObject((Storable)object, false);
            }
            return this._newInstanceTClass(object);
        }
        return null;
    }

    public List<? extends UIObject> asListUIObject(Collection<? extends U> collection, boolean checkSuitable, boolean isSimple, String ... param) {
        ArrayList arrayList = Lists.newArrayListWithCapacity((int)collection.size());
        for (Storable object : collection) {
            boolean isAdded = false;
            if (checkSuitable) {
                if (this._isObjectSuitable(object, param)) {
                    isAdded = true;
                }
            } else {
                isAdded = true;
            }
            arrayList.add(this.newInstanceTClass(isAdded, isSimple, object));
        }
        return arrayList;
    }

    public String usageInfoListAsString(Collection<UsageInfo> usageInfoList) {
        return usageInfoList.stream().map(usage -> usage.getReferer().toString()).collect(Collectors.joining("\n"));
    }

    public boolean isSimple() {
        return this.isSimple;
    }

    public Boolean getIsMultiTenant() {
        return this.isMultiTenant;
    }
}

