/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.ui.controls.entities;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang3.StringUtils;
import org.qubership.atp.integration.configuration.configuration.AuditAction;
import org.qubership.automation.itf.core.model.common.Storable;
import org.qubership.automation.itf.core.model.dataset.DataSetList;
import org.qubership.automation.itf.core.model.jpa.callchain.CallChain;
import org.qubership.automation.itf.core.model.jpa.message.parser.ParsingRule;
import org.qubership.automation.itf.core.model.jpa.step.AbstractCallChainStep;
import org.qubership.automation.itf.core.model.jpa.step.Step;
import org.qubership.automation.itf.core.model.jpa.system.System;
import org.qubership.automation.itf.core.model.jpa.system.operation.Operation;
import org.qubership.automation.itf.core.model.jpa.system.stub.Situation;
import org.qubership.automation.itf.core.model.regenerator.KeysRegeneratable;
import org.qubership.automation.itf.core.util.Pair;
import org.qubership.automation.itf.core.util.manager.CoreObjectManager;
import org.qubership.automation.itf.core.util.provider.ParsingRuleProvider;
import org.qubership.automation.itf.ui.controls.util.ControllerHelper;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class DataRegeneratorController
extends ControllerHelper {
    @Transactional
    @PreAuthorize(value="@entityAccess.checkAccess(#projectUuid, \"DELETE\")")
    @RequestMapping(value={"regenerator/key/delete"}, method={RequestMethod.DELETE})
    @AuditAction(auditAction="Delete Keys on Situation id {{#situationId}} / SituationStep id {{#situationStepId}} in the project {{#projectUuid}}")
    public void deleteKeys(@RequestParam(defaultValue="") String situationId, @RequestParam(defaultValue="") String situationStepId, @RequestBody String[] keys, @RequestParam(value="projectUuid") UUID projectUuid) {
    }

    @Transactional
    @PreAuthorize(value="@entityAccess.checkAccess(#projectUuid, \"READ\")")
    @RequestMapping(value={"regenerator/key/check"}, method={RequestMethod.POST})
    @AuditAction(auditAction="Check Keys on Situation id {{#situationId}} / SituationStep id {{#situationStepId}} in the project {{#projectId}}/{{#projectUuid}}")
    public List<Pair<String, String>> checkKeysBulk(@RequestParam(defaultValue="") String situationId, @RequestParam(defaultValue="") String situationStepId, @RequestBody List<String> keys, @RequestParam(value="projectId") BigInteger projectId, @RequestParam(value="projectUuid") UUID projectUuid) {
        KeysRegeneratable regeneratable = this.getKeysRegeneratable(situationId, situationStepId);
        ArrayList<Pair<String, String>> result = new ArrayList<Pair<String, String>>();
        keys.forEach(k -> {
            if (this.isKeyValid((String)k)) {
                result.add(new Pair(k, (Object)""));
            } else {
                result.add(new Pair(k, (Object)("ERROR. Key '" + k + "' can't be used, it must start with 'sp.' or 'tc.'")));
            }
        });
        if (regeneratable instanceof AbstractCallChainStep) {
            this.prepareCheckAgainstDatasets(result);
            this.areKeysDefinedInTc(regeneratable, result, projectUuid);
        } else if (regeneratable instanceof Situation) {
            this.prepareCheckAgainstParsingRules(result);
            Operation operation = (Operation)regeneratable.getParent();
            this.checkInParsingRuleProviderAndItsParent(result, (ParsingRuleProvider)operation);
        }
        return result;
    }

    private boolean isKeyValid(String key) {
        return key.matches("^(sp\\.|tc\\.)(\\S+)");
    }

    private void prepareCheckAgainstDatasets(List<Pair<String, String>> keys) {
        keys.forEach(k -> {
            if (((String)k.getValue()).isEmpty()) {
                if (((String)k.getKey()).startsWith("sp.")) {
                    k.setValue((Object)"WARNING. 'sp.'-members are not in the dataset");
                } else {
                    k.setKey((Object)((String)k.getKey()).substring(3));
                }
            }
        });
    }

    private void prepareCheckAgainstParsingRules(List<Pair<String, String>> keys) {
        keys.forEach(k -> {
            if (((String)k.getValue()).isEmpty()) {
                if (((String)k.getKey()).startsWith("sp.")) {
                    k.setKey((Object)((String)k.getKey()).substring(3));
                } else if (((String)k.getKey()).startsWith("tc.saved.")) {
                    k.setKey((Object)((String)k.getKey()).substring(9));
                } else {
                    k.setValue((Object)"WARNING. May be, it's better to change 'tc.' (not 'tc.saved.') variables on a callchain step?");
                }
            }
        });
    }

    private void areKeysDefinedInTc(KeysRegeneratable regeneratable, List<Pair<String, String>> keys, Object projectUuid) {
        if (this.allProcessed(keys)) {
            return;
        }
        Set compatibleDataSetLists = ((CallChain)regeneratable.getParent()).getCompatibleDataSetLists(projectUuid);
        if (compatibleDataSetLists == null || compatibleDataSetLists.isEmpty()) {
            keys.forEach(key -> key.setValue((Object)("ERROR. " + regeneratable.getParent().getName() + " has no defined dataset")));
            return;
        }
        for (DataSetList dataSetList : compatibleDataSetLists) {
            Set bufferedDataSetListVariables = dataSetList.getVariables();
            keys.forEach(key -> {
                if (bufferedDataSetListVariables.contains(key.getKey())) {
                    key.setValue((Object)dataSetList.getName());
                }
            });
            if (!this.allProcessed(keys)) continue;
            break;
        }
        keys.forEach(key -> {
            if (((String)key.getValue()).isEmpty()) {
                key.setValue((Object)"ERROR. Datasets don't contain the key");
            }
        });
    }

    private boolean allProcessed(List<Pair<String, String>> keys) {
        AtomicBoolean found = new AtomicBoolean(true);
        keys.forEach(key -> {
            if (((String)key.getValue()).isEmpty()) {
                found.set(false);
            }
        });
        return found.get();
    }

    private void checkInParsingRuleProviderAndItsParent(List<Pair<String, String>> keys, ParsingRuleProvider provider) {
        keys.forEach(key -> {
            if (((String)key.getValue()).isEmpty()) {
                boolean found = this.checkInParsingRuleProvider((Pair<String, String>)key, provider);
                if (!found) {
                    found = this.checkInParsingRuleProvider((Pair<String, String>)key, (ParsingRuleProvider)((System)provider.getParent()));
                }
                if (!found) {
                    key.setValue((Object)"Parsing rules wont't be overridden.");
                }
            }
        });
    }

    private boolean checkInParsingRuleProvider(Pair<String, String> key, ParsingRuleProvider provider) {
        String providerClass = provider.getClass().getSimpleName().toLowerCase();
        for (ParsingRule parsingRule : provider.returnParsingRules()) {
            if (parsingRule.getParamName() == null || !parsingRule.getParamName().equals(key.getKey())) continue;
            key.setValue((Object)("WARNING. Parsing rule '" + parsingRule.getParamName() + "' in " + providerClass + " '" + provider.getName() + "' will be overridden!"));
            return true;
        }
        return false;
    }

    private KeysRegeneratable getKeysRegeneratable(String situationId, String callChainStep) {
        KeysRegeneratable keysRegeneratable;
        boolean isSituation;
        if (StringUtils.isNotBlank((CharSequence)situationId)) {
            isSituation = true;
            keysRegeneratable = (KeysRegeneratable)CoreObjectManager.getInstance().getManager(Situation.class).getById((Object)situationId);
        } else if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{callChainStep})) {
            isSituation = false;
            keysRegeneratable = (AbstractCallChainStep)CoreObjectManager.getInstance().getManager(Step.class).getById((Object)callChainStep);
        } else {
            throw new IllegalArgumentException("Situation or CallChain Step id should be not blank.");
        }
        DataRegeneratorController.throwExceptionIfNull((Storable)keysRegeneratable, "", isSituation ? situationId : callChainStep, KeysRegeneratable.class, isSituation ? "get Situation by id" : "get CallChain Step by id");
        return keysRegeneratable;
    }
}

